/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.ModularGuiContainer;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiManipulable;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiSlots;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.container.ContainerGuiProvider;
import codechicken.lib.gui.modular.lib.container.ContainerScreenAccess;
import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.Direction;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.InfoPanel;
import com.brandon3055.brandonscore.client.gui.modulargui.ShaderEnergyBar;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.ButtonRow;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGenerator;
import com.brandon3055.draconicevolution.client.DEGuiTextures;
import com.brandon3055.draconicevolution.inventory.GeneratorMenu;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class GeneratorGui
extends ContainerGuiProvider<GeneratorMenu> {
    private static final GuiToolkit TOOLKIT = new GuiToolkit("gui.draconicevolution.generator");
    public static final int GUI_WIDTH = 176;
    public static final int GUI_HEIGHT = 166;
    private static final RenderType modelType = RenderType.m_110446_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/generator/generator_2.png"));
    private static final CCModel storageModel;

    public GuiElement<?> createRootElement(ModularGui gui) {
        GuiManipulable root = new GuiManipulable((GuiParent)gui).addMoveHandle(3).enableCursors(true);
        GuiTexture bg = new GuiTexture((GuiParent)root.getContentElement(), DEGuiTextures.themedGetter("generator"));
        Constraints.bind((ConstrainedGeometry)bg, (ConstrainedGeometry)root.getContentElement());
        return root;
    }

    public void buildGui(ModularGui gui, ContainerScreenAccess<GeneratorMenu> screenAccess) {
        gui.initStandardGui(176, 166);
        GeneratorMenu menu = (GeneratorMenu)screenAccess.m_6262_();
        TileGenerator tile = (TileGenerator)menu.tile;
        GuiElement root = gui.getRoot();
        TOOLKIT.createHeading((GuiParent)root, gui.getGuiTitle(), true);
        InfoPanel infoPanel = InfoPanel.create((GuiElement)root);
        infoPanel.labeledValue((Component)TOOLKIT.translate("fuel_efficiency", new Object[0]).m_130940_(ChatFormatting.GOLD), () -> Component.m_237113_((String)(((TileGenerator.Mode)tile.mode.get()).getEfficiency() + "%")).m_130940_(ChatFormatting.GRAY));
        infoPanel.labeledValue((Component)TOOLKIT.translate("output_power", new Object[0]).m_130940_(ChatFormatting.GOLD), () -> Component.m_237113_((String)(tile.productionRate.get() + " / " + ((TileGenerator.Mode)tile.mode.get()).powerOutput + " OP/t")).m_130940_(ChatFormatting.GRAY));
        infoPanel.labeledValue((Component)TOOLKIT.translate("current_fuel_value", new Object[0]).m_130940_(ChatFormatting.GOLD), () -> Component.m_237113_((String)(tile.fuelRemaining.get() == 0 ? "n/a" : tile.fuelRemaining.get() + " / " + tile.fuelValue.get())).m_130940_(ChatFormatting.GRAY));
        ButtonRow buttonRow = ButtonRow.topRightInside((GuiElement)root, (Direction)Direction.DOWN, (int)3, (int)3).setSpacing(1.0);
        buttonRow.addButton(e -> TOOLKIT.createThemeButton((GuiParent)e));
        buttonRow.addButton(e -> TOOLKIT.createInfoButton((GuiElement)e, infoPanel));
        buttonRow.addButton(e -> TOOLKIT.createRSSwitch((GuiParent)e, (IRSSwitchable)((GeneratorMenu)screenAccess.m_6262_()).tile));
        StorageRenderer fancyBg = new StorageRenderer((GuiParent<?>)root);
        Constraints.bind((ConstrainedGeometry)fancyBg, (ConstrainedGeometry)root);
        GuiSlots fuelInv = new GuiSlots((GuiParent)fancyBg, screenAccess, menu.fuel, 3).setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")).setEmptyIcon(BCGuiTextures.get((String)"slots/fuel"));
        Constraints.placeInside((ConstrainedGeometry)fuelInv, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)64.0, (double)28.0);
        GuiSlots.Player playInv = GuiSlots.player((GuiParent)root, screenAccess, (SlotGroup)menu.main, (SlotGroup)menu.hotBar);
        playInv.stream().forEach(e -> e.setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")));
        Constraints.placeInside((ConstrainedGeometry)playInv.container(), (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)-7.0);
        TOOLKIT.playerInvTitle(playInv.container());
        GuiSlots capInv = GuiSlots.singleSlot((GuiParent)root, screenAccess, (SlotGroup)menu.capacitor, (int)0).setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")).setEmptyIcon(BCGuiTextures.get((String)"slots/energy"));
        ShaderEnergyBar.EnergyBar energyBar = TOOLKIT.createEnergyBar((GuiParent)root, (IOPStorage)tile.opStorage);
        ((GuiRectangle)((GuiRectangle)((GuiRectangle)energyBar.container().constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)6.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)playInv.container().get(GeoParam.TOP), (double)-14.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)playInv.container().get(GeoParam.LEFT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)14.0));
        Constraints.placeInside((ConstrainedGeometry)capInv, (ConstrainedGeometry)energyBar.container(), (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_RIGHT, (double)20.0, (double)0.0);
        Constraints.placeOutside((ConstrainedGeometry)TOOLKIT.energySlotArrow((GuiParent)root, true, false), (ConstrainedGeometry)capInv, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)-2.0, (double)-2.0);
        GuiButton modButton = TOOLKIT.createFlat3DButton((GuiParent)root, () -> Component.m_237115_((String)((TileGenerator.Mode)tile.mode.get()).unlocalizedName()));
        modButton.onPress(() -> tile.mode.set((Enum)((TileGenerator.Mode)tile.mode.get()).next(Screen.m_96638_())), 0);
        modButton.onPress(() -> tile.mode.set((Enum)((TileGenerator.Mode)tile.mode.get()).next(true)), 1);
        Constraints.size((ConstrainedGeometry)modButton, (double)100.0, (double)14.0);
        Constraints.placeInside((ConstrainedGeometry)modButton, (ConstrainedGeometry)playInv.container(), (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)0.0, (double)-16.0);
    }

    static {
        Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/generator/generator_storage.obj")).quads().ignoreMtl().parse();
        storageModel = CCModel.combine(map.values());
        storageModel.computeNormals();
    }

    private static class StorageRenderer
    extends GuiElement<StorageRenderer>
    implements BackgroundRender {
        public StorageRenderer(@NotNull GuiParent<?> parent) {
            super(parent);
        }

        public double getBackgroundDepth() {
            return 100.0;
        }

        public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind(modelType, (MultiBufferSource)render.buffers());
            Matrix4 mat = new Matrix4(render.pose());
            mat.translate(this.xMin() + 90.0, this.yMin() + 45.0, 50.0);
            double mx = ((mouseX - this.getModularGui().xMin()) / (double)((float)this.getModularGui().xSize()) - 0.5) * (double)0.1f;
            double my = ((mouseY - this.getModularGui().yMin()) / (double)((float)this.getModularGui().ySize()) - 0.5) * (double)0.1f;
            mat.apply((Transformation)new Rotation(2.61799387799145, 1.0, 0.0, 0.0).with((Transformation)new Rotation(0.17453292519943, -my, 1.0 + mx, 0.0)));
            mat.scale(7.5);
            storageModel.render(ccrs, new IVertexOperation[]{mat});
        }
    }

    public static class Screen
    extends ModularGuiContainer<GeneratorMenu> {
        public Screen(GeneratorMenu menu, Inventory inv, Component title) {
            super((AbstractContainerMenu)menu, inv, (ContainerGuiProvider)new GeneratorGui());
            this.getModularGui().setGuiTitle(title);
        }
    }
}

