/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.draconicevolution.blocks.tileentity.TileStabilizedSpawner;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.MobSoul;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class StabilizedSpawnerLogic
extends BaseSpawner {
    private TileStabilizedSpawner tile;
    private double mobRotation;
    private double prevMobRotation;
    private int spawnRange = 4;

    public StabilizedSpawnerLogic(TileStabilizedSpawner tile) {
        this.tile = tile;
    }

    public void m_151319_(Level level, BlockPos pos) {
        if (!this.m_151343_(level, pos)) {
            this.prevMobRotation = this.mobRotation;
        } else {
            double d3 = (float)pos.m_123341_() + level.f_46441_.m_188501_();
            double d4 = (float)pos.m_123342_() + level.f_46441_.m_188501_();
            double d5 = (float)pos.m_123343_() + level.f_46441_.m_188501_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d3, d4, d5, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d3, d4, d5, 0.0, 0.0, 0.0);
            if (this.tile.spawnDelay.get() > 0) {
                this.tile.spawnDelay.dec();
            }
            this.prevMobRotation = this.mobRotation;
            this.mobRotation = (this.mobRotation + (double)(1000.0f / ((float)this.tile.spawnDelay.get() + 200.0f))) % 360.0;
        }
    }

    public void m_151311_(ServerLevel level, BlockPos pos) {
        if (this.m_151343_((Level)level, pos)) {
            if (this.tile.spawnDelay.get() == -1) {
                this.resetTimer();
            }
            if (this.tile.spawnDelay.get() > 0) {
                this.tile.spawnDelay.dec();
                return;
            }
            TileStabilizedSpawner.SpawnerTier tier = (TileStabilizedSpawner.SpawnerTier)this.tile.spawnerTier.get();
            boolean flag = false;
            int successCount = 0;
            for (int i = 0; i < tier.getSpawnCount() + tier.ordinal() + 3; ++i) {
                Entity entity = ((MobSoul)((Object)DEContent.MOB_SOUL.get())).createEntity((Level)level, this.tile.mobSoul.get());
                do {
                    double spawnX = (double)pos.m_123341_() + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * (double)this.spawnRange + 0.5;
                    double spawnY = pos.m_123342_() + level.f_46441_.m_188503_(3) - 1;
                    double spawnZ = (double)pos.m_123343_() + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * (double)this.spawnRange + 0.5;
                    entity.m_19890_(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
                } while (entity.m_20183_().m_123341_() == this.tile.m_58899_().m_123341_() && entity.m_20183_().m_123343_() == this.tile.m_58899_().m_123343_());
                int nearbyCount = level.m_45976_(entity.getClass(), new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)).m_82400_((double)this.spawnRange)).size();
                if (nearbyCount >= tier.getMaxCluster()) {
                    this.resetTimer();
                    return;
                }
                LivingEntity entityliving = entity instanceof LivingEntity ? (LivingEntity)entity : null;
                entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), level.f_46441_.m_188501_() * 360.0f, 0.0f);
                if (entityliving == null || !(entityliving instanceof Mob) || this.canEntitySpawnSpawner((Mob)entityliving, (ServerLevel)this.tile.m_58904_(), (float)entity.m_20185_(), (float)entity.m_20186_(), (float)entity.m_20189_(), this)) {
                    if (!tier.requiresPlayer() && entity instanceof Mob) {
                        ((Mob)entity).m_21530_();
                        entity.getPersistentData().m_128356_("DESpawnedMob", System.currentTimeMillis());
                        DEEventHandler.onMobSpawnedBySpawner((Mob)entity);
                    }
                    if (!level.m_8860_(entity)) {
                        this.resetTimer();
                        return;
                    }
                    level.m_46796_(2004, pos, 0);
                    if (entityliving != null) {
                        if (entity instanceof Mob) {
                            ((Mob)entity).m_21373_();
                        }
                        if (tier == TileStabilizedSpawner.SpawnerTier.CHAOTIC) {
                            double velocity = 2.5;
                            entity.m_20334_((level.f_46441_.m_188500_() - 0.5) * velocity, level.f_46441_.m_188500_() * velocity, (level.f_46441_.m_188500_() - 0.5) * velocity);
                        }
                    }
                    flag = true;
                    ++successCount;
                }
                if (successCount >= tier.getSpawnCount()) break;
            }
            if (flag) {
                this.resetTimer();
            }
        }
    }

    public boolean canEntitySpawnSpawner(Mob entity, ServerLevel level, float x, float y, float z, BaseSpawner spawner) {
        MobSpawnEvent.PositionCheck event = new MobSpawnEvent.PositionCheck(entity, (ServerLevelAccessor)level, MobSpawnType.SPAWNER, null);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DEFAULT) {
            return (((TileStabilizedSpawner.SpawnerTier)this.tile.spawnerTier.get()).ignoreSpawnReq() || entity.m_5545_((LevelAccessor)level, MobSpawnType.SPAWNER)) && entity.m_6914_((LevelReader)level);
        }
        return event.getResult() == Event.Result.ALLOW;
    }

    private void resetTimer() {
        TileStabilizedSpawner.SpawnerTier tier = (TileStabilizedSpawner.SpawnerTier)this.tile.spawnerTier.get();
        if (tier.getMaxDelay() <= tier.getMinDelay()) {
            this.tile.spawnDelay.set((short)tier.getMinDelay());
        } else {
            int i = tier.getMaxDelay() - tier.getMinDelay();
            this.tile.spawnDelay.set((short)(tier.getMinDelay() + this.tile.m_58904_().f_46441_.m_188503_(i)));
        }
        this.m_142523_(this.tile.m_58904_(), this.tile.m_58899_(), 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double m_45473_() {
        return this.mobRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double m_45474_() {
        return this.prevMobRotation;
    }

    public CompoundTag m_186381_(CompoundTag compound) {
        return compound;
    }

    public void m_151328_(@Nullable Level level, BlockPos pos, CompoundTag tag) {
    }

    @Nullable
    public BlockEntity getSpawnerBlockEntity() {
        return this.tile;
    }

    public boolean m_151316_(Level level, int delay) {
        return false;
    }

    @Nullable
    public Entity m_253067_(Level pLevel, RandomSource pRandom, BlockPos pPos) {
        return this.tile.getRenderEntity();
    }

    public void m_142523_(Level level, BlockPos blockPos, int event) {
        level.m_7696_(blockPos, Blocks.f_50085_, event, 0);
    }

    public boolean m_151343_(Level p_151344_, BlockPos p_151345_) {
        return this.tile.isActive();
    }
}

