/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.brandonscore.lib.CustomTabHandling;
import com.brandon3055.brandonscore.multiblock.StructurePart;
import com.brandon3055.draconicevolution.blocks.tileentity.MultiBlockController;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStructureBlock;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureBlock
extends EntityBlockBCore
implements StructurePart,
CustomTabHandling {
    public static boolean buildingLock = false;

    public StructureBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.setBlockEntity(() -> DEContent.TILE_STRUCTURE_BLOCK.get(), false);
        this.dontSpawnOnMe();
        this.setLightTransparent();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        this.neighborChanged(world, pos);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.neighborChanged((LevelReader)world, pos);
    }

    private void neighborChanged(LevelReader world, BlockPos pos) {
        TileStructureBlock tile;
        if (buildingLock) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileStructureBlock && ((tile = (TileStructureBlock)blockEntity).getController() == null || !tile.getController().isStructureValid())) {
            tile.debug("Structure Block: Reverting from neighborChanged");
            tile.revert();
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileStructureBlock) {
            TileStructureBlock structureTile = (TileStructureBlock)tile;
            ResourceLocation blockName = structureTile.blockName.get();
            if (blockName != null) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockName);
                MultiBlockController controller = structureTile.getController();
                world.m_7471_(pos, false);
                if (block != Blocks.f_50016_ && !player.m_150110_().f_35937_) {
                    StructureBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)block));
                }
                if (controller != null) {
                    controller.validateStructure();
                }
            }
        }
        this.m_5707_(world, pos, state, player);
        return true;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileStructureBlock) {
            TileStructureBlock structureTile = (TileStructureBlock)tile;
            ResourceLocation blockName = structureTile.blockName.get();
            if (blockName != null) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockName);
                return new ItemStack((ItemLike)block);
            }
        }
        return ItemStack.f_41583_;
    }

    public VoxelShape m_5939_(BlockState p_60572_, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext p_60575_) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_7952_(BlockState p_60578_, BlockGetter p_60579_, BlockPos p_60580_) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity instanceof TileStructureBlock) {
            TileStructureBlock tile = (TileStructureBlock)blockEntity;
            return tile.getShape(context);
        }
        return super.m_5940_(state, getter, pos, context);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileStructureBlock) {
            TileStructureBlock tile = (TileStructureBlock)blockEntity;
            tile.debug("Structure Block: Block Tick doRevert");
            tile.doRevert();
        }
        super.m_213897_(state, level, pos, random);
    }

    public boolean is(Level level, BlockPos pos, TagKey<Block> key) {
        return StructureBlock.getBlock(level, pos).m_49966_().m_204336_(key);
    }

    public boolean is(Level level, BlockPos pos, Block block) {
        return StructureBlock.getBlock(level, pos).m_49966_().m_60713_(block);
    }

    public static Block getBlock(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileStructureBlock) {
            TileStructureBlock tile = (TileStructureBlock)blockEntity;
            ResourceLocation name = tile.blockName.get();
            if (name != null) {
                return (Block)ForgeRegistries.BLOCKS.getValue(name);
            }
        }
        return Blocks.f_50016_;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter getter, BlockPos pos) {
        TileStructureBlock tile;
        Block block;
        float f = state.m_60800_(getter, pos);
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity instanceof TileStructureBlock && (block = (tile = (TileStructureBlock)blockEntity).getOriginalBlock()) != Blocks.f_50016_) {
            f = block.m_49966_().m_60800_(getter, pos);
        }
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) ? 30 : 100;
        return player.getDigSpeed(state, pos) / f / (float)i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderSelectionBox(RenderHighlightEvent.Block event, Level level) {
        BlockEntity blockEntity = level.m_7702_(event.getTarget().m_82425_());
        if (blockEntity instanceof TileStructureBlock) {
            TileStructureBlock tile = (TileStructureBlock)blockEntity;
            return tile.renderSelectionBox(event);
        }
        return true;
    }
}

