/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.FlightData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;

public class FlightEntity
extends ModuleEntity<FlightData> {
    private BooleanProperty elytraEnabled = null;
    private BooleanProperty creativeEnabled = null;
    private DecimalProperty elytraBoost = null;

    public FlightEntity(Module<FlightData> module) {
        super(module);
        if (module.getData().elytra()) {
            this.elytraEnabled = new BooleanProperty("flight_mod.elytra", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);
            this.addProperty(this.elytraEnabled);
            this.elytraBoost = new DecimalProperty("flight_mod.elytra_boost", module.getData().elytraSpeed()).setFormatter(ConfigProperty.DecimalFormatter.PERCENT_0).range(0.0, module.getData().elytraSpeed());
            this.addProperty(this.elytraBoost);
        }
        if (module.getData().creative()) {
            this.creativeEnabled = new BooleanProperty("flight_mod.creative", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);
            this.addProperty(this.creativeEnabled);
        }
        this.savePropertiesToItem = true;
    }

    @Override
    public void onInstalled(ModuleContext context) {
    }

    public boolean getElytraEnabled() {
        return this.elytraEnabled != null && this.elytraEnabled.getValue();
    }

    public boolean getCreativeEnabled() {
        return this.creativeEnabled != null && this.creativeEnabled.getValue();
    }

    public double getElytraBoost() {
        return this.elytraBoost != null ? this.elytraBoost.getValue() : 0.0;
    }
}

