/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.config;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class IntegerProperty
extends ConfigProperty {
    private int value;
    private int defaultValue;
    private ConfigProperty.IntegerFormatter formatter = ConfigProperty.IntegerFormatter.RAW;
    private Supplier<Integer> min = () -> Integer.MIN_VALUE;
    private Supplier<Integer> max = () -> Integer.MAX_VALUE;
    private BiConsumer<ItemStack, IntegerProperty> changeListener = null;

    public IntegerProperty(String name, int defaultValue) {
        super(name);
        this.value = this.defaultValue = defaultValue;
    }

    public IntegerProperty(String name, Component displayName, int defaultValue) {
        super(name, displayName);
        this.value = this.defaultValue = defaultValue;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = MathHelper.clip((int)value, (int)this.getMin(), (int)this.getMax());
    }

    public IntegerProperty min(int minValue) {
        this.min = () -> minValue;
        this.validateValue();
        return this;
    }

    public IntegerProperty min(Supplier<Integer> minSupplier) {
        this.min = minSupplier;
        this.validateValue();
        return this;
    }

    public IntegerProperty max(int maxValue) {
        this.max = () -> maxValue;
        this.validateValue();
        return this;
    }

    public IntegerProperty max(Supplier<Integer> maxSupplier) {
        this.max = maxSupplier;
        this.validateValue();
        return this;
    }

    public IntegerProperty range(int minValue, int maxValue) {
        this.min = () -> minValue;
        this.max = () -> maxValue;
        this.validateValue();
        return this;
    }

    public IntegerProperty range(Supplier<Integer> minSupplier, Supplier<Integer> maxSupplier) {
        this.min = minSupplier;
        this.max = maxSupplier;
        this.validateValue();
        return this;
    }

    public int getMin() {
        return this.min.get();
    }

    public int getMax() {
        return this.max.get();
    }

    @Override
    public String getDisplayValue() {
        return this.formatter.format(this.getValue());
    }

    @Override
    public void onValueChanged(ItemStack stack) {
        if (this.changeListener != null) {
            this.changeListener.accept(stack, this);
        }
    }

    @Override
    public void validateValue() {
        this.value = Math.max(this.min.get(), Math.min(this.max.get(), this.value));
    }

    @Override
    public ConfigProperty.Type getType() {
        return ConfigProperty.Type.INTEGER;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = (stack, integerProperty) -> changeListener.run();
    }

    public void setChangeListener(Consumer<ItemStack> changeListener) {
        this.changeListener = (stack, integerProperty) -> changeListener.accept((ItemStack)stack);
    }

    public void setChangeListener(BiConsumer<ItemStack, IntegerProperty> changeListener) {
        this.changeListener = changeListener;
    }

    public IntegerProperty setFormatter(ConfigProperty.IntegerFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public ConfigProperty.IntegerFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.value != this.defaultValue) {
            nbt.m_128405_("value", this.value);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("value")) {
            this.value = nbt.m_128451_("value");
        }
        this.value = Math.max(this.min.get(), Math.min(this.max.get(), this.value));
        super.deserializeNBT(nbt);
    }

    @Override
    public void serializeMCData(MCDataOutput output) {
        super.serializeMCData(output);
        output.writeInt(this.value);
    }

    @Override
    public void deSerializeMCData(MCDataInput input) {
        super.deSerializeMCData(input);
        this.value = Math.max(this.min.get(), Math.min(this.max.get(), input.readInt()));
    }

    @Override
    public void loadData(PropertyData data, ItemStack stack) {
        this.value = Math.max(this.min.get(), Math.min(this.max.get(), data.integerValue));
        this.onValueChanged(stack);
    }
}

