/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution;

import com.brandon3055.draconicevolution.CommonProxy;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IngredientStack;
import com.brandon3055.draconicevolution.client.ClientProxy;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.command.DECommands;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.handlers.LootEventHandler;
import com.brandon3055.draconicevolution.handlers.ModularArmorEventHandler;
import com.brandon3055.draconicevolution.handlers.ModuleEventHandler;
import com.brandon3055.draconicevolution.init.ClientInit;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DECreativeTabs;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.DETags;
import com.brandon3055.draconicevolution.init.ModCapabilities;
import com.brandon3055.draconicevolution.integration.computers.ComputerCraftCompatEventHandler;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.OptionalMod;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="draconicevolution")
public class DraconicEvolution {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "draconicevolution";
    public static final String MODNAME = "Draconic Evolution";
    public static CommonProxy proxy;

    public DraconicEvolution() {
        proxy = (CommonProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        CraftingHelper.register((ResourceLocation)DraconicAPI.INGREDIENT_STACK_TYPE, (IIngredientSerializer)IngredientStack.SERIALIZER);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        DEConfig.load();
        DETags.init();
        DEContent.init();
        DEModules.init();
        DESounds.init();
        DEParticles.init();
        DECreativeTabs.init();
        DraconicNetwork.init();
        EquipmentManager.initialize();
        DECommands.init();
        ModCapabilities.init();
        LootEventHandler.init();
        ModuleEventHandler.init(modBus);
        ModularArmorEventHandler.init();
        OptionalMod.of((String)"computercraft").ifPresent(e -> MinecraftForge.EVENT_BUS.register((Object)new ComputerCraftCompatEventHandler()));
        MinecraftForge.EVENT_BUS.addListener(Dislocator::onAnvilUpdate);
        MinecraftForge.EVENT_BUS.register((Object)new DEEventHandler());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientInit::init);
        DraconicAPI.addModuleProvider(MODID);
    }
}

