/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity.core.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import org.jetbrains.annotations.Nullable;

public class LookAtLivingEntityGoal
extends Goal {
    public static final float DEFAULT_PROBABILITY = 0.02f;
    protected final Mob mob;
    @Nullable
    protected LivingEntity lookAt;
    protected final float lookDistance;
    private int lookTime;
    protected final float probability;
    private final boolean onlyHorizontal;
    protected final TargetingConditions lookAtContext;

    public LookAtLivingEntityGoal(Mob mob, float lookDistance) {
        this(mob, lookDistance, 0.02f);
    }

    public LookAtLivingEntityGoal(Mob mob, float lookDistance, float probability) {
        this(mob, lookDistance, probability, false);
    }

    public LookAtLivingEntityGoal(Mob mob, float lookDistance, float probability, boolean onlyHorizontal) {
        this.mob = mob;
        this.lookDistance = lookDistance;
        this.probability = probability;
        this.onlyHorizontal = onlyHorizontal;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        this.lookAtContext = TargetingConditions.m_148353_().m_26883_((double)lookDistance).m_26888_(entity -> entity instanceof LivingEntity && entity != mob);
    }

    public boolean m_8036_() {
        if (this.mob.m_217043_().m_188501_() >= this.probability) {
            return false;
        }
        this.lookAt = this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(LivingEntity.class, this.mob.m_20191_().m_82400_((double)this.lookDistance), entity -> true), this.lookAtContext, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
        return this.lookAt != null;
    }

    public boolean m_8045_() {
        if (this.lookAt == null || !this.lookAt.m_6084_()) {
            return false;
        }
        double distanceSq = this.mob.m_20280_((Entity)this.lookAt);
        return distanceSq <= (double)(this.lookDistance * this.lookDistance) && this.lookTime > 0;
    }

    public void m_8056_() {
        this.lookTime = 40 + this.mob.m_217043_().m_188503_(40);
    }

    public void m_8041_() {
        this.lookAt = null;
    }

    public void m_8037_() {
        if (this.lookAt != null && this.lookAt.m_6084_()) {
            double targetY = this.onlyHorizontal ? this.mob.m_20188_() : this.lookAt.m_20188_();
            this.mob.m_21563_().m_24946_(this.lookAt.m_20185_(), targetY, this.lookAt.m_20189_());
            --this.lookTime;
        }
    }
}

