/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyHurtByTargetGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyPanicGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.DistancedFollowParentGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.SmoothFloatGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.MMPathNavigatorGround;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Hippo
extends NaturalistAnimal
implements NaturalistGeoEntity {
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.hippo.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.sf_nba.hippo.walk");
    protected static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.sf_nba.hippo.run");
    protected static final RawAnimation BITE = RawAnimation.begin().thenPlay("animation.sf_nba.hippo.bite");
    protected static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.sf_nba.hippo.swim");
    protected static final RawAnimation SWIM_IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.hippo.swim_idle");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50186_.m_5456_()});
    private int eatingTicks;

    public Hippo(EntityType<? extends NaturalistAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_274367_(1.0f);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper((Mob)this);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new MMPathNavigatorGround((Mob)this, level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 0.6);
    }

    public static boolean checkHippoSpawnRules(EntityType<? extends NaturalistAnimal> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        if (levelAccessor.m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_184228_) && Animal.m_186209_((BlockAndTintGetter)levelAccessor, (BlockPos)blockPos)) {
            for (int x = -16; x <= 16; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -16; z <= 16; ++z) {
                        mutableBlockPos.m_122154_((Vec3i)blockPos, x, y, z);
                        if (!levelAccessor.m_46805_((BlockPos)mutableBlockPos) || !levelAccessor.m_6425_((BlockPos)mutableBlockPos).m_205070_(FluidTags.f_13131_)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    public boolean m_6040_() {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SmoothFloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new HippoAttackBoatsGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21345_.m_25352_(5, (Goal)new BabyPanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(6, (Goal)new DistancedFollowParentGoal(this, 1.25, 8.0, 2.0, 5.0));
        this.f_21345_.m_25352_(7, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new BabyHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> !this.m_6162_() && entity.m_20069_()));
    }

    public void m_8024_() {
        super.m_8024_();
        if (this.m_21566_().m_24995_()) {
            this.m_6858_(this.m_21566_().m_24999_() >= 1.0);
        } else {
            this.m_6858_(false);
        }
    }

    public InteractionResult m_6071_(@NotNull Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (this.m_6898_(itemStack)) {
            int age = this.m_146764_();
            if (!this.m_9236_().f_46443_ && age == 0 && this.m_5957_()) {
                this.eatingTicks = 10;
                this.m_8061_(EquipmentSlot.MAINHAND, itemStack.m_41777_());
                this.m_6674_(InteractionHand.MAIN_HAND);
                float yRot = (this.m_146908_() + 90.0f) * ((float)Math.PI / 180);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50186_.m_49966_()), this.m_20185_() + Math.cos(yRot), this.m_20186_() + 0.6, this.m_20189_() + Math.sin(yRot), 100, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42575_)), this.m_20185_() + Math.cos(yRot), this.m_20186_() + 0.6, this.m_20189_() + Math.sin(yRot), 100, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
                this.m_216990_(SoundEvents.f_11976_);
                this.m_216990_(SoundEvents.f_12630_);
                this.m_142075_(player, hand, itemStack);
                this.m_27595_(player);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_142075_(player, hand, itemStack);
                this.m_146740_(Animal.m_216967_((int)(-age)), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.eatingTicks > 0) {
                --this.eatingTicks;
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
        }
    }

    public double m_20204_() {
        if (this.m_6162_()) {
            return 0.2f;
        }
        return 1.0;
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pose) {
        if (this.m_6162_()) {
            return super.m_6972_(pose).m_20388_(1.5f);
        }
        return super.m_6972_(pose);
    }

    protected float m_6108_() {
        return 0.98f;
    }

    public boolean m_7848_(Animal otherAnimal) {
        return this.m_20069_() && otherAnimal.m_20069_() && super.m_7848_(otherAnimal);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)NaturalistEntityTypes.HIPPO.get().m_20615_((Level)serverLevel);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return NaturalistSoundEvents.HIPPO_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return NaturalistSoundEvents.HIPPO_AMBIENT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <E extends Hippo> PlayState predicate(@NotNull AnimationState<E> event) {
        event.getController().setAnimationSpeed(0.8 + (double)event.getLimbSwingAmount());
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            if (!this.m_20069_()) {
                if (this.m_20142_()) {
                    event.getController().setAnimation(RUN);
                } else {
                    event.getController().setAnimation(WALK);
                }
            } else if (this.m_20069_()) {
                event.getController().setAnimation(SWIM);
            }
            return PlayState.CONTINUE;
        }
        if (this.m_20069_()) {
            event.getController().setAnimation(SWIM_IDLE);
        } else {
            event.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    private <E extends Hippo> PlayState attackPredicate(AnimationState<E> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(BITE);
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate)});
    }

    static class HippoAttackBoatsGoal
    extends Goal {
        protected final PathfinderMob mob;
        private final double speedModifier;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private Boat target;

        public HippoAttackBoatsGoal(PathfinderMob pathfinderMob, double speedModifier) {
            this.mob = pathfinderMob;
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            if (this.mob.m_6162_()) {
                return false;
            }
            long gameTime = this.mob.m_9236_().m_46467_();
            if (gameTime - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = gameTime;
            List entities = this.mob.m_9236_().m_45976_(Boat.class, this.mob.m_20191_().m_82377_(8.0, 4.0, 8.0));
            if (!entities.isEmpty()) {
                this.target = (Boat)entities.get(0);
            }
            if (this.target == null) {
                return false;
            }
            if (this.target.m_213877_()) {
                return false;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)this.target, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr((Entity)this.target) >= this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        }

        public boolean m_8045_() {
            if (this.target == null) {
                return false;
            }
            if (this.target.m_213877_()) {
                return false;
            }
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public void m_8041_() {
            LivingEntity livingEntity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingEntity)) {
                this.mob.m_6710_(null);
            }
            this.mob.m_21561_(false);
            this.mob.m_21573_().m_26573_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target == null) {
                return;
            }
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            double d = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if (this.mob.m_21574_().m_148306_((Entity)this.target) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || this.target.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = this.target.m_20185_();
                this.pathedTargetY = this.target.m_20186_();
                this.pathedTargetZ = this.target.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                if (d > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack((Entity)this.target, d);
        }

        protected void checkAndPerformAttack(Entity enemy, double distToEnemySqr) {
            double reach = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= reach && this.ticksUntilNextAttack <= 0) {
                this.resetAttackCooldown();
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_(enemy);
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.m_183277_(20);
        }

        protected double getAttackReachSqr(Entity attackTarget) {
            return Mth.m_14207_((float)(this.mob.m_20205_() * 1.2f)) + attackTarget.m_20205_();
        }
    }
}

