/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.block;

import com.starfish_studios.naturalist.common.entity.Tortoise;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TortoiseEggBlock
extends TurtleEggBlock {
    public static final IntegerProperty VARIANT = IntegerProperty.m_61631_((String)"variant", (int)0, (int)2);

    public TortoiseEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_57753_, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_57754_, (Comparable)Integer.valueOf(1))).m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VARIANT});
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        stack.m_41784_().m_128405_("Variant", ((Integer)state.m_61143_((Property)VARIANT)).intValue());
        return stack;
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, BlockPos pos, @NotNull RandomSource random) {
        if (!this.shouldUpdateHatchLevel((Level)level)) {
            return;
        }
        int hatchStage = (Integer)state.m_61143_((Property)f_57753_);
        if (hatchStage < 2) {
            level.m_5594_(null, pos, NaturalistSoundEvents.TORTOISE_EGG_CRACK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57753_, (Comparable)Integer.valueOf(hatchStage + 1)), 2);
        } else {
            level.m_5594_(null, pos, NaturalistSoundEvents.TORTOISE_EGG_HATCH.get(), SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
            int eggCount = (Integer)state.m_61143_((Property)f_57754_);
            int variant = (Integer)state.m_61143_((Property)VARIANT);
            level.m_7471_(pos, false);
            for (int i = 0; i < eggCount; ++i) {
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                Tortoise baby = (Tortoise)NaturalistEntityTypes.TORTOISE.get().m_20615_((Level)level);
                if (baby == null) continue;
                baby.setVariant(variant);
                baby.m_146762_(-24000);
                double x = (double)pos.m_123341_() + 0.3 + (double)i * 0.2;
                double y = pos.m_123342_();
                double z = (double)pos.m_123343_() + 0.3;
                baby.m_7678_(x, y, z, 0.0f, 0.0f);
                level.m_7967_((Entity)baby);
            }
        }
    }

    public void m_6807_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        if (!level.f_46443_) {
            level.m_46796_(2005, pos, 0);
        }
    }

    private boolean shouldUpdateHatchLevel(@NotNull Level level) {
        return level.f_46441_.m_188503_(500) == 0;
    }

    public void m_141947_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Entity entity) {
        if (!entity.m_20161_()) {
            this.destroyEgg(level, state, pos, entity, 100);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void m_142072_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, float fallDistance) {
        if (!(entity instanceof Zombie)) {
            this.destroyEgg(level, state, pos, entity, 3);
        }
        super.m_142072_(level, state, pos, entity, fallDistance);
    }

    private void destroyEgg(@NotNull Level level, BlockState state, BlockPos pos, Entity entity, int chance) {
        if (!this.canDestroyEgg(level, entity)) {
            return;
        }
        if (!level.f_46443_ && level.f_46441_.m_188503_(chance) == 0 && state.m_60713_(Blocks.f_50578_)) {
            this.decreaseEggs(level, pos, state);
        }
    }

    public void m_6240_(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack stack) {
        super.m_6240_(level, player, pos, state, blockEntity, stack);
        if (!level.f_46443_ && stack.m_41720_() == Items.f_42116_) {
            int variant = (Integer)state.m_61143_((Property)VARIANT);
            int eggCount = (Integer)state.m_61143_((Property)f_57754_);
            level.m_5594_(null, pos, NaturalistSoundEvents.TORTOISE_EGG_HATCH.get(), SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            level.m_7471_(pos, false);
            for (int i = 0; i < eggCount; ++i) {
                Tortoise baby = (Tortoise)NaturalistEntityTypes.TORTOISE.get().m_20615_(level);
                if (baby == null) continue;
                baby.setVariant(variant);
                baby.m_146762_(-24000);
                double dx = (double)pos.m_123341_() + 0.3 + (double)i * 0.2;
                double dy = pos.m_123342_();
                double dz = (double)pos.m_123343_() + 0.3;
                baby.m_7678_(dx, dy, dz, 0.0f, 0.0f);
                level.m_7967_((Entity)baby);
            }
        }
    }

    private boolean canDestroyEgg(@NotNull Level level, Entity entity) {
        if (!(entity instanceof Tortoise) && !entity.m_6095_().m_204039_(NaturalistTags.EntityTypes.SAFE_EGG_WALKERS)) {
            if (!(entity instanceof LivingEntity)) {
                return false;
            }
            return entity instanceof Player || level.m_46469_().m_46207_(GameRules.f_46132_);
        }
        return false;
    }

    private void decreaseEggs(Level level, BlockPos pos, BlockState state) {
        level.m_5594_(null, pos, NaturalistSoundEvents.TORTOISE_EGG_BREAK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
        int i = (Integer)state.m_61143_((Property)f_57754_);
        if (i <= 1) {
            level.m_46961_(pos, false);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57754_, (Comparable)Integer.valueOf(i - 1)), 2);
            level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }
}

