/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import edivad.dimstorage.client.screen.ScreenDimChest;
import edivad.dimstorage.client.screen.ScreenDimTablet;
import edivad.dimstorage.client.screen.ScreenDimTank;
import edivad.dimstorage.compat.top.TOPProvider;
import edivad.dimstorage.datagen.AdvancementProvider;
import edivad.dimstorage.datagen.Lang;
import edivad.dimstorage.datagen.LootTables;
import edivad.dimstorage.datagen.Recipes;
import edivad.dimstorage.datagen.TagsProvider;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.network.PacketHandler;
import edivad.dimstorage.plugin.DimChestPlugin;
import edivad.dimstorage.plugin.DimTankPlugin;
import edivad.dimstorage.setup.ClientSetup;
import edivad.dimstorage.setup.Config;
import edivad.dimstorage.setup.DimStorageCreativeModeTabs;
import edivad.dimstorage.setup.Registration;
import edivad.dimstorage.tools.DimCommands;
import edivad.edivadlib.setup.UpdateChecker;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="dimstorage")
public class DimStorage {
    public static final String ID = "dimstorage";
    public static final String MODNAME = "DimStorage";
    public static final Logger LOGGER = LogUtils.getLogger();

    public DimStorage() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        Registration.init(modEventBus);
        modEventBus.addListener(this::handleCommonSetup);
        modEventBus.addListener(this::handleClientSetup);
        modEventBus.addListener(this::handleGatherData);
        DimStorageCreativeModeTabs.register(modEventBus);
        Config.init();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientSetup.init(modEventBus);
        }
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::handleServerStarted);
    }

    private void handleCommonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
        DimStorageManager.registerPlugin(new DimChestPlugin());
        DimStorageManager.registerPlugin(new DimTankPlugin());
        MinecraftForge.EVENT_BUS.register((Object)new DimStorageManager.DimStorageSaveHandler());
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPProvider::new);
        }
    }

    private void handleClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new UpdateChecker(ID));
        MenuScreens.m_96206_((MenuType)((MenuType)Registration.DIMCHEST_CONTAINER.get()), ScreenDimChest::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Registration.DIMTABLET_CONTAINER.get()), ScreenDimTablet::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Registration.DIMTANK_CONTAINER.get()), ScreenDimTank::new);
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new Recipes(packOutput));
        generator.addProvider(event.includeServer(), LootTables::create);
        generator.addProvider(event.includeServer(), (DataProvider)new TagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new Lang(packOutput));
    }

    private void registerCommands(RegisterCommandsEvent event) {
        DimCommands.init((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void handleServerStarted(ServerStartedEvent event) {
        DimStorageManager.reloadManager(false);
    }
}

