/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_chicken;

import com.mojang.logging.LogUtils;
import com.oierbravo.create_mechanical_chicken.ModRegistration;
import com.oierbravo.create_mechanical_chicken.foundation.data.recipe.FluidExistsCondition;
import com.oierbravo.create_mechanical_chicken.infrastructure.data.ModDataGen;
import com.oierbravo.create_mechanical_chicken.ponders.ModPonderPlugin;
import com.oierbravo.create_mechanical_chicken.registrate.ModConfigs;
import com.oierbravo.create_mechanical_chicken.registrate.ModCreativeTabs;
import com.oierbravo.create_mechanical_chicken.registrate.ModPartials;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="create_mechanical_chicken")
public class CreateMechanicalChicken {
    public static final String MODID = "create_mechanical_chicken";
    public static final String DISPLAY_NAME = "Create Mechanical Chicken";
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"create_mechanical_chicken");
    public static final Logger LOGGER;

    public CreateMechanicalChicken() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModConfigs.register();
        REGISTRATE.registerEventListeners(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModRegistration.init();
        modEventBus.addListener(this::doClientStuff);
        modEventBus.addListener(ModDataGen::gatherData);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ModPartials::load);
        CraftingHelper.register((IConditionSerializer)new FluidExistsCondition.Serializer());
        this.generateLangEntries();
    }

    private void generateLangEntries() {
        CreateMechanicalChicken.registerLangCustom("itemGroup.create_mechanical_chicken:main", DISPLAY_NAME);
        CreateMechanicalChicken.registerLangCustom("config.jade.plugin_create_mechanical_chicken.data", "Mechanical chicken data");
        CreateMechanicalChicken.registerLang("chicken.tooltip.progress", "Progress: %d%%");
        CreateMechanicalChicken.registerLangCustom("block.create_mechanical_chicken.mechanical_chicken.tooltip", "MECHANICAL Chicken");
        CreateMechanicalChicken.registerLangCustom("block.create_mechanical_chicken.mechanical_chicken.tooltip.summary", "Chicken _Egg_ generator.");
        CreateMechanicalChicken.registerLang("ponder.mechanical_chicken.header", "Generates chicken eggs");
        CreateMechanicalChicken.registerLang("ponder.mechanical_chicken.text_1", "The Mechanical Chicken uses rotational force and an specific fluid to generate eggs");
        CreateMechanicalChicken.registerLang("ponder.mechanical_chicken.text_2", "Its powered from the bottom");
        CreateMechanicalChicken.registerLang("ponder.mechanical_chicken.text_3", "Fluid input can ONLY go from the FRONT side");
        CreateMechanicalChicken.registerLang("ponder.mechanical_chicken.text_4", "Egg output is ONLY located on the BACK side");
        CreateMechanicalChicken.registerLang("ponder.mechanical_chicken.text_5", "Can only be extracted by automation");
        CreateMechanicalChicken.registerLang("recipe", "Mechanical Chicken Recipe");
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        PonderIndex.addPlugin((PonderPlugin)new ModPonderPlugin());
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static void registerLang(String id, String text) {
        CreateMechanicalChicken.registerLangCustom(MODID.toLowerCase() + "." + id, text);
    }

    public static void registerLangCustom(String id, String text) {
        CreateMechanicalChicken.registrate().addRawLang(id, text);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
        LOGGER = LogUtils.getLogger();
    }
}

