/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.transformer;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.ContentListing;
import slimeknights.mantle.client.book.data.content.ContentPadding;
import slimeknights.mantle.client.book.transformer.IndexTransformer;
import slimeknights.mantle.client.book.transformer.SectionTransformer;
import slimeknights.mantle.client.screen.book.TextDataRenderer;

public class ContentGroupingSectionTransformer
extends SectionTransformer {
    private static final ResourceLocation INDEX_EXTRA_DATA = Mantle.getResource("index");
    private final Boolean largeTitle;
    private final Boolean centerTitle;

    public ContentGroupingSectionTransformer(String sectionName, @Nullable Boolean largeTitle, @Nullable Boolean centerTitle) {
        super(sectionName);
        this.largeTitle = largeTitle;
        this.centerTitle = centerTitle;
    }

    public ContentGroupingSectionTransformer(String sectionName) {
        this(sectionName, null, null);
    }

    @Override
    public void transform(BookData book, SectionData data) {
        String title = book.translate(this.sectionName);
        String subtextKey = this.sectionName + ".subtext";
        String subText = null;
        if (book.strings.containsKey(subtextKey)) {
            subText = book.translate(subtextKey);
        }
        GroupingBuilder builder = new GroupingBuilder(data, title, subText, this.largeTitle, this.centerTitle);
        data.pages.removeIf(sectionPage -> !this.processPage(book, builder, (PageData)sectionPage));
        if (builder.hasEntries()) {
            int i = 0;
            List<ContentListing> finishedListings = builder.getFinishedListings();
            if (finishedListings.size() % 2 == 0) {
                PageData padding = new PageData(true);
                padding.source = data.source;
                padding.parent = data;
                padding.content = new ContentPadding.ContentRightPadding();
                padding.load();
                int sectionIndex = data.parent.sections.indexOf(data);
                if (sectionIndex > 0) {
                    data.parent.sections.get((int)(sectionIndex - 1)).pages.add(padding);
                } else {
                    data.pages.add(padding);
                    ++i;
                }
            }
            for (ContentListing listing : finishedListings) {
                PageData listingPage = new PageData(true);
                listingPage.name = this.sectionName;
                listingPage.source = data.source;
                listingPage.parent = data;
                listingPage.content = listing;
                listingPage.load();
                data.pages.add(i, listingPage);
                ++i;
            }
        }
    }

    protected boolean processPage(BookData book, GroupingBuilder builder, PageData page) {
        if (!IndexTransformer.isPageHidden(page) && !page.name.equals("hidden")) {
            builder.addPage(page.getTitle(), page);
        }
        return true;
    }

    public static class GroupingBuilder {
        private static final int COLUMN_WIDTH = 60;
        private final SectionData section;
        private int columns = 1;
        private int entriesInColumn = 0;
        private int maxInColumn;
        private ContentListing currentListing = new ContentListing();
        private final List<ContentListing> finishedListings = Lists.newArrayList((Object[])new ContentListing[]{this.currentListing});

        public GroupingBuilder(SectionData section, @Nullable String title, @Nullable String subText, @Nullable Boolean largeTitle, @Nullable Boolean centerTitle) {
            this.section = section;
            this.currentListing.title = title;
            this.currentListing.subText = subText;
            this.currentListing.setLargeTitle(largeTitle);
            this.currentListing.setCenterTitle(centerTitle);
            this.maxInColumn = this.currentListing.getEntriesInColumn(section);
        }

        public boolean hasEntries() {
            return this.entriesInColumn > 0;
        }

        private void incrementColumns(String text, boolean bold) {
            this.entriesInColumn = bold ? (this.entriesInColumn += TextDataRenderer.getLinesForString(text, ChatFormatting.BOLD.toString(), 60, "", this.section.parent.fontRenderer)) : (this.entriesInColumn += TextDataRenderer.getLinesForString(text, "", 60, "- ", this.section.parent.fontRenderer));
        }

        private void startNewColumn(boolean forceBreak) {
            if (this.columns == 3) {
                this.currentListing = new ContentListing();
                ContentListing firstListing = this.finishedListings.get(0);
                this.currentListing.title = firstListing.title;
                this.currentListing.setLargeTitle(firstListing.getLargeTitle());
                this.currentListing.setCenterTitle(firstListing.getCenterTitle());
                this.maxInColumn = this.currentListing.getEntriesInColumn(this.section);
                this.finishedListings.add(this.currentListing);
                this.columns = 1;
            } else {
                ++this.columns;
                if (forceBreak) {
                    this.currentListing.addColumnBreak();
                }
            }
            this.entriesInColumn = 0;
        }

        public void addGroup(String name, @Nullable PageData data) {
            if (this.entriesInColumn != 0) {
                this.startNewColumn(true);
            }
            this.incrementColumns(name, true);
            this.currentListing.addEntry(name, data, true);
        }

        public void addPage(String name, PageData data) {
            if (this.entriesInColumn == this.maxInColumn) {
                this.startNewColumn(false);
            }
            this.incrementColumns(name, false);
            this.currentListing.addEntry(name, data, false);
        }

        public List<ContentListing> getFinishedListings() {
            return this.finishedListings;
        }
    }
}

