/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.worldgen;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import uwu.lopyluna.create_dd.DDCreate;
import uwu.lopyluna.create_dd.worldgen.DDPlacedFeatures;

public class DDBiomeModifiers {
    public static final ResourceKey<BiomeModifier> TIN_ORE = DDBiomeModifiers.key("tin_ore");
    public static final ResourceKey<BiomeModifier> GABBRO_BLOB = DDBiomeModifiers.key("gabbro_blob");
    public static final ResourceKey<BiomeModifier> STRIATED_ORES_OVERWORLD = DDBiomeModifiers.key("striated_ores_overworld");
    public static final ResourceKey<BiomeModifier> STRIATED_ORES_SAVANNA = DDBiomeModifiers.key("striated_ores_savanna");
    public static final ResourceKey<BiomeModifier> STRIATED_ORES_BADLANDS = DDBiomeModifiers.key("striated_ores_badlands");
    public static final ResourceKey<BiomeModifier> STRIATED_ORES_OCEAN = DDBiomeModifiers.key("striated_ores_ocean");
    public static final ResourceKey<BiomeModifier> STRIATED_RAW_ORES_OVERWORLD = DDBiomeModifiers.key("striated_raw_ores_overworld");

    private static ResourceKey<BiomeModifier> key(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)DDCreate.asResource(name));
    }

    public static void bootstrap(BootstapContext<BiomeModifier> ctx) {
        HolderGetter biomeLookup = ctx.m_255420_(Registries.f_256952_);
        HolderSet.Named isOverworld = biomeLookup.m_254956_(BiomeTags.f_215817_);
        HolderSet.Named isSavanna = biomeLookup.m_254956_(BiomeTags.f_215816_);
        HolderSet.Named isBadlands = biomeLookup.m_254956_(BiomeTags.f_207607_);
        HolderSet.Named isOcean = biomeLookup.m_254956_(BiomeTags.f_207603_);
        HolderGetter featureLookup = ctx.m_255420_(Registries.f_256988_);
        Holder.Reference tin_ore = featureLookup.m_255043_(DDPlacedFeatures.TIN_ORE);
        Holder.Reference gabbro_blob = featureLookup.m_255043_(DDPlacedFeatures.GABBRO_BLOB);
        Holder.Reference striated_ores_overworld = featureLookup.m_255043_(DDPlacedFeatures.STRIATED_ORES_OVERWORLD);
        Holder.Reference striated_ores_savanna = featureLookup.m_255043_(DDPlacedFeatures.STRIATED_ORES_SAVANNA);
        Holder.Reference striated_ores_badlands = featureLookup.m_255043_(DDPlacedFeatures.STRIATED_ORES_BADLANDS);
        Holder.Reference striated_ores_ocean = featureLookup.m_255043_(DDPlacedFeatures.STRIATED_ORES_OCEAN);
        Holder.Reference striated_raw_ores_overworld = featureLookup.m_255043_(DDPlacedFeatures.STRIATED_RAW_ORES_OVERWORLD);
        ctx.m_255272_(TIN_ORE, (Object)DDBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)tin_ore));
        ctx.m_255272_(GABBRO_BLOB, (Object)DDBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)gabbro_blob));
        ctx.m_255272_(STRIATED_ORES_OVERWORLD, (Object)DDBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)striated_ores_overworld));
        ctx.m_255272_(STRIATED_ORES_SAVANNA, (Object)DDBiomeModifiers.addOre((HolderSet<Biome>)isSavanna, (Holder<PlacedFeature>)striated_ores_savanna));
        ctx.m_255272_(STRIATED_ORES_BADLANDS, (Object)DDBiomeModifiers.addOre((HolderSet<Biome>)isBadlands, (Holder<PlacedFeature>)striated_ores_badlands));
        ctx.m_255272_(STRIATED_ORES_OCEAN, (Object)DDBiomeModifiers.addOre((HolderSet<Biome>)isOcean, (Holder<PlacedFeature>)striated_ores_ocean));
        ctx.m_255272_(STRIATED_RAW_ORES_OVERWORLD, (Object)DDBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)striated_raw_ores_overworld));
    }

    private static ForgeBiomeModifiers.AddFeaturesBiomeModifier addOre(HolderSet<Biome> biomes, Holder<PlacedFeature> feature) {
        return new ForgeBiomeModifiers.AddFeaturesBiomeModifier(biomes, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{feature}), GenerationStep.Decoration.UNDERGROUND_ORES);
    }
}

