/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.api.event.PipeCollisionEvent;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import uwu.lopyluna.create_dd.DDCreate;
import uwu.lopyluna.create_dd.block.BlockPalette.DDPaletteStoneTypes;
import uwu.lopyluna.create_dd.block.DDBlocks;
import uwu.lopyluna.create_dd.sounds.DDSoundEvents;

public class DDFluids {
    static String id = "create_dd";
    static String fd = "fluid/";
    static String st = "_still";
    static String fl = "_flow";
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CONDENSE_MILK = ((FluidBuilder)DDCreate.REGISTRATE.fluid("condense_milk", new ResourceLocation(id, fd + "condense_milk" + st), new ResourceLocation(id, fd + "condense_milk" + fl), NoColorFluidAttributes::new).lang("Condense Milk").properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CREAM = ((FluidBuilder)DDCreate.REGISTRATE.fluid("cream", new ResourceLocation(id, fd + "cream" + st), new ResourceLocation(id, fd + "cream" + fl), NoColorFluidAttributes::new).lang("Cream").properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> VANILLA = ((FluidBuilder)DDCreate.REGISTRATE.fluid("vanilla", new ResourceLocation(id, fd + "vanilla" + st), new ResourceLocation(id, fd + "vanilla" + fl), NoColorFluidAttributes::new).lang("Vanilla").properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> VANILLA_MILKSHAKE = ((FluidBuilder)DDCreate.REGISTRATE.fluid("vanilla_milkshake", new ResourceLocation(id, fd + "vanilla_milkshake" + st), new ResourceLocation(id, fd + "vanilla_milkshake" + fl), NoColorFluidAttributes::new).lang("Vanilla Milkshake").properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> STRAWBERRY = ((FluidBuilder)DDCreate.REGISTRATE.fluid("strawberry", new ResourceLocation(id, fd + "strawberry" + st), new ResourceLocation(id, fd + "strawberry" + fl), NoColorFluidAttributes::new).lang("Strawberry").properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> STRAWBERRY_MILKSHAKE = ((FluidBuilder)DDCreate.REGISTRATE.fluid("strawberry_milkshake", new ResourceLocation(id, fd + "strawberry_milkshake" + st), new ResourceLocation(id, fd + "strawberry_milkshake" + fl), NoColorFluidAttributes::new).lang("Strawberry Milkshake").properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> GLOWBERRY = ((FluidBuilder)DDCreate.REGISTRATE.fluid("glowberry", new ResourceLocation(id, fd + "glowberry" + st), new ResourceLocation(id, fd + "glowberry" + fl), NoColorFluidAttributes::new).lang("Glowberry").properties(b -> b.viscosity(1500).density(1400).lightLevel(12)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> GLOWBERRY_MILKSHAKE = ((FluidBuilder)DDCreate.REGISTRATE.fluid("glowberry_milkshake", new ResourceLocation(id, fd + "glowberry_milkshake" + st), new ResourceLocation(id, fd + "glowberry_milkshake" + fl), NoColorFluidAttributes::new).lang("Glowberry Milkshake").properties(b -> b.viscosity(1500).density(1400).lightLevel(12)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CARAMEL = ((FluidBuilder)DDCreate.REGISTRATE.fluid("caramel", new ResourceLocation(id, fd + "caramel" + st), new ResourceLocation(id, fd + "caramel" + fl), NoColorFluidAttributes::new).lang("Caramel").properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CARAMEL_MILKSHAKE = ((FluidBuilder)DDCreate.REGISTRATE.fluid("caramel_milkshake", new ResourceLocation(id, fd + "caramel_milkshake" + st), new ResourceLocation(id, fd + "caramel_milkshake" + fl), NoColorFluidAttributes::new).lang("Caramel Milkshake").properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> HOT_CHOCOLATE = ((FluidBuilder)DDCreate.REGISTRATE.fluid("hot_chocolate", new ResourceLocation(id, fd + "hot_chocolate" + st), new ResourceLocation(id, fd + "hot_chocolate" + fl), NoColorFluidAttributes::new).lang("Hot Chocolate").properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CHOCOLATE_MILKSHAKE = ((FluidBuilder)DDCreate.REGISTRATE.fluid("chocolate_milkshake", new ResourceLocation(id, fd + "chocolate_milkshake" + st), new ResourceLocation(id, fd + "chocolate_milkshake" + fl), NoColorFluidAttributes::new).lang("Chocolate Milkshake").properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CHROMATIC_WASTE = ((FluidBuilder)DDCreate.REGISTRATE.fluid("chromatic_waste", new ResourceLocation(id, fd + "chromatic_waste" + st), new ResourceLocation(id, fd + "chromatic_waste" + fl), NoColorFluidAttributes::new).lang("Chromatic Waste").properties(b -> b.viscosity(6000).density(3000).lightLevel(8).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).lightLevel(8)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> SAP = ((FluidBuilder)DDCreate.REGISTRATE.fluid("sap", new ResourceLocation(id, fd + "sap" + st), new ResourceLocation(id, fd + "sap" + fl), NoColorFluidAttributes::new).lang("Tree Sap").properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> SHIMMER = ((FluidBuilder)DDCreate.REGISTRATE.fluid("shimmer", new ResourceLocation(id, fd + "shimmer" + st), new ResourceLocation(id, fd + "shimmer" + fl), NoColorFluidAttributes::new).lang("Shimmer").properties(b -> b.viscosity(6000).density(50).canSwim(false).canDrown(true).canHydrate(false).rarity(Rarity.EPIC).lightLevel(15).temperature(-1000).motionScale(-1.25).supportsBoating(false).canExtinguish(false).canConvertToSource(true).pathType(BlockPathTypes.LAVA).sound(SoundActions.BUCKET_FILL, (SoundEvent)DDSoundEvents.shimmer_fill.get()).sound(SoundActions.BUCKET_EMPTY, (SoundEvent)DDSoundEvents.shimmer_empty.get()).adjacentPathType(null)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(20).slopeFindDistance(0).explosionResistance(10000.0f)).source(ForgeFlowingFluid.Source::new).bucket().properties(p -> p.m_41497_(Rarity.EPIC)).build()).register();

    public static void register() {
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)SHIMMER.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return ((Block)DDPaletteStoneTypes.aethersite.getBaseBlock().get()).m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)VANILLA.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return ((Block)AllPaletteStoneTypes.DEEPSLATE.getBaseBlock().get()).m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)VANILLA_MILKSHAKE.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return DDBlocks.potassic_cobble.getDefaultState();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)STRAWBERRY.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return ((Block)DDPaletteStoneTypes.gabbro.getBaseBlock().get()).m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)STRAWBERRY_MILKSHAKE.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return DDBlocks.crimsite_cobble.getDefaultState();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)GLOWBERRY.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return ((Block)AllPaletteStoneTypes.DRIPSTONE.getBaseBlock().get()).m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)GLOWBERRY_MILKSHAKE.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return DDBlocks.ochrum_cobble.getDefaultState();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)CARAMEL.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return Blocks.f_50730_.m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)CARAMEL_MILKSHAKE.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return DDBlocks.veridium_cobble.getDefaultState();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)CONDENSE_MILK.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return ((Block)AllPaletteStoneTypes.CALCITE.getBaseBlock().get()).m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)CREAM.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return DDBlocks.asurine_cobble.getDefaultState();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)HOT_CHOCOLATE.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return ((Block)AllPaletteStoneTypes.SCORCHIA.getBaseBlock().get()).m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)CHOCOLATE_MILKSHAKE.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return ((Block)AllPaletteStoneTypes.SCORIA.getBaseBlock().get()).m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)SAP.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return Blocks.f_50137_.m_49966_();
        }));
    }

    @Nullable
    public static BlockState getLavaInteraction(FluidState fluidState) {
        Fluid fluid = fluidState.m_76152_();
        if (fluid.m_6212_((Fluid)SHIMMER.get())) {
            return ((Block)DDPaletteStoneTypes.aethersite.getBaseBlock().get()).m_49966_();
        }
        if (fluid.m_6212_((Fluid)VANILLA.get())) {
            return ((Block)AllPaletteStoneTypes.DEEPSLATE.getBaseBlock().get()).m_49966_();
        }
        if (fluid.m_6212_((Fluid)VANILLA_MILKSHAKE.get())) {
            return DDBlocks.potassic_cobble.getDefaultState();
        }
        if (fluid.m_6212_((Fluid)STRAWBERRY.get())) {
            return ((Block)DDPaletteStoneTypes.gabbro.getBaseBlock().get()).m_49966_();
        }
        if (fluid.m_6212_((Fluid)STRAWBERRY_MILKSHAKE.get())) {
            return DDBlocks.crimsite_cobble.getDefaultState();
        }
        if (fluid.m_6212_((Fluid)GLOWBERRY.get())) {
            return ((Block)AllPaletteStoneTypes.DRIPSTONE.getBaseBlock().get()).m_49966_();
        }
        if (fluid.m_6212_((Fluid)GLOWBERRY_MILKSHAKE.get())) {
            return DDBlocks.ochrum_cobble.getDefaultState();
        }
        if (fluid.m_6212_((Fluid)CARAMEL.get())) {
            return Blocks.f_50730_.m_49966_();
        }
        if (fluid.m_6212_((Fluid)CARAMEL_MILKSHAKE.get())) {
            return DDBlocks.veridium_cobble.getDefaultState();
        }
        if (fluid.m_6212_((Fluid)CREAM.get())) {
            return DDBlocks.asurine_cobble.getDefaultState();
        }
        if (fluid.m_6212_((Fluid)HOT_CHOCOLATE.get())) {
            return ((Block)AllPaletteStoneTypes.SCORCHIA.getBaseBlock().get()).m_49966_();
        }
        if (fluid.m_6212_((Fluid)CHOCOLATE_MILKSHAKE.get())) {
            return ((Block)AllPaletteStoneTypes.SCORIA.getBaseBlock().get()).m_49966_();
        }
        if (fluid.m_6212_((Fluid)CONDENSE_MILK.get())) {
            return ((Block)AllPaletteStoneTypes.CALCITE.getBaseBlock().get()).m_49966_();
        }
        if (fluid.m_6212_((Fluid)SAP.get())) {
            return Blocks.f_50137_.m_49966_();
        }
        return null;
    }

    @Mod.EventBusSubscriber
    public static class DDFluidEvents {
        @SubscribeEvent
        public static void whenFluidsMeet(BlockEvent.FluidPlaceBlockEvent event) {
            BlockState blockState = event.getOriginalState();
            FluidState fluidState = blockState.m_60819_();
            BlockPos pos = event.getPos();
            LevelAccessor world = event.getLevel();
            if (fluidState.m_76170_() && FluidHelper.isLava((Fluid)fluidState.m_76152_())) {
                return;
            }
            for (Direction direction : Iterate.directions) {
                BlockState lavaInteraction;
                FluidState metFluidState;
                FluidState fluidState2 = metFluidState = fluidState.m_76170_() ? fluidState : world.m_6425_(pos.m_121945_(direction));
                if (!metFluidState.m_205070_(FluidTags.f_13131_) || (lavaInteraction = DDFluids.getLavaInteraction(metFluidState)) == null) continue;
                event.setNewState(lavaInteraction);
                break;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void handlePipeFlowCollisionFallback(PipeCollisionEvent.Flow event) {
            BlockState lavaInteraction;
            Fluid f1 = event.getFirstFluid();
            Fluid f2 = event.getSecondFluid();
            if (f1 == Fluids.f_76193_ && f2 == Fluids.f_76195_ || f2 == Fluids.f_76193_ && f1 == Fluids.f_76195_) {
                event.setState(Blocks.f_50652_.m_49966_());
            } else if (f1 == Fluids.f_76195_ && FluidHelper.hasBlockState((Fluid)f2)) {
                BlockState lavaInteraction2 = DDFluids.getLavaInteraction(FluidHelper.convertToFlowing((Fluid)f2).m_76145_());
                if (lavaInteraction2 != null) {
                    event.setState(lavaInteraction2);
                }
            } else if (f2 == Fluids.f_76195_ && FluidHelper.hasBlockState((Fluid)f1) && (lavaInteraction = DDFluids.getLavaInteraction(FluidHelper.convertToFlowing((Fluid)f1).m_76145_())) != null) {
                event.setState(lavaInteraction);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void handlePipeSpillCollisionFallback(PipeCollisionEvent.Spill event) {
            BlockState lavaInteraction;
            Fluid pf = event.getPipeFluid();
            Fluid wf = event.getWorldFluid();
            if (FluidHelper.isTag((Fluid)pf, (TagKey)FluidTags.f_13131_) && wf == Fluids.f_76195_) {
                event.setState(Blocks.f_50080_.m_49966_());
            } else if (pf == Fluids.f_76193_ && wf == Fluids.f_76194_) {
                event.setState(Blocks.f_50652_.m_49966_());
            } else if (pf == Fluids.f_76195_ && wf == Fluids.f_76193_) {
                event.setState(Blocks.f_50069_.m_49966_());
            } else if (pf == Fluids.f_76195_ && wf == Fluids.f_76192_) {
                event.setState(Blocks.f_50652_.m_49966_());
            }
            if (pf == Fluids.f_76195_) {
                BlockState lavaInteraction2 = DDFluids.getLavaInteraction(wf.m_76145_());
                if (lavaInteraction2 != null) {
                    event.setState(lavaInteraction2);
                }
            } else if (wf == Fluids.f_76194_ && FluidHelper.hasBlockState((Fluid)pf) && (lavaInteraction = DDFluids.getLavaInteraction(FluidHelper.convertToFlowing((Fluid)pf).m_76145_())) != null) {
                event.setState(lavaInteraction);
            }
        }
    }

    private static class NoColorFluidAttributes
    extends TintedFluidType {
        public NoColorFluidAttributes(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        @Override
        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        @Override
        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }
    }

    public static abstract class TintedFluidType
    extends FluidType {
        protected static final int NO_TINT = -1;
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;

        public TintedFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties);
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public int getTintColor(FluidStack stack) {
                    return this.getTintColor(stack);
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return this.getTintColor(state, getter, pos);
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    Vector3f customFogColor = this.getCustomFogColor();
                    return customFogColor == null ? fluidFogColor : customFogColor;
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    float modifier = this.getFogDistanceModifier();
                    float baseWaterFog = 96.0f;
                    if (modifier != 1.0f) {
                        RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
                        RenderSystem.setShaderFogStart((float)-8.0f);
                        RenderSystem.setShaderFogEnd((float)(baseWaterFog * modifier));
                    }
                }
            });
        }

        protected abstract int getTintColor(FluidStack var1);

        protected abstract int getTintColor(FluidState var1, BlockAndTintGetter var2, BlockPos var3);

        protected Vector3f getCustomFogColor() {
            return null;
        }

        protected float getFogDistanceModifier() {
            return 1.0f;
        }
    }
}

