/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.Processing;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.fan.processing.HauntingRecipe;
import com.simibubi.create.content.kinetics.fan.processing.SplashingRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.LitBlazeBurnerBlock;
import com.simibubi.create.content.trains.CubeParticleData;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.VecHelper;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import uwu.lopyluna.create_dd.DDCreate;
import uwu.lopyluna.create_dd.DDTags;
import uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.Processing.DDFanProcessingTypeRegistry;
import uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.Processing.InterfaceIndustrialProcessingType;
import uwu.lopyluna.create_dd.recipe.DDRecipesTypes;
import uwu.lopyluna.create_dd.recipe.Recipes.FreezingRecipe;
import uwu.lopyluna.create_dd.recipe.Recipes.SuperheatingRecipe;

public class IndustrialTypeFanProcessing {
    public static final NoneType NONE = IndustrialTypeFanProcessing.register("none", new NoneType());
    public static final BlastingType BLASTING = IndustrialTypeFanProcessing.register("blasting", new BlastingType());
    public static final HauntingType HAUNTING = IndustrialTypeFanProcessing.register("haunting", new HauntingType());
    public static final SmokingType SMOKING = IndustrialTypeFanProcessing.register("smoking", new SmokingType());
    public static final SplashingType SPLASHING = IndustrialTypeFanProcessing.register("splashing", new SplashingType());
    public static final FreezingType FREEZING = IndustrialTypeFanProcessing.register("freezing", new FreezingType());
    public static final SuperheatingType SUPERHEATING = IndustrialTypeFanProcessing.register("superheating", new SuperheatingType());
    private static final Map<String, InterfaceIndustrialProcessingType> LEGACY_NAME_MAP;

    private static <T extends InterfaceIndustrialProcessingType> T register(String id, T type) {
        DDFanProcessingTypeRegistry.register(DDCreate.asResource(id), type);
        return type;
    }

    @Nullable
    public static InterfaceIndustrialProcessingType ofLegacyName(String name) {
        return LEGACY_NAME_MAP.get(name);
    }

    public static InterfaceIndustrialProcessingType parseLegacy(String str) {
        InterfaceIndustrialProcessingType type = IndustrialTypeFanProcessing.ofLegacyName(str);
        if (type != null) {
            return type;
        }
        return InterfaceIndustrialProcessingType.parse(str);
    }

    public static void register() {
    }

    static {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)"NONE", (Object)NONE);
        map.put((Object)"BLASTING", (Object)BLASTING);
        map.put((Object)"HAUNTING", (Object)HAUNTING);
        map.put((Object)"SMOKING", (Object)SMOKING);
        map.put((Object)"SPLASHING", (Object)SPLASHING);
        map.put((Object)"FREEZING", (Object)FREEZING);
        map.put((Object)"SUPERHEATING", (Object)SUPERHEATING);
        map.trim();
        LEGACY_NAME_MAP = map;
    }

    public static class NoneType
    implements InterfaceIndustrialProcessingType {
        @Override
        public boolean isValidAt(Level level, BlockPos pos) {
            return true;
        }

        @Override
        public int getPriority() {
            return -1000000;
        }

        @Override
        public boolean canProcess(ItemStack stack, Level level) {
            return false;
        }

        @Override
        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            return null;
        }

        @Override
        public void spawnProcessingParticles(Level level, Vec3 pos) {
        }

        @Override
        public void morphAirFlow(InterfaceIndustrialProcessingType.DDAirFlowParticleAccess particleAccess, RandomSource random) {
        }

        @Override
        public void affectEntity(Entity entity, Level level) {
        }
    }

    public static class BlastingType
    implements InterfaceIndustrialProcessingType {
        private static final RecipeWrapper RECIPE_WRAPPER = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

        @Override
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_BLASTING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            if (AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_BLASTING.matches(blockState)) {
                return !blockState.m_61138_((Property)BlazeBurnerBlock.HEAT_LEVEL) || ((BlazeBurnerBlock.HeatLevel)blockState.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL)).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 100;
        }

        @Override
        public boolean canProcess(ItemStack stack, Level level) {
            RECIPE_WRAPPER.m_6836_(0, stack);
            Optional smeltingRecipe = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)RECIPE_WRAPPER, level);
            if (smeltingRecipe.isPresent()) {
                return true;
            }
            RECIPE_WRAPPER.m_6836_(0, stack);
            Optional blastingRecipe = level.m_7465_().m_44015_(RecipeType.f_44109_, (Container)RECIPE_WRAPPER, level);
            if (blastingRecipe.isPresent()) {
                return true;
            }
            return !stack.m_41720_().m_41475_();
        }

        @Override
        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            RECIPE_WRAPPER.m_6836_(0, stack);
            Optional smokingRecipe = level.m_7465_().m_44015_(RecipeType.f_44110_, (Container)RECIPE_WRAPPER, level);
            RECIPE_WRAPPER.m_6836_(0, stack);
            Optional smeltingRecipe = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)RECIPE_WRAPPER, level);
            if (!smeltingRecipe.isPresent()) {
                RECIPE_WRAPPER.m_6836_(0, stack);
                smeltingRecipe = level.m_7465_().m_44015_(RecipeType.f_44109_, (Container)RECIPE_WRAPPER, level);
            }
            if (smeltingRecipe.isPresent()) {
                RegistryAccess registryAccess = level.m_9598_();
                if (!smokingRecipe.isPresent() || !ItemStack.m_41656_((ItemStack)((SmokingRecipe)smokingRecipe.get()).m_8043_(registryAccess), (ItemStack)((AbstractCookingRecipe)smeltingRecipe.get()).m_8043_(registryAccess))) {
                    return RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)((Recipe)smeltingRecipe.get()));
                }
            }
            return Collections.emptyList();
        }

        @Override
        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_, pos.f_82480_ + 0.25, pos.f_82481_, 0.0, 0.0625, 0.0);
        }

        @Override
        public void morphAirFlow(InterfaceIndustrialProcessingType.DDAirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)0xFF4400, (int)0xFF8855, (float)random.m_188501_()));
            particleAccess.setAlpha(0.5f);
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123744_, 0.25f);
            }
            if (random.m_188501_() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49991_.m_49966_()), 0.25f);
            }
        }

        @Override
        public void affectEntity(Entity entity, Level level) {
            if (level.f_46443_) {
                return;
            }
            if (!entity.m_5825_()) {
                entity.m_20254_(10);
                entity.m_6469_(CreateDamageSources.fanLava((Level)level), 4.0f);
            }
        }
    }

    public static class HauntingType
    implements InterfaceIndustrialProcessingType {
        private static final HauntingRecipe.HauntingWrapper HAUNTING_WRAPPER = new HauntingRecipe.HauntingWrapper();

        @Override
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_HAUNTING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            if (AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_HAUNTING.matches(blockState)) {
                if (blockState.m_204336_(BlockTags.f_13087_) && blockState.m_61138_((Property)CampfireBlock.f_51227_) && !((Boolean)blockState.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                    return false;
                }
                return !blockState.m_61138_((Property)LitBlazeBurnerBlock.FLAME_TYPE) || blockState.m_61143_((Property)LitBlazeBurnerBlock.FLAME_TYPE) == LitBlazeBurnerBlock.FlameType.SOUL;
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 300;
        }

        @Override
        public boolean canProcess(ItemStack stack, Level level) {
            HAUNTING_WRAPPER.m_6836_(0, stack);
            Optional recipe = AllRecipeTypes.HAUNTING.find((Container)HAUNTING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Override
        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            HAUNTING_WRAPPER.m_6836_(0, stack);
            Optional recipe = AllRecipeTypes.HAUNTING.find((Container)HAUNTING_WRAPPER, level);
            if (recipe.isPresent()) {
                return RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)((Recipe)recipe.get()));
            }
            return null;
        }

        @Override
        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            pos = pos.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)1.0f).m_82542_(1.0, (double)0.05f, 1.0).m_82541_().m_82490_((double)0.15f));
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, pos.f_82479_, pos.f_82480_ + (double)0.45f, pos.f_82481_, 0.0, 0.0, 0.0);
            if (level.f_46441_.m_188503_(2) == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_ + 0.25, pos.f_82481_, 0.0, 0.0, 0.0);
            }
        }

        @Override
        public void morphAirFlow(InterfaceIndustrialProcessingType.DDAirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)0, (int)1205608, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.0078125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123745_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123762_, 0.125f);
            }
        }

        @Override
        public void affectEntity(Entity entity, Level level) {
            if (level.f_46443_) {
                if (entity instanceof Horse) {
                    Vec3 p = entity.m_20318_(0.0f);
                    Vec3 v = p.m_82520_(0.0, 0.5, 0.0).m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)1.0f).m_82542_(1.0, (double)0.2f, 1.0).m_82541_().m_82490_(1.0));
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, (double)0.1f, 0.0);
                    if (level.f_46441_.m_188503_(3) == 0) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, p.f_82479_, p.f_82480_ + 0.5, p.f_82481_, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), (double)0.1f, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f));
                    }
                }
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 30, 0, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 1, false, false));
            }
            if (entity instanceof Horse) {
                Horse horse = (Horse)entity;
                int progress = horse.getPersistentData().m_128451_("CreateHaunting");
                if (progress < 100) {
                    if (progress % 10 == 0) {
                        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12404_, SoundSource.NEUTRAL, 1.0f, 1.5f * (float)progress / 100.0f);
                    }
                    horse.getPersistentData().m_128405_("CreateHaunting", progress + 1);
                    return;
                }
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11914_, SoundSource.NEUTRAL, 1.25f, 0.65f);
                SkeletonHorse skeletonHorse = (SkeletonHorse)EntityType.f_20525_.m_20615_(level);
                CompoundTag serializeNBT = horse.m_20240_(new CompoundTag());
                serializeNBT.m_128473_("UUID");
                if (!horse.m_30722_().m_41619_()) {
                    horse.m_19983_(horse.m_30722_());
                }
                skeletonHorse.deserializeNBT(serializeNBT);
                skeletonHorse.m_146884_(horse.m_20318_(0.0f));
                level.m_7967_((Entity)skeletonHorse);
                horse.m_146870_();
            }
        }
    }

    public static class SmokingType
    implements InterfaceIndustrialProcessingType {
        private static final RecipeWrapper RECIPE_WRAPPER = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

        @Override
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_SMOKING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            if (AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_SMOKING.matches(blockState)) {
                if (blockState.m_204336_(BlockTags.f_13087_) && blockState.m_61138_((Property)CampfireBlock.f_51227_) && !((Boolean)blockState.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                    return false;
                }
                if (blockState.m_61138_((Property)LitBlazeBurnerBlock.FLAME_TYPE) && blockState.m_61143_((Property)LitBlazeBurnerBlock.FLAME_TYPE) != LitBlazeBurnerBlock.FlameType.REGULAR) {
                    return false;
                }
                return !blockState.m_61138_((Property)BlazeBurnerBlock.HEAT_LEVEL) || blockState.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL) == BlazeBurnerBlock.HeatLevel.SMOULDERING;
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 200;
        }

        @Override
        public boolean canProcess(ItemStack stack, Level level) {
            RECIPE_WRAPPER.m_6836_(0, stack);
            Optional recipe = level.m_7465_().m_44015_(RecipeType.f_44110_, (Container)RECIPE_WRAPPER, level);
            return recipe.isPresent();
        }

        @Override
        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            RECIPE_WRAPPER.m_6836_(0, stack);
            Optional smokingRecipe = level.m_7465_().m_44015_(RecipeType.f_44110_, (Container)RECIPE_WRAPPER, level);
            if (smokingRecipe.isPresent()) {
                return RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)((Recipe)smokingRecipe.get()));
            }
            return null;
        }

        @Override
        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, pos.f_82479_, pos.f_82480_ + 0.25, pos.f_82481_, 0.0, 0.0625, 0.0);
        }

        @Override
        public void morphAirFlow(InterfaceIndustrialProcessingType.DDAirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)0, (int)0x555555, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123762_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123755_, 0.125f);
            }
        }

        @Override
        public void affectEntity(Entity entity, Level level) {
            if (level.f_46443_) {
                return;
            }
            if (!entity.m_5825_()) {
                entity.m_20254_(2);
                entity.m_6469_(CreateDamageSources.fanFire((Level)level), 2.0f);
            }
        }
    }

    public static class SplashingType
    implements InterfaceIndustrialProcessingType {
        private static final SplashingRecipe.SplashingWrapper SPLASHING_WRAPPER = new SplashingRecipe.SplashingWrapper();

        @Override
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_SPLASHING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            return AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_SPLASHING.matches(blockState);
        }

        @Override
        public int getPriority() {
            return 400;
        }

        @Override
        public boolean canProcess(ItemStack stack, Level level) {
            SPLASHING_WRAPPER.m_6836_(0, stack);
            Optional recipe = AllRecipeTypes.SPLASHING.find((Container)SPLASHING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Override
        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            SPLASHING_WRAPPER.m_6836_(0, stack);
            Optional recipe = AllRecipeTypes.SPLASHING.find((Container)SPLASHING_WRAPPER, level);
            if (recipe.isPresent()) {
                return RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)((Recipe)recipe.get()));
            }
            return null;
        }

        @Override
        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            Vector3f color = new Color(22015).asVectorF();
            level.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123764_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        @Override
        public void morphAirFlow(InterfaceIndustrialProcessingType.DDAirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)0x4499FF, (int)0x2277FF, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123795_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123772_, 0.125f);
            }
        }

        @Override
        public void affectEntity(Entity entity, Level level) {
            if (level.f_46443_) {
                return;
            }
            if (entity instanceof EnderMan || entity.m_6095_() == EntityType.f_20528_ || entity.m_6095_() == EntityType.f_20551_) {
                entity.m_6469_(entity.m_269291_().m_269063_(), 2.0f);
            }
            if (entity.m_6060_()) {
                entity.m_20095_();
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11914_, SoundSource.NEUTRAL, 0.7f, 1.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
            }
        }
    }

    public static class FreezingType
    implements InterfaceIndustrialProcessingType {
        private static final FreezingRecipe.FreezingWrapper FREEZING_WRAPPER = new FreezingRecipe.FreezingWrapper();

        @Override
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (DDTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_FREEZING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            return DDTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_FREEZING.matches(blockState);
        }

        @Override
        public int getPriority() {
            return 600;
        }

        @Override
        public boolean canProcess(ItemStack stack, Level level) {
            FREEZING_WRAPPER.m_6836_(0, stack);
            Optional recipe = DDRecipesTypes.FREEZING.find(FREEZING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Override
        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            FREEZING_WRAPPER.m_6836_(0, stack);
            Optional recipe = DDRecipesTypes.FREEZING.find(FREEZING_WRAPPER, level);
            if (recipe.isPresent()) {
                return RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)((Recipe)recipe.get()));
            }
            return null;
        }

        @Override
        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            Vector3f color = new Color(14543103).asVectorF();
            level.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        @Override
        public void morphAirFlow(InterfaceIndustrialProcessingType.DDAirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)0xEEEEFF, (int)14543103, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.0078125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_175821_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123759_, 0.125f);
            }
        }

        @Override
        public void affectEntity(Entity entity, Level level) {
            if (level.f_46443_) {
                if (entity instanceof Skeleton) {
                    Vec3 p = entity.m_20318_(0.0f);
                    Vec3 v = p.m_82520_(0.0, 0.5, 0.0).m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)1.0f).m_82542_(1.0, (double)0.2f, 1.0).m_82541_().m_82490_(1.0));
                    level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, (double)0.1f, 0.0);
                    if (level.f_46441_.m_188503_(3) == 0) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, p.f_82479_, p.f_82480_ + 0.5, p.f_82481_, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), (double)0.1f, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f));
                    }
                }
                return;
            }
            if (entity instanceof EnderMan || entity.m_6095_() == EntityType.f_20551_) {
                entity.m_6469_(entity.m_269291_().m_269109_(), 8.0f);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 7, false, false));
            }
            if (entity instanceof SnowGolem) {
                SnowGolem snowgolem = (SnowGolem)entity;
                snowgolem.m_5634_(4.0f);
            }
            if (entity instanceof Stray) {
                Stray stray = (Stray)entity;
                stray.m_5634_(2.0f);
            }
            if (entity.m_6060_()) {
                entity.m_20095_();
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11914_, SoundSource.NEUTRAL, 0.7f, 1.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
            }
            if (entity instanceof Skeleton) {
                Skeleton skeleton = (Skeleton)entity;
                int progress = skeleton.getPersistentData().m_128451_("CreateFreezing");
                if (progress < 50) {
                    if (progress % 10 == 0) {
                        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12451_, SoundSource.NEUTRAL, 1.0f, 1.5f * (float)progress / 50.0f);
                    }
                    skeleton.getPersistentData().m_128405_("CreateFreezing", progress + 1);
                    return;
                }
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_144211_, SoundSource.NEUTRAL, 1.25f, 0.65f);
                Stray stray = (Stray)EntityType.f_20481_.m_20615_(level);
                CompoundTag serializeNBT = skeleton.m_20240_(new CompoundTag());
                serializeNBT.m_128473_("UUID");
                assert (stray != null);
                stray.deserializeNBT(serializeNBT);
                stray.m_146884_(skeleton.m_20318_(0.0f));
                level.m_7967_((Entity)stray);
                skeleton.m_146870_();
            }
        }
    }

    public static class SuperheatingType
    implements InterfaceIndustrialProcessingType {
        private static final SuperheatingRecipe.SuperheatingWrapper SUPERHEATING_WRAPPER = new SuperheatingRecipe.SuperheatingWrapper();

        @Override
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (DDTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_SUPERHEATING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            if (DDTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_SUPERHEATING.matches(blockState)) {
                return !blockState.m_61138_((Property)BlazeBurnerBlock.HEAT_LEVEL) || ((BlazeBurnerBlock.HeatLevel)blockState.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL)).isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING);
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 500;
        }

        @Override
        public boolean canProcess(ItemStack stack, Level level) {
            SUPERHEATING_WRAPPER.m_6836_(0, stack);
            Optional recipe = DDRecipesTypes.SUPERHEATING.find(SUPERHEATING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Override
        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            SUPERHEATING_WRAPPER.m_6836_(0, stack);
            Optional recipe = DDRecipesTypes.SUPERHEATING.find(SUPERHEATING_WRAPPER, level);
            if (recipe.isPresent()) {
                return RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)((Recipe)recipe.get()));
            }
            return null;
        }

        @Override
        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            Vector3f color = new Color(1969981).asVectorF();
            level.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, pos.f_82479_, pos.f_82480_ + (double)0.45f, pos.f_82481_, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        @Override
        public void morphAirFlow(InterfaceIndustrialProcessingType.DDAirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)6605309, (int)4158696, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123745_, 0.125f);
            }
            Vector3f colorBright = new Color(6605309).asVectorF();
            Vector3f colorDark = new Color(4158696).asVectorF();
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new DustParticleOptions(colorBright, 1.0f), 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new DustParticleOptions(colorDark, 1.0f), 0.125f);
            }
            if (random.m_188501_() < 0.020833334f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123762_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new CubeParticleData(192.0f, 122.0f, 85.0f, 0.075f, 10, true), 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new CubeParticleData(191.0f, 82.0f, 91.0f, 0.1f, 10, true), 0.125f);
            }
        }

        @Override
        public void affectEntity(Entity entity, Level level) {
            if (level.f_46443_) {
                return;
            }
            if (entity instanceof Blaze) {
                Blaze blaze = (Blaze)entity;
                blaze.m_5634_(4.0f);
            }
            if (!entity.m_5825_()) {
                entity.m_20254_(10);
                entity.m_6469_(CreateDamageSources.fanLava((Level)level), 10.0f);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 2, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 1, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 30, 0, false, false));
            }
        }
    }
}

