/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.Processing;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import uwu.lopyluna.create_dd.access.DDTransportedItemStack;
import uwu.lopyluna.create_dd.access.DDTransportedItemStackHandlerBehaviour;
import uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.Processing.DDFanProcessingTypeRegistry;
import uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.Processing.IndustrialTypeFanProcessing;
import uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.Processing.InterfaceIndustrialProcessingType;
import uwu.lopyluna.create_dd.configs.DDConfigs;

public class DDFanProcessing {
    public static boolean canProcess(ItemEntity entity, InterfaceIndustrialProcessingType type) {
        CompoundTag compound;
        if (entity.getPersistentData().m_128441_("CreateData") && (compound = entity.getPersistentData().m_128469_("CreateData")).m_128441_("Processing")) {
            CompoundTag processing = compound.m_128469_("Processing");
            if (IndustrialTypeFanProcessing.parseLegacy(processing.m_128461_("Type")) != type) {
                return type.canProcess(entity.m_32055_(), entity.m_9236_());
            }
            if (processing.m_128451_("Time") >= 0) {
                return true;
            }
            if (processing.m_128451_("Time") == -1) {
                return false;
            }
        }
        return type.canProcess(entity.m_32055_(), entity.m_9236_());
    }

    public static boolean applyProcessing(ItemEntity entity, InterfaceIndustrialProcessingType type) {
        if (DDFanProcessing.decrementProcessingTime(entity, type) != 0) {
            return false;
        }
        List<ItemStack> stacks = type.process(entity.m_32055_(), entity.m_9236_());
        if (stacks == null) {
            return false;
        }
        if (stacks.isEmpty()) {
            entity.m_146870_();
            return false;
        }
        entity.m_32045_(stacks.remove(0));
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), additional);
            entityIn.m_20256_(entity.m_20184_());
            entity.m_9236_().m_7967_((Entity)entityIn);
        }
        return true;
    }

    public static DDTransportedItemStackHandlerBehaviour.TransportedResult applyProcessing(DDTransportedItemStack transported, Level world, InterfaceIndustrialProcessingType type) {
        DDTransportedItemStackHandlerBehaviour.TransportedResult ignore = DDTransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        if (transported.processedBy != type) {
            int processingTime;
            transported.processedBy = type;
            int timeModifierForStackSize = (transported.stack.m_41613_() - 1) / 16 + 1;
            transported.processingTime = processingTime = (int)((double)((Integer)DDConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize) / 1.25) + 1;
            if (!type.canProcess(transported.stack, world)) {
                transported.processingTime = -1;
            }
            return ignore;
        }
        if (transported.processingTime == -1) {
            return ignore;
        }
        if (transported.processingTime-- > 0) {
            return ignore;
        }
        List<ItemStack> stacks = type.process(transported.stack, world);
        if (stacks == null) {
            return ignore;
        }
        ArrayList<DDTransportedItemStack> transportedStacks = new ArrayList<DDTransportedItemStack>();
        for (ItemStack additional : stacks) {
            DDTransportedItemStack newTransported = transported.getSimilar();
            newTransported.stack = additional.m_41777_();
            transportedStacks.add(newTransported);
        }
        return DDTransportedItemStackHandlerBehaviour.TransportedResult.convertTo(transportedStacks);
    }

    private static int decrementProcessingTime(ItemEntity entity, InterfaceIndustrialProcessingType type) {
        CompoundTag processing;
        CompoundTag createData;
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.m_128441_("CreateData")) {
            nbt.m_128365_("CreateData", (Tag)new CompoundTag());
        }
        if (!(createData = nbt.m_128469_("CreateData")).m_128441_("Processing")) {
            createData.m_128365_("Processing", (Tag)new CompoundTag());
        }
        if (!(processing = createData.m_128469_("Processing")).m_128441_("Type") || IndustrialTypeFanProcessing.parseLegacy(processing.m_128461_("Type")) != type) {
            processing.m_128359_("Type", DDFanProcessingTypeRegistry.getIdOrThrow(type).toString());
            int timeModifierForStackSize = (entity.m_32055_().m_41613_() - 1) / 16 + 1;
            int processingTime = (int)((double)((Integer)DDConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize) / 1.25) + 1;
            processing.m_128405_("Time", processingTime);
        }
        int value = processing.m_128451_("Time") - 1;
        processing.m_128405_("Time", value);
        return value;
    }
}

