/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;
import uwu.lopyluna.create_dd.access.DDServerPlayer;
import uwu.lopyluna.create_dd.access.DDTransportedItemStack;
import uwu.lopyluna.create_dd.access.DDTransportedItemStackHandlerBehaviour;
import uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.IndustrialAirCurrentSound;
import uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.IndustrialAirCurrentSource;
import uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.IndustrialFanBlockEntity;
import uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.Processing.DDFanProcessing;
import uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.Processing.IndustrialTypeFanProcessing;
import uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.Processing.InterfaceIndustrialProcessingType;
import uwu.lopyluna.create_dd.block.BlockProperties.industrial_fan.rando.DDAirFlowParticleData;
import uwu.lopyluna.create_dd.configs.DDConfigs;

public class IndustrialAirCurrent {
    public final IndustrialAirCurrentSource source;
    public AABB bounds = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public List<AirCurrentSegment> segments = new ArrayList<AirCurrentSegment>();
    public Direction direction;
    public boolean pushing;
    public float maxDistance;
    protected List<Pair<DDTransportedItemStackHandlerBehaviour, InterfaceIndustrialProcessingType>> affectedItemHandlers = new ArrayList<Pair<DDTransportedItemStackHandlerBehaviour, InterfaceIndustrialProcessingType>>();
    protected List<Entity> caughtEntities = new ArrayList<Entity>();
    private static final double[][] DEPTH_TEST_COORDINATES = new double[][]{{0.25, 0.25}, {0.25, 0.75}, {0.5, 0.5}, {0.75, 0.25}, {0.75, 0.75}};
    private static boolean isClientPlayerInAirCurrent;
    @OnlyIn(value=Dist.CLIENT)
    private static IndustrialAirCurrentSound flyingSound;

    public IndustrialAirCurrent(IndustrialAirCurrentSource source) {
        this.source = source;
    }

    public void tick() {
        Level world;
        if (this.direction == null) {
            this.rebuild();
        }
        if ((world = this.source.getAirCurrentWorld()) != null && world.f_46443_) {
            float offset = this.pushing ? 0.5f : this.maxDistance + 0.5f;
            Vec3 pos = VecHelper.getCenterOf((Vec3i)this.source.getAirCurrentPos()).m_82549_(Vec3.m_82528_((Vec3i)this.direction.m_122436_()).m_82490_((double)offset));
            if ((double)world.f_46441_.m_188501_() < (Double)DDConfigs.client().fanParticleDensity.get()) {
                world.m_7106_((ParticleOptions)new DDAirFlowParticleData((Vec3i)this.source.getAirCurrentPos()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
        }
        this.tickAffectedEntities(world);
        this.tickAffectedHandlers();
    }

    protected void tickAffectedEntities(Level world) {
        Iterator<Entity> iterator = this.caughtEntities.iterator();
        while (iterator.hasNext()) {
            InterfaceIndustrialProcessingType processingType;
            Entity entity = iterator.next();
            if (!entity.m_6084_() || !entity.m_20191_().m_82381_(this.bounds) || IndustrialAirCurrent.isPlayerCreativeFlying(entity)) {
                iterator.remove();
                continue;
            }
            Vec3i flow = (this.pushing ? this.direction : this.direction.m_122424_()).m_122436_();
            float speed = Math.abs(this.source.getSpeed());
            float sneakModifier = entity.m_6144_() ? 4096.0f : 512.0f;
            double entityDistance = VecHelper.alignedDistanceToFace((Vec3)entity.m_20182_(), (BlockPos)this.source.getAirCurrentPos(), (Direction)this.direction);
            double entityDistanceOld = entity.m_20182_().m_82554_(VecHelper.getCenterOf((Vec3i)this.source.getAirCurrentPos()));
            float acceleration = (float)((double)(speed / sneakModifier) / (entityDistanceOld / (double)this.maxDistance));
            Vec3 previousMotion = entity.m_20184_();
            float maxAcceleration = 5.0f;
            double xIn = Mth.m_14008_((double)((double)((float)flow.m_123341_() * acceleration) - previousMotion.f_82479_), (double)(-maxAcceleration), (double)maxAcceleration);
            double yIn = Mth.m_14008_((double)((double)((float)flow.m_123342_() * acceleration) - previousMotion.f_82480_), (double)(-maxAcceleration), (double)maxAcceleration);
            double zIn = Mth.m_14008_((double)((double)((float)flow.m_123343_() * acceleration) - previousMotion.f_82481_), (double)(-maxAcceleration), (double)maxAcceleration);
            entity.m_20256_(previousMotion.m_82549_(new Vec3(xIn, yIn, zIn).m_82490_(0.125)));
            entity.f_19789_ = 0.0f;
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> IndustrialAirCurrent.enableClientPlayerSound(entity, Mth.m_14036_((float)(speed / 128.0f * 0.4f), (float)0.01f, (float)0.4f)));
            if (entity instanceof DDServerPlayer) {
                ((DDServerPlayer)entity).connection.aboveGroundTickCount = 0;
            }
            if ((processingType = this.getTypeAt((float)entityDistance)) == IndustrialTypeFanProcessing.NONE) continue;
            if (entity instanceof ItemEntity) {
                IndustrialAirCurrentSource industrialAirCurrentSource;
                ItemEntity itemEntity = (ItemEntity)entity;
                if (world != null && world.f_46443_) {
                    processingType.spawnProcessingParticles(world, entity.m_20182_());
                    continue;
                }
                if (!DDFanProcessing.canProcess(itemEntity, processingType) || !DDFanProcessing.applyProcessing(itemEntity, processingType) || !((industrialAirCurrentSource = this.source) instanceof IndustrialFanBlockEntity)) continue;
                IndustrialFanBlockEntity fan = (IndustrialFanBlockEntity)industrialAirCurrentSource;
                fan.award(AllAdvancements.FAN_PROCESSING);
                continue;
            }
            if (world == null) continue;
            processingType.affectEntity(entity, world);
        }
    }

    public static boolean isPlayerCreativeFlying(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_7500_() && player.m_150110_().f_35935_;
        }
        return false;
    }

    public void tickAffectedHandlers() {
        for (Pair<DDTransportedItemStackHandlerBehaviour, InterfaceIndustrialProcessingType> pair : this.affectedItemHandlers) {
            DDTransportedItemStackHandlerBehaviour handler = (DDTransportedItemStackHandlerBehaviour)((Object)pair.getKey());
            Level world = handler.getWorld();
            InterfaceIndustrialProcessingType processingType = (InterfaceIndustrialProcessingType)pair.getRight();
            handler.DDhandleProcessingOnAllItems(transported -> {
                IndustrialAirCurrentSource patt7748$temp;
                if (world.f_46443_) {
                    processingType.spawnProcessingParticles(world, handler.getWorldPositionOf((DDTransportedItemStack)((Object)transported)));
                    return DDTransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                DDTransportedItemStackHandlerBehaviour.TransportedResult applyProcessing = DDFanProcessing.applyProcessing(transported, world, processingType);
                if (!applyProcessing.doesNothing() && (patt7748$temp = this.source) instanceof IndustrialFanBlockEntity) {
                    IndustrialFanBlockEntity fan = (IndustrialFanBlockEntity)patt7748$temp;
                    fan.award(AllAdvancements.FAN_PROCESSING);
                }
                return applyProcessing;
            });
        }
    }

    public void rebuild() {
        if (this.source.getSpeed() == 0.0f) {
            this.maxDistance = 0.0f;
            this.segments.clear();
            this.bounds = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            return;
        }
        this.direction = this.source.getAirflowOriginSide();
        this.pushing = this.source.getAirFlowDirection() == this.direction;
        this.maxDistance = this.source.getMaxDistance();
        Level world = this.source.getAirCurrentWorld();
        BlockPos start = this.source.getAirCurrentPos();
        float max = this.maxDistance;
        Direction facing = this.direction;
        Vec3 directionVec = Vec3.m_82528_((Vec3i)facing.m_122436_());
        this.maxDistance = IndustrialAirCurrent.getFlowLimit(world, start, max, facing);
        this.segments.clear();
        AirCurrentSegment currentSegment = null;
        InterfaceIndustrialProcessingType type = IndustrialTypeFanProcessing.NONE;
        int limit = this.getLimit();
        int searchStart = this.pushing ? 1 : limit;
        int searchEnd = this.pushing ? limit : 1;
        int searchStep = this.pushing ? 1 : -1;
        int toOffset = this.pushing ? -1 : 0;
        int i = searchStart;
        while (i * searchStep <= searchEnd * searchStep) {
            BlockPos currentPos = start.m_5484_(this.direction, i);
            InterfaceIndustrialProcessingType newType = InterfaceIndustrialProcessingType.getAt(world, currentPos);
            if (newType != IndustrialTypeFanProcessing.NONE) {
                type = newType;
            }
            if (currentSegment == null) {
                currentSegment = new AirCurrentSegment();
                currentSegment.startOffset = i + toOffset;
                currentSegment.type = type;
            } else if (currentSegment.type != type) {
                currentSegment.endOffset = i + toOffset;
                this.segments.add(currentSegment);
                currentSegment = new AirCurrentSegment();
                currentSegment.startOffset = i + toOffset;
                currentSegment.type = type;
            }
            i += searchStep;
        }
        if (currentSegment != null) {
            currentSegment.endOffset = searchEnd + searchStep + toOffset;
            this.segments.add(currentSegment);
        }
        if (this.maxDistance < 0.25f) {
            this.bounds = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        } else {
            float factor = this.maxDistance - 1.0f;
            Vec3 scale = directionVec.m_82490_((double)factor);
            this.bounds = factor > 0.0f ? new AABB(start.m_121945_(this.direction)).m_82369_(scale) : new AABB(start.m_121945_(this.direction)).m_82310_(scale.f_82479_, scale.f_82480_, scale.f_82481_).m_82383_(scale);
        }
        this.findAffectedHandlers();
    }

    public static float getFlowLimit(Level world, BlockPos start, float max, Direction facing) {
        int i = 0;
        while ((float)i < max) {
            VoxelShape shape;
            BlockPos currentPos = start.m_5484_(facing, i + 1);
            if (!world.m_46749_(currentPos)) {
                return i;
            }
            BlockState state = world.m_8055_(currentPos);
            BlockState copycatState = CopycatBlock.getMaterial((BlockGetter)world, (BlockPos)currentPos);
            if (!IndustrialAirCurrent.shouldAlwaysPass(copycatState.m_60795_() ? state : copycatState) && !(shape = state.m_60812_((BlockGetter)world, currentPos)).m_83281_()) {
                if (shape == Shapes.m_83144_()) {
                    return i;
                }
                double shapeDepth = IndustrialAirCurrent.findMaxDepth(shape, facing);
                if (shapeDepth != Double.POSITIVE_INFINITY) {
                    return Math.min((float)((double)i + shapeDepth + 0.03125), max);
                }
            }
            ++i;
        }
        return max;
    }

    private static double findMaxDepth(VoxelShape shape, Direction direction) {
        Direction.Axis axis = direction.m_122434_();
        Direction.AxisDirection axisDirection = direction.m_122421_();
        double maxDepth = 0.0;
        for (double[] coordinates : DEPTH_TEST_COORDINATES) {
            double depth;
            if (axisDirection == Direction.AxisDirection.POSITIVE) {
                double min = shape.m_166078_(axis, coordinates[0], coordinates[1]);
                if (min == Double.POSITIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
                depth = min;
            } else {
                double max = shape.m_83290_(axis, coordinates[0], coordinates[1]);
                if (max == Double.NEGATIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
                depth = 1.0 - max;
            }
            if (!(depth > maxDepth)) continue;
            maxDepth = depth;
        }
        return maxDepth;
    }

    private static boolean shouldAlwaysPass(BlockState state) {
        return AllTags.AllBlockTags.FAN_TRANSPARENT.matches(state);
    }

    private int getLimit() {
        if ((float)((int)this.maxDistance) == this.maxDistance) {
            return (int)this.maxDistance;
        }
        return (int)this.maxDistance + 1;
    }

    public void findAffectedHandlers() {
        Level world = this.source.getAirCurrentWorld();
        BlockPos start = this.source.getAirCurrentPos();
        this.affectedItemHandlers.clear();
        int limit = this.getLimit();
        block0: for (int i = 1; i <= limit; ++i) {
            InterfaceIndustrialProcessingType segmentType = this.getTypeAt(i - 1);
            for (int offset : Iterate.zeroAndOne) {
                BlockPos pos = start.m_5484_(this.direction, i).m_6625_(offset);
                DDTransportedItemStackHandlerBehaviour behaviour = (DDTransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, DDTransportedItemStackHandlerBehaviour.TYPE);
                if (behaviour != null) {
                    InterfaceIndustrialProcessingType type = InterfaceIndustrialProcessingType.getAt(world, pos);
                    if (type == IndustrialTypeFanProcessing.NONE) {
                        type = segmentType;
                    }
                    this.affectedItemHandlers.add((Pair<DDTransportedItemStackHandlerBehaviour, InterfaceIndustrialProcessingType>)Pair.of((Object)((Object)behaviour), (Object)type));
                }
                if (this.direction.m_122434_().m_122478_()) continue block0;
            }
        }
    }

    public void findEntities() {
        this.caughtEntities.clear();
        this.caughtEntities = this.source.getAirCurrentWorld().m_45933_(null, this.bounds);
    }

    public InterfaceIndustrialProcessingType getTypeAt(float offset) {
        block4: {
            if (!(offset >= 0.0f) || !(offset <= this.maxDistance)) break block4;
            if (this.pushing) {
                for (AirCurrentSegment airCurrentSegment : this.segments) {
                    if (!(offset <= (float)airCurrentSegment.endOffset)) continue;
                    return airCurrentSegment.type;
                }
            } else {
                for (AirCurrentSegment airCurrentSegment : this.segments) {
                    if (!(offset >= (float)airCurrentSegment.endOffset)) continue;
                    return airCurrentSegment.type;
                }
            }
        }
        return IndustrialTypeFanProcessing.NONE;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void enableClientPlayerSound(Entity e, float maxVolume) {
        if (e != Minecraft.m_91087_().m_91288_()) {
            return;
        }
        isClientPlayerInAirCurrent = true;
        float pitch = (float)Mth.m_14008_((double)(e.m_20184_().m_82553_() * 0.5), (double)0.5, (double)2.0);
        if (flyingSound == null || flyingSound.m_7801_()) {
            flyingSound = new IndustrialAirCurrentSound(SoundEvents.f_11886_, pitch);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)flyingSound);
        }
        flyingSound.setPitch(pitch);
        flyingSound.fadeIn(maxVolume);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tickClientPlayerSounds() {
        if (!isClientPlayerInAirCurrent && flyingSound != null) {
            if (flyingSound.isFaded()) {
                flyingSound.stopSound();
            } else {
                flyingSound.fadeOut();
            }
        }
        isClientPlayerInAirCurrent = false;
    }

    private static class AirCurrentSegment {
        private InterfaceIndustrialProcessingType type;
        private int startOffset;
        private int endOffset;

        private AirCurrentSegment() {
        }
    }
}

