/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockProperties.flywheel.engine;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllShapes;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import uwu.lopyluna.create_dd.block.BlockProperties.flywheel.engine.EngineBlock;
import uwu.lopyluna.create_dd.block.BlockProperties.flywheel.engine.FurnaceEngineBlockEntity;
import uwu.lopyluna.create_dd.block.BlockProperties.flywheel.engine.FurnaceEngineInteractions;
import uwu.lopyluna.create_dd.block.BlockResources.DDBlockPartialModel;
import uwu.lopyluna.create_dd.block.DDBlockEntityTypes;
import uwu.lopyluna.create_dd.block.DDBlocks;

@Mod.EventBusSubscriber
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FurnaceEngineBlock
extends EngineBlock
implements IBE<FurnaceEngineBlockEntity> {
    public FurnaceEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected boolean isValidBaseBlock(BlockState baseBlock, BlockGetter world, BlockPos pos) {
        return FurnaceEngineInteractions.getHandler(baseBlock).getHeatSource(baseBlock).isValid();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.FURNACE_ENGINE.get((Direction)state.m_61143_((Property)f_54117_));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public PartialModel getFrameModel() {
        return DDBlockPartialModel.FURNACE_GENERATOR_FRAME;
    }

    @Override
    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (worldIn instanceof WrappedWorld) {
            return;
        }
        if (worldIn.f_46443_) {
            return;
        }
        if (fromPos.equals((Object)FurnaceEngineBlock.getBaseBlockPos(state, pos)) && this.m_7898_(state, (LevelReader)worldIn, pos)) {
            this.withBlockEntityDo((BlockGetter)worldIn, pos, FurnaceEngineBlockEntity::updateFurnace);
        }
    }

    @SubscribeEvent
    public static void usingFurnaceEngineOnFurnacePreventsGUI(PlayerInteractEvent.RightClickBlock event) {
        ItemStack item = event.getItemStack();
        Item item2 = item.m_41720_();
        if (!(item2 instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item2;
        if (blockItem.m_40614_() != DDBlocks.FURNACE_ENGINE.get()) {
            return;
        }
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (event.getFace().m_122434_().m_122478_()) {
            return;
        }
        if (state.m_60734_() instanceof AbstractFurnaceBlock) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    public Class<FurnaceEngineBlockEntity> getBlockEntityClass() {
        return FurnaceEngineBlockEntity.class;
    }

    public BlockEntityType<? extends FurnaceEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DDBlockEntityTypes.FURNACE_ENGINE.get();
    }
}

