/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockProperties.flywheel.engine;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import uwu.lopyluna.create_dd.block.BlockProperties.flywheel.FlywheelBlock;
import uwu.lopyluna.create_dd.block.BlockProperties.flywheel.FlywheelBlockEntity;
import uwu.lopyluna.create_dd.block.BlockProperties.flywheel.engine.EngineBlock;
import uwu.lopyluna.create_dd.block.DDBlocks;

public class EngineBlockEntity
extends SmartBlockEntity {
    public float appliedCapacity;
    public float appliedSpeed;
    protected FlywheelBlockEntity poweredWheel;

    public EngineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(1.5);
    }

    public void tick() {
        super.tick();
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.poweredWheel != null && this.poweredWheel.m_58901_()) {
            this.poweredWheel = null;
        }
        if (this.poweredWheel == null) {
            this.attachWheel();
        }
    }

    public void attachWheel() {
        Direction engineFacing = (Direction)this.m_58900_().m_61143_((Property)EngineBlock.f_54117_);
        BlockPos wheelPos = this.f_58858_.m_5484_(engineFacing, 2);
        assert (this.f_58857_ != null);
        BlockState wheelState = this.f_58857_.m_8055_(wheelPos);
        if (!DDBlocks.FLYWHEEL.has(wheelState)) {
            return;
        }
        Direction wheelFacing = (Direction)wheelState.m_61143_(FlywheelBlock.HORIZONTAL_FACING);
        if (wheelFacing.m_122434_() != engineFacing.m_122427_().m_122434_()) {
            return;
        }
        if (FlywheelBlock.isConnected(wheelState) && FlywheelBlock.getConnection(wheelState) != engineFacing.m_122424_()) {
            return;
        }
        BlockEntity be = this.f_58857_.m_7702_(wheelPos);
        assert (be != null);
        if (be.m_58901_()) {
            return;
        }
        if (be instanceof FlywheelBlockEntity) {
            if (!FlywheelBlock.isConnected(wheelState)) {
                FlywheelBlock.setConnection(this.f_58857_, be.m_58899_(), be.m_58900_(), engineFacing.m_122424_());
            }
            this.poweredWheel = (FlywheelBlockEntity)be;
            this.refreshWheelSpeed();
        }
    }

    public void detachWheel() {
        if (this.poweredWheel == null || this.poweredWheel.m_58901_()) {
            return;
        }
        this.poweredWheel.setRotation(0.0f, 0.0f);
        FlywheelBlock.setConnection(this.f_58857_, this.poweredWheel.m_58899_(), this.poweredWheel.m_58900_(), null);
        this.poweredWheel = null;
    }

    public void remove() {
        this.detachWheel();
        super.remove();
    }

    protected void refreshWheelSpeed() {
        if (this.poweredWheel == null) {
            return;
        }
        this.poweredWheel.setRotation(this.appliedSpeed, this.appliedCapacity);
    }
}

