/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockProperties.drill.radiant;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.render.ActorInstance;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uwu.lopyluna.create_dd.DDTags;
import uwu.lopyluna.create_dd.block.BlockProperties.drill.radiant.RadiantDrillActorInstance;
import uwu.lopyluna.create_dd.block.BlockProperties.drill.radiant.RadiantDrillBlock;
import uwu.lopyluna.create_dd.block.BlockProperties.drill.radiant.RadiantDrillBlockBreakingKineticBlockEntity;
import uwu.lopyluna.create_dd.block.BlockProperties.drill.radiant.RadiantDrillRenderer;

public class RadiantDrillMovementBehaviour
extends BlockBreakingMovementBehaviour {
    public void tickBreaker(MovementContext context) {
        CompoundTag data = context.data;
        if (context.world.f_46443_) {
            return;
        }
        if (!data.m_128441_("BreakingPos")) {
            context.stall = false;
            return;
        }
        if (context.relativeMotion.equals((Object)Vec3.f_82478_)) {
            context.stall = false;
            return;
        }
        int ticksUntilNextProgress = data.m_128451_("TicksUntilNextProgress");
        if (ticksUntilNextProgress-- > 0) {
            data.m_128405_("TicksUntilNextProgress", ticksUntilNextProgress);
            return;
        }
        Level world = context.world;
        BlockPos breakingPos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("BreakingPos"));
        int destroyProgress = data.m_128451_("Progress");
        int id = data.m_128451_("BreakerId");
        BlockState stateToBreak = world.m_8055_(breakingPos);
        float blockHardness = stateToBreak.m_60800_((BlockGetter)world, breakingPos);
        if (!this.canBreak(world, breakingPos, stateToBreak)) {
            if (destroyProgress != 0) {
                destroyProgress = 0;
                data.m_128473_("Progress");
                data.m_128473_("TicksUntilNextProgress");
                data.m_128473_("BreakingPos");
                world.m_6801_(id, breakingPos, -1);
            }
            context.stall = false;
            return;
        }
        float breakSpeed = this.getBlockBreakingSpeed(context);
        destroyProgress += Mth.m_14045_((int)((int)(breakSpeed / blockHardness)), (int)1, (int)(10 - destroyProgress));
        world.m_5594_(null, breakingPos, stateToBreak.m_60827_().m_56778_(), SoundSource.NEUTRAL, 0.25f, 1.0f);
        if (destroyProgress >= 10) {
            world.m_6801_(id, breakingPos, -1);
            BlockPos ogPos = breakingPos;
            BlockState stateAbove = world.m_8055_(breakingPos.m_7494_());
            while (stateAbove.m_60734_() instanceof FallingBlock) {
                breakingPos = breakingPos.m_7494_();
                stateAbove = world.m_8055_(breakingPos.m_7494_());
            }
            stateToBreak = world.m_8055_(breakingPos);
            context.stall = false;
            if (this.shouldDestroyStartBlock(stateToBreak)) {
                this.radiantDestroyBlock(context, breakingPos);
            }
            this.onBlockBroken(context, ogPos, stateToBreak);
            ticksUntilNextProgress = -1;
            data.m_128473_("Progress");
            data.m_128473_("TicksUntilNextProgress");
            data.m_128473_("BreakingPos");
            return;
        }
        ticksUntilNextProgress = (int)(blockHardness / breakSpeed);
        world.m_6801_(id, breakingPos, destroyProgress);
        data.m_128405_("TicksUntilNextProgress", ticksUntilNextProgress);
        data.m_128405_("Progress", destroyProgress);
    }

    protected void radiantDestroyBlock(MovementContext context, BlockPos breakingPos) {
        RadiantDrillBlockBreakingKineticBlockEntity.fortunedestroyBlock(context.world, breakingPos, 1.0f, stack -> this.dropItem(context, (ItemStack)stack));
    }

    protected void destroyBlock(MovementContext context, BlockPos breakingPos) {
        RadiantDrillBlockBreakingKineticBlockEntity.fortunedestroyBlock(context.world, breakingPos, 1.0f, stack -> this.dropItem(context, (ItemStack)stack));
    }

    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)((Direction)context.state.m_61143_((Property)RadiantDrillBlock.FACING)).m_122424_());
    }

    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)RadiantDrillBlock.FACING)).m_122436_()).m_82490_((double)0.65f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        if (!ContraptionRenderDispatcher.canInstance()) {
            RadiantDrillRenderer.renderInContraption(context, renderWorld, matrices, buffer);
        }
    }

    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Nullable
    public ActorInstance createInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        return new RadiantDrillActorInstance(materialManager, simulationWorld, context);
    }

    protected DamageSource getDamageSource(Level level) {
        return CreateDamageSources.drill((Level)level);
    }

    protected float getBlockBreakingSpeed(MovementContext context) {
        float lowerLimit = 0.0078125f;
        if (context.contraption instanceof MountedContraption) {
            lowerLimit = 1.0f;
        }
        if (context.contraption instanceof CarriageContraption) {
            lowerLimit = 2.0f;
        }
        return Mth.m_14036_((float)(Math.abs(context.getAnimationSpeed()) / 25.0f), (float)lowerLimit, (float)16.0f);
    }

    public boolean canBreak(Level world, BlockPos breakingPos, BlockState state) {
        return super.canBreak(world, breakingPos, state) && !state.m_60812_((BlockGetter)world, breakingPos).m_83281_() && !AllTags.AllBlockTags.TRACKS.matches(state) && !DDTags.AllBlockTags.radiant_drill_immune.matches(state);
    }
}

