/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockProperties.drill.radiant;

import com.simibubi.create.content.kinetics.base.BlockBreakingKineticBlockEntity;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import uwu.lopyluna.create_dd.DDTags;

public abstract class RadiantDrillBlockBreakingKineticBlockEntity
extends BlockBreakingKineticBlockEntity {
    public RadiantDrillBlockBreakingKineticBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        float blockHardness;
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.shouldRun()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        this.breakingPos = this.getBreakingPos();
        if (this.ticksUntilNextProgress < 0) {
            return;
        }
        if (this.ticksUntilNextProgress-- > 0) {
            return;
        }
        BlockState stateToBreak = this.f_58857_.m_8055_(this.breakingPos);
        if (!this.canBreak(stateToBreak, blockHardness = stateToBreak.m_60800_((BlockGetter)this.f_58857_, this.breakingPos))) {
            if (this.destroyProgress != 0) {
                this.destroyProgress = 0;
                this.f_58857_.m_6801_(this.breakerId, this.breakingPos, -1);
            }
            return;
        }
        float breakSpeed = this.getBreakSpeed();
        this.destroyProgress += Mth.m_14045_((int)((int)(breakSpeed / blockHardness)), (int)1, (int)(10 - this.destroyProgress));
        this.f_58857_.m_5594_(null, this.f_58858_, stateToBreak.m_60827_().m_56778_(), SoundSource.NEUTRAL, 0.25f, 1.0f);
        if (this.destroyProgress >= 10) {
            this.onBlockBroken(stateToBreak);
            this.destroyProgress = 0;
            this.ticksUntilNextProgress = -1;
            this.f_58857_.m_6801_(this.breakerId, this.breakingPos, -1);
            return;
        }
        this.ticksUntilNextProgress = (int)(blockHardness / breakSpeed);
        this.f_58857_.m_6801_(this.breakerId, this.breakingPos, this.destroyProgress);
    }

    public boolean canBreak(BlockState stateToBreak, float blockHardness) {
        return RadiantDrillBlockBreakingKineticBlockEntity.isBreakable(stateToBreak, blockHardness);
    }

    public static boolean isBreakable(BlockState stateToBreak, float blockHardness) {
        return !stateToBreak.m_278721_() && !(stateToBreak.m_60734_() instanceof AirBlock) && blockHardness != -1.0f && !DDTags.AllBlockTags.radiant_drill_immune.matches(stateToBreak);
    }

    public static void fortunedestroyBlock(Level world, BlockPos pos, float effectChance, Consumer<ItemStack> droppedItemCallback) {
        ItemStack iStack = Items.f_42455_.m_7968_();
        iStack.m_41663_(Enchantments.f_44987_, 4);
        BlockHelper.destroyBlockAs((Level)world, (BlockPos)pos, null, (ItemStack)iStack, (float)effectChance, droppedItemCallback);
    }

    public void onBlockBroken(BlockState stateToBreak) {
        Vec3 vec = VecHelper.offsetRandomly((Vec3)VecHelper.getCenterOf((Vec3i)this.breakingPos), (RandomSource)this.f_58857_.f_46441_, (float)0.05f);
        RadiantDrillBlockBreakingKineticBlockEntity.fortunedestroyBlock(this.f_58857_, this.breakingPos, 1.0f, stack -> {
            if (stack.m_41619_()) {
                return;
            }
            if (!this.f_58857_.m_46469_().m_46207_(GameRules.f_46136_)) {
                return;
            }
            if (this.f_58857_.restoringBlockSnapshots) {
                return;
            }
            ItemEntity itementity = new ItemEntity(this.f_58857_, vec.f_82479_, vec.f_82480_, vec.f_82481_, stack);
            itementity.m_32060_();
            itementity.m_20256_(Vec3.f_82478_);
            itementity.m_20331_(true);
            itementity.m_20242_(true);
            this.f_58857_.m_7967_((Entity)itementity);
        });
    }

    protected float getBreakSpeed() {
        return Math.abs(this.getSpeed() / 10.0f);
    }
}

