/*
 * Decompiled with CFR 0.152.
 */
package pyre.tinkerslevellingaddon.config;

import com.electronwill.nightconfig.core.EnumGetMethod;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import pyre.tinkerslevellingaddon.util.ToolLevellingUtil;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class Config {
    private static final List<String> DEFAULT_TOOLS_SLOTS_ORDER = List.of("upgrade", "upgrade", "upgrade", "ability", "upgrade");
    private static final List<String> DEFAULT_TOOLS_SLOTS_RANDOM_POOL = List.of("upgrade", "upgrade", "upgrade", "upgrade", "ability");
    private static final List<String> DEFAULT_RANGED_SLOTS_ORDER = List.of("upgrade", "upgrade", "upgrade", "ability", "upgrade");
    private static final List<String> DEFAULT_RANGED_SLOTS_RANDOM_POOL = List.of("upgrade", "upgrade", "upgrade", "upgrade", "ability");
    private static final List<String> DEFAULT_ARMOR_SLOTS_ORDER = List.of("upgrade", "defense", "upgrade", "ability", "defense");
    private static final List<String> DEFAULT_ARMOR_SLOTS_RANDOM_POOL = List.of("upgrade", "upgrade", "defense", "defense", "ability");
    private static final List<String> DEFAULT_STAFF_SLOTS_ORDER = List.of("upgrade", "upgrade", "upgrade", "defense", "ability");
    private static final List<String> DEFAULT_STAFF_SLOTS_RANDOM_POOL = List.of("upgrade", "upgrade", "upgrade", "defense", "ability");
    private static final List<String> DEFAULT_TOOLS_STATS_ORDER = List.of("durability", "attackDamage", "attackSpeed", "miningSpeed");
    private static final List<String> DEFAULT_TOOLS_STATS_RANDOM_POOL = List.of("durability", "attackDamage", "attackSpeed", "miningSpeed");
    private static final List<String> DEFAULT_RANGED_STATS_ORDER = List.of("durability", "drawSpeed", "velocity", "accuracy", "projectileDamage");
    private static final List<String> DEFAULT_RANGED_STATS_RANDOM_POOL = List.of("durability", "drawSpeed", "velocity", "accuracy", "projectileDamage");
    private static final List<String> DEFAULT_ARMOR_STATS_ORDER = List.of("durability", "armor", "armorToughness", "knockbackResistance");
    private static final List<String> DEFAULT_ARMOR_STATS_RANDOM_POOL = List.of("durability", "armor", "armorToughness", "knockbackResistance");
    private static final List<String> DEFAULT_STAFF_STATS_ORDER = List.of("durability", "drawSpeed", "velocity", "accuracy", "projectileDamage", "armor");
    private static final List<String> DEFAULT_STAFF_STATS_RANDOM_POOL = List.of("durability", "drawSpeed", "velocity", "accuracy", "projectileDamage", "armor");
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec.EnumValue<GainingMethod> toolsSlotGainingMethod;
    public static ForgeConfigSpec.EnumValue<GainingMethod> toolsStatGainingMethod;
    public static ForgeConfigSpec.EnumValue<GainingMethod> rangedSlotGainingMethod;
    public static ForgeConfigSpec.EnumValue<GainingMethod> rangedStatGainingMethod;
    public static ForgeConfigSpec.EnumValue<GainingMethod> armorSlotGainingMethod;
    public static ForgeConfigSpec.EnumValue<GainingMethod> armorStatGainingMethod;
    public static ForgeConfigSpec.EnumValue<GainingMethod> staffSlotGainingMethod;
    public static ForgeConfigSpec.EnumValue<GainingMethod> staffStatGainingMethod;
    public static ForgeConfigSpec.IntValue maxLevel;
    public static ForgeConfigSpec.IntValue baseExperience;
    public static ForgeConfigSpec.DoubleValue requiredXpMultiplier;
    public static ForgeConfigSpec.DoubleValue broadToolRequiredXpMultiplier;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> toolsSlotTypeRandomPool;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> toolsSlotTypeOrder;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> rangedSlotTypeRandomPool;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> rangedSlotTypeOrder;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> armorSlotTypeRandomPool;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> armorSlotTypeOrder;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> staffSlotTypeRandomPool;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> staffSlotTypeOrder;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> toolsStatTypeRandomPool;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> toolsStatTypeOrder;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> rangedStatTypeRandomPool;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> rangedStatTypeOrder;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> armorStatTypeRandomPool;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> armorStatTypeOrder;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> staffStatTypeRandomPool;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> staffStatTypeOrder;
    public static ForgeConfigSpec.IntValue toolDurabilityValue;
    public static ForgeConfigSpec.DoubleValue toolAttackDamageValue;
    public static ForgeConfigSpec.DoubleValue toolAttackSpeedValue;
    public static ForgeConfigSpec.DoubleValue toolMiningSpeedValue;
    public static ForgeConfigSpec.IntValue rangedDurabilityValue;
    public static ForgeConfigSpec.DoubleValue rangedDrawSpeedValue;
    public static ForgeConfigSpec.DoubleValue rangedVelocityValue;
    public static ForgeConfigSpec.DoubleValue rangedAccuracyValue;
    public static ForgeConfigSpec.DoubleValue rangedProjectileDamageValue;
    public static ForgeConfigSpec.DoubleValue rangedAttackDamageValue;
    public static ForgeConfigSpec.DoubleValue rangedAttackSpeedValue;
    public static ForgeConfigSpec.IntValue armorDurabilityValue;
    public static ForgeConfigSpec.DoubleValue armorArmorValue;
    public static ForgeConfigSpec.DoubleValue armorArmorToughnessValue;
    public static ForgeConfigSpec.DoubleValue armorKnockbackResistanceValue;
    public static ForgeConfigSpec.IntValue staffDurabilityValue;
    public static ForgeConfigSpec.DoubleValue staffDrawSpeedValue;
    public static ForgeConfigSpec.DoubleValue staffVelocityValue;
    public static ForgeConfigSpec.DoubleValue staffAccuracyValue;
    public static ForgeConfigSpec.DoubleValue staffProjectileDamageValue;
    public static ForgeConfigSpec.DoubleValue staffArmorValue;
    public static ForgeConfigSpec.BooleanValue damageDealt;
    public static ForgeConfigSpec.BooleanValue damageTaken;
    public static ForgeConfigSpec.BooleanValue damageBlocked;
    public static ForgeConfigSpec.BooleanValue enablePvp;
    public static ForgeConfigSpec.IntValue flyingTime;
    public static ForgeConfigSpec.BooleanValue enableMiningXp;
    public static ForgeConfigSpec.BooleanValue enableHarvestingXp;
    public static ForgeConfigSpec.BooleanValue enableShearingXp;
    public static ForgeConfigSpec.BooleanValue enableStrippingXp;
    public static ForgeConfigSpec.BooleanValue enableScrappingXp;
    public static ForgeConfigSpec.BooleanValue enableWaxingOffXp;
    public static ForgeConfigSpec.BooleanValue enableTillingXp;
    public static ForgeConfigSpec.BooleanValue enablePathMakingXp;
    public static ForgeConfigSpec.BooleanValue enableAttackingXp;
    public static ForgeConfigSpec.BooleanValue enableShootingXp;
    public static ForgeConfigSpec.BooleanValue enableTakingDamageXp;
    public static ForgeConfigSpec.BooleanValue enableBlockingDamageXp;
    public static ForgeConfigSpec.BooleanValue enableThornsXp;
    public static ForgeConfigSpec.BooleanValue enableFlyingXp;
    public static ForgeConfigSpec.BooleanValue enablePlowingXp;
    public static ForgeConfigSpec.BooleanValue enablePathMakerXp;
    public static ForgeConfigSpec.BooleanValue enableSnowdriftXp;
    public static ForgeConfigSpec.BooleanValue enableFlamewakeXp;
    public static ForgeConfigSpec.BooleanValue enableFrostWalkerXp;
    public static ForgeConfigSpec.BooleanValue enableWarpingXp;
    public static ForgeConfigSpec.BooleanValue enableFlingingXp;
    public static ForgeConfigSpec.BooleanValue enableSpringingXp;
    public static ForgeConfigSpec.BooleanValue enableBonkingXp;
    public static ForgeConfigSpec.BooleanValue enableGlowingXp;
    public static ForgeConfigSpec.BooleanValue enableFirestarterXp;
    public static ForgeConfigSpec.IntValue bonusMiningXp;
    public static ForgeConfigSpec.IntValue bonusHarvestingXp;
    public static ForgeConfigSpec.IntValue bonusShearingXp;
    public static ForgeConfigSpec.IntValue bonusStrippingXp;
    public static ForgeConfigSpec.IntValue bonusScrappingXp;
    public static ForgeConfigSpec.IntValue bonusWaxingOffXp;
    public static ForgeConfigSpec.IntValue bonusTillingXp;
    public static ForgeConfigSpec.IntValue bonusPathMakingXp;
    public static ForgeConfigSpec.IntValue bonusAttackingXp;
    public static ForgeConfigSpec.IntValue bonusShootingXp;
    public static ForgeConfigSpec.IntValue bonusTakingDamageXp;
    public static ForgeConfigSpec.IntValue bonusBlockingDamageXp;
    public static ForgeConfigSpec.IntValue bonusThornsXp;
    public static ForgeConfigSpec.IntValue bonusFlyingXp;
    public static ForgeConfigSpec.IntValue bonusPlowingXp;
    public static ForgeConfigSpec.IntValue bonusPathMakerXp;
    public static ForgeConfigSpec.IntValue bonusSnowdriftXp;
    public static ForgeConfigSpec.IntValue bonusFlamewakeXp;
    public static ForgeConfigSpec.IntValue bonusFrostWalkerXp;
    public static ForgeConfigSpec.IntValue bonusWarpingXp;
    public static ForgeConfigSpec.IntValue bonusFlingingXp;
    public static ForgeConfigSpec.IntValue bonusSpringingXp;
    public static ForgeConfigSpec.IntValue bonusBonkingXp;
    public static ForgeConfigSpec.IntValue bonusGlowingXp;
    public static ForgeConfigSpec.IntValue bonusFirestarterXp;
    public static ForgeConfigSpec.BooleanValue enableLevelUpMessage;
    public static ForgeConfigSpec.BooleanValue squashLevelPluses;
    public static ForgeConfigSpec.EnumValue<LevelUpSound> levelUpSound;

    private static void generalConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("General addon settings").push("general");
        toolsSlotGainingMethod = builder.comment("Method of gaining modifier slots for tools.").translation("config.tinkerslevellingaddon.general.tools_slot_gaining_method").defineEnum("toolsSlotGainingMethod", (Enum)GainingMethod.PREDEFINED_ORDER, EnumGetMethod.NAME_IGNORECASE, (Enum[])GainingMethod.values());
        rangedSlotGainingMethod = builder.comment("Method of gaining modifier slots for ranged weapons.").translation("config.tinkerslevellingaddon.general.ranged_slot_gaining_method").defineEnum("rangedSlotGainingMethod", (Enum)GainingMethod.PREDEFINED_ORDER, EnumGetMethod.NAME_IGNORECASE, (Enum[])GainingMethod.values());
        armorSlotGainingMethod = builder.comment("Method of gaining modifier slots for armor.").translation("config.tinkerslevellingaddon.general.armor_slot_gaining_method").defineEnum("armorSlotGainingMethod", (Enum)GainingMethod.PREDEFINED_ORDER, EnumGetMethod.NAME_IGNORECASE, (Enum[])GainingMethod.values());
        staffSlotGainingMethod = builder.comment("Method of gaining modifier slots for staffs.").translation("config.tinkerslevellingaddon.general.staff_slot_gaining_method").defineEnum("staffSlotGainingMethod", (Enum)GainingMethod.PREDEFINED_ORDER, EnumGetMethod.NAME_IGNORECASE, (Enum[])GainingMethod.values());
        Config.slotsConfig(builder);
        toolsStatGainingMethod = builder.comment("Method of gaining stats for tools.").translation("config.tinkerslevellingaddon.general.tools_stat_gaining_method").defineEnum("toolsStatGainingMethod", (Enum)GainingMethod.NONE, EnumGetMethod.NAME_IGNORECASE, (Enum[])GainingMethod.values());
        rangedStatGainingMethod = builder.comment("Method of gaining stats for tools.").translation("config.tinkerslevellingaddon.general.ranged_stat_gaining_method").defineEnum("rangedStatGainingMethod", (Enum)GainingMethod.NONE, EnumGetMethod.NAME_IGNORECASE, (Enum[])GainingMethod.values());
        armorStatGainingMethod = builder.comment("Method of gaining stats for armor.").translation("config.tinkerslevellingaddon.general.armor_stat_gaining_method").defineEnum("armorStatGainingMethod", (Enum)GainingMethod.NONE, EnumGetMethod.NAME_IGNORECASE, (Enum[])GainingMethod.values());
        staffStatGainingMethod = builder.comment("Method of gaining stats for staffs.").translation("config.tinkerslevellingaddon.general.staff_stat_gaining_method").defineEnum("staffStatGainingMethod", (Enum)GainingMethod.NONE, EnumGetMethod.NAME_IGNORECASE, (Enum[])GainingMethod.values());
        Config.statsConfig(builder);
        maxLevel = builder.comment("Maximum tool level that could be achieved. If set to 0 there is no upper limit.").translation("config.tinkerslevellingaddon.general.max_level").defineInRange("maxLevel", 5, 0, Integer.MAX_VALUE);
        baseExperience = builder.comment("Base amount of experience required to reach next level.").translation("config.tinkerslevellingaddon.general.base_experience").defineInRange("baseExperience", 500, 1, Integer.MAX_VALUE);
        requiredXpMultiplier = builder.comment("How much the amount of experience required to reach next level will be multiplied per level.").translation("config.tinkerslevellingaddon.general.required_xp_multiplier").defineInRange("requiredXpMultiplier", 2.0, 1.0, 10.0);
        broadToolRequiredXpMultiplier = builder.comment("Additional multiplier for broad tools for experience required to level up.").translation("config.tinkerslevellingaddon.general.broad_tool_required_xp_multiplier").defineInRange("broadToolRequiredXpMultiplier", 3.0, 1.0, 10.0);
        builder.pop();
    }

    private static void slotsConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Modifier slots settings").push("slots");
        toolsSlotTypeRandomPool = builder.comment(new String[]{"Set of modifier slot types from which random slot will be awarded when leveling up tools.", "If empty default pool will be used (" + String.join((CharSequence)", ", DEFAULT_TOOLS_SLOTS_RANDOM_POOL) + "). 80% chance for upgrade and 20% chance for ability.", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getToolSlotTypes())}).translation("config.tinkerslevellingaddon.general.slots.tools_slot_type_random_pool").defineList("toolsSlotTypeRandomPool", DEFAULT_TOOLS_SLOTS_RANDOM_POOL, t -> ToolLevellingUtil.getToolSlotTypes().contains(t));
        toolsSlotTypeOrder = builder.comment(new String[]{"List of modifier slot types (in order) that will be awarded when leveling up tools. If level is higher than list size the mod will start over.", "If empty default order will be used (" + String.join((CharSequence)", ", DEFAULT_TOOLS_SLOTS_ORDER) + ").", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getToolSlotTypes())}).translation("config.tinkerslevellingaddon.general.slots.tools_slot_type_order").defineList("toolsSlotTypeOrder", DEFAULT_TOOLS_SLOTS_ORDER, t -> ToolLevellingUtil.getToolSlotTypes().contains(t));
        rangedSlotTypeRandomPool = builder.comment(new String[]{"Set of modifier slot types from which random slot will be awarded when leveling up ranged weapons.", "If empty default pool will be used (" + String.join((CharSequence)", ", DEFAULT_RANGED_SLOTS_RANDOM_POOL) + "). 80% chance for upgrade and 20% chance for ability.", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getToolSlotTypes())}).translation("config.tinkerslevellingaddon.general.slots.ranged_slot_type_random_pool").defineList("rangedSlotTypeRandomPool", DEFAULT_RANGED_SLOTS_RANDOM_POOL, t -> ToolLevellingUtil.getRangedSlotTypes().contains(t));
        rangedSlotTypeOrder = builder.comment(new String[]{"List of modifier slot types (in order) that will be awarded when leveling up ranged weapons. If level is higher than list size the mod will start over.", "If empty default order will be used (" + String.join((CharSequence)", ", DEFAULT_RANGED_SLOTS_ORDER) + ").", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getToolSlotTypes())}).translation("config.tinkerslevellingaddon.general.slots.ranged_slot_type_order").defineList("rangedSlotTypeOrder", DEFAULT_RANGED_SLOTS_ORDER, t -> ToolLevellingUtil.getRangedSlotTypes().contains(t));
        armorSlotTypeRandomPool = builder.comment(new String[]{"Set of modifier slot types from which random slot will be awarded when leveling up armor.", "If empty default pool will be used (" + String.join((CharSequence)", ", DEFAULT_ARMOR_SLOTS_RANDOM_POOL) + ").", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getArmorSlotTypes())}).translation("config.tinkerslevellingaddon.general.modifiers.armor_slot_type_random_pool").defineList("armorSlotTypeRandomPool", DEFAULT_ARMOR_SLOTS_RANDOM_POOL, t -> ToolLevellingUtil.getArmorSlotTypes().contains(t));
        armorSlotTypeOrder = builder.comment(new String[]{"List of modifier slot types (in order) that will be awarded when leveling up armor. If level is higher than list size the mod will start over.", "If empty default order will be used (" + String.join((CharSequence)", ", DEFAULT_ARMOR_SLOTS_ORDER) + ").", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getArmorSlotTypes())}).translation("config.tinkerslevellingaddon.general.slots.armor_slot_type_order").defineList("armorSlotTypeOrder", DEFAULT_ARMOR_SLOTS_ORDER, t -> ToolLevellingUtil.getArmorSlotTypes().contains(t));
        staffSlotTypeRandomPool = builder.comment(new String[]{"Set of modifier slot types from which random slot will be awarded when leveling up staffs.", "If empty default pool will be used (" + String.join((CharSequence)", ", DEFAULT_STAFF_SLOTS_RANDOM_POOL) + ").", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getArmorSlotTypes())}).translation("config.tinkerslevellingaddon.general.modifiers.staff_slot_type_random_pool").defineList("staffSlotTypeRandomPool", DEFAULT_STAFF_SLOTS_RANDOM_POOL, t -> ToolLevellingUtil.getStaffSlotTypes().contains(t));
        staffSlotTypeOrder = builder.comment(new String[]{"List of modifier slot types (in order) that will be awarded when leveling up staffs. If level is higher than list size the mod will start over.", "If empty default order will be used (" + String.join((CharSequence)", ", DEFAULT_STAFF_SLOTS_ORDER) + ").", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getStaffSlotTypes())}).translation("config.tinkerslevellingaddon.general.slots.staff_slot_type_order").defineList("staffSlotTypeOrder", DEFAULT_STAFF_SLOTS_ORDER, t -> ToolLevellingUtil.getStaffSlotTypes().contains(t));
        builder.pop();
    }

    private static void statsConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Stats settings").push("stats");
        toolsStatTypeRandomPool = builder.comment(new String[]{"Set of stat types from which random stat will be awarded when leveling up tools.", "If empty default pool will be used (" + String.join((CharSequence)", ", DEFAULT_TOOLS_STATS_RANDOM_POOL) + "). 25% chance for every stat.", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getToolStatTypes())}).translation("config.tinkerslevellingaddon.general.stats.tools_stat_type_random_pool").defineList("toolsStatTypeRandomPool", DEFAULT_TOOLS_STATS_RANDOM_POOL, t -> ToolLevellingUtil.getToolStatTypes().contains(t));
        toolsStatTypeOrder = builder.comment(new String[]{"List of stat types (in order) that will be awarded when leveling up tools. If level is higher than list size the mod will start over.", "If empty default order will be used (" + String.join((CharSequence)", ", DEFAULT_TOOLS_STATS_ORDER) + ").", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getToolStatTypes())}).translation("config.tinkerslevellingaddon.general.stats.tools_stat_type_order").defineList("toolsStatTypeOrder", DEFAULT_TOOLS_STATS_ORDER, t -> ToolLevellingUtil.getToolStatTypes().contains(t));
        Config.toolStatsValuesConfig(builder);
        rangedStatTypeRandomPool = builder.comment(new String[]{"Set of stat types from which random stat will be awarded when leveling up ranged weapons.", "If empty default pool will be used (" + String.join((CharSequence)", ", DEFAULT_RANGED_STATS_RANDOM_POOL) + ").", "Possible values: " + String.join((CharSequence)", ", ToolLevellingUtil.getRangedStatTypes())}).translation("config.tinkerslevellingaddon.general.stats.ranged_stat_type_random_pool").defineList("rangedStatTypeRandomPool", DEFAULT_RANGED_STATS_RANDOM_POOL, t -> ToolLevellingUtil.getRangedStatTypes().contains(t));
        rangedStatTypeOrder = builder.comment(new String[]{"List of stat types (in order) that will be awarded when leveling up ranged weapons. If level is higher than list size the mod will start over.", "If empty default rotation will be used (" + String.join((CharSequence)", ", DEFAULT_RANGED_STATS_ORDER) + ").", "Possible values: " + String.join((CharSequence)", ", ToolLevellingUtil.getRangedStatTypes())}).translation("config.tinkerslevellingaddon.general.stats.ranged_stat_type_order").defineList("rangedStatTypeRotation", DEFAULT_RANGED_STATS_ORDER, t -> ToolLevellingUtil.getRangedStatTypes().contains(t));
        Config.rangedStatsValuesConfig(builder);
        armorStatTypeRandomPool = builder.comment(new String[]{"Set of stat types from which random stat will be awarded when leveling up armor.", "If empty default pool will be used (" + String.join((CharSequence)", ", DEFAULT_ARMOR_STATS_RANDOM_POOL) + ").", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getArmorStatTypes())}).translation("config.tinkerslevellingaddon.general.stats.armor_stat_type_random_pool").defineList("armorStatTypeRandomPool", DEFAULT_ARMOR_STATS_RANDOM_POOL, t -> ToolLevellingUtil.getArmorStatTypes().contains(t));
        armorStatTypeOrder = builder.comment(new String[]{"List of stat types (in order) that will be awarded when leveling up armor. If level is higher than list size the mod will start over.", "If empty default order will be used (" + String.join((CharSequence)", ", DEFAULT_ARMOR_STATS_ORDER) + ").", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getArmorStatTypes())}).translation("config.tinkerslevellingaddon.general.stats.armor_stat_type_order").defineList("armorStatTypeOrder", DEFAULT_ARMOR_STATS_ORDER, t -> ToolLevellingUtil.getArmorStatTypes().contains(t));
        Config.armorStatsValuesConfig(builder);
        staffStatTypeRandomPool = builder.comment(new String[]{"Set of stat types from which random stat will be awarded when leveling up staffs.", "If empty default pool will be used (" + String.join((CharSequence)", ", DEFAULT_STAFF_STATS_RANDOM_POOL) + ").", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getStaffStatTypes())}).translation("config.tinkerslevellingaddon.general.stats.staff_stat_type_random_pool").defineList("staffStatTypeRandomPool", DEFAULT_STAFF_STATS_RANDOM_POOL, t -> ToolLevellingUtil.getStaffStatTypes().contains(t));
        staffStatTypeOrder = builder.comment(new String[]{"List of stat types (in order) that will be awarded when leveling up staffs. If level is higher than list size the mod will start over.", "If empty default order will be used (" + String.join((CharSequence)", ", DEFAULT_STAFF_STATS_ORDER) + ").", "Allowed values: " + String.join((CharSequence)", ", ToolLevellingUtil.getStaffStatTypes())}).translation("config.tinkerslevellingaddon.general.stats.staff_stat_type_order").defineList("staffStatTypeOrder", DEFAULT_STAFF_STATS_ORDER, t -> ToolLevellingUtil.getStaffStatTypes().contains(t));
        Config.staffStatsValuesConfig(builder);
        builder.pop();
    }

    private static void toolStatsValuesConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Tool stat values rewarded on level ups").push("toolValues");
        toolDurabilityValue = builder.translation("tooltip.tinkerslevellingaddon.stats.durability").defineInRange("durability", 50, 1, 1000);
        toolAttackDamageValue = builder.translation("tooltip.tinkerslevellingaddon.stats.attack_damage").defineInRange("attackDamage", 0.5, 0.1, 10.0);
        toolAttackSpeedValue = builder.translation("tooltip.tinkerslevellingaddon.stats.attack_speed").defineInRange("attackSpeed", 0.25, 0.1, 10.0);
        toolMiningSpeedValue = builder.translation("tooltip.tinkerslevellingaddon.stats.mining_speed").defineInRange("miningSpeed", 1.0, 0.1, 10.0);
        builder.pop();
    }

    private static void rangedStatsValuesConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Ranged weapons stat values rewarded on level ups").push("rangedValues");
        rangedDurabilityValue = builder.translation("tooltip.tinkerslevellingaddon.stat.durability").defineInRange("durability", 30, 1, 1000);
        rangedDrawSpeedValue = builder.translation("tooltip.tinkerslevellingaddon.stat.draw_speed").defineInRange("drawSpeed", 0.1, 0.1, 10.0);
        rangedVelocityValue = builder.translation("tooltip.tinkerslevellingaddon.stat.velocity").defineInRange("velocity", 0.1, 0.1, 10.0);
        rangedAccuracyValue = builder.translation("tooltip.tinkerslevellingaddon.stat.accuracy").defineInRange("accuracy", 0.01, 0.01, 1.0);
        rangedProjectileDamageValue = builder.translation("tooltip.tinkerslevellingaddon.stat.projectile_damage").defineInRange("projectileDamage", 0.1, 0.1, 10.0);
        rangedAttackDamageValue = builder.translation("tooltip.tinkerslevellingaddon.stat.attack_damage").defineInRange("attackDamage", 0.5, 0.1, 10.0);
        rangedAttackSpeedValue = builder.translation("tooltip.tinkerslevellingaddon.stat.attack_speed").defineInRange("attackSpeed", 0.25, 0.1, 10.0);
        builder.pop();
    }

    private static void armorStatsValuesConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Armor stat values rewarded on level ups").push("armorValues");
        armorDurabilityValue = builder.translation("tooltip.tinkerslevellingaddon.stats.durability").defineInRange("durability", 50, 1, 1000);
        armorArmorValue = builder.translation("tooltip.tinkerslevellingaddon.stats.armor").defineInRange("armor", 0.25, 0.1, 10.0);
        armorArmorToughnessValue = builder.translation("tooltip.tinkerslevellingaddon.stats.armor_toughness").defineInRange("armorToughness", 0.1, 0.1, 10.0);
        armorKnockbackResistanceValue = builder.translation("tooltip.tinkerslevellingaddon.stats.knockback_resistance").defineInRange("knockbackResistance", 0.1, 0.1, 1.0);
        builder.pop();
    }

    private static void staffStatsValuesConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Staff stat values rewarded on level ups").push("staffValues");
        staffDurabilityValue = builder.translation("tooltip.tinkerslevellingaddon.stat.durability").defineInRange("durability", 30, 1, 1000);
        staffDrawSpeedValue = builder.translation("tooltip.tinkerslevellingaddon.stat.draw_speed").defineInRange("drawSpeed", 0.1, 0.1, 10.0);
        staffVelocityValue = builder.translation("tooltip.tinkerslevellingaddon.stat.velocity").defineInRange("velocity", 0.1, 0.1, 10.0);
        staffAccuracyValue = builder.translation("tooltip.tinkerslevellingaddon.stat.accuracy").defineInRange("accuracy", 0.01, 0.01, 1.0);
        staffProjectileDamageValue = builder.translation("tooltip.tinkerslevellingaddon.stat.projectile_damage").defineInRange("projectileDamage", 0.1, 0.1, 10.0);
        staffArmorValue = builder.translation("tooltip.tinkerslevellingaddon.stats.armor").defineInRange("armor", 0.25, 0.1, 10.0);
        builder.pop();
    }

    private static void toolLevellingConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Tool levelling settings").push("toolLevelling");
        damageDealt = builder.comment(new String[]{"Melee only!", "If true, base experience value gained for attacking is equal to damage dealt (rounded to whole number), otherwise 1."}).translation("config.tinkerslevellingaddon.levelling.damage_dealt").define("damageDealt", true);
        damageTaken = builder.comment("If true, base experience value gained for taking damage is equal to damage taken (rounded to whole number), otherwise 1.").translation("config.tinkerslevellingaddon.levelling.damage_taken").define("damageTaken", true);
        damageBlocked = builder.comment("If true, base experience value gained for blocking damage is equal to damage blocked (rounded to whole number), otherwise 1.").translation("config.tinkerslevellingaddon.levelling.damage_blocked").define("damageBlocked", true);
        enablePvp = builder.comment("If true, allows to gain experience from dealing damage to or taking damage from other players.").translation("config.tinkerslevellingaddon.levelling.enable_pvp").define("pvp", true);
        flyingTime = builder.comment(new String[]{"The time (in ticks) of continuous flight using an elytra after which experience points will be awarded.", "20 ticks = 1 second"}).translation("config.tinkerslevellingaddon.levelling.flying_time").defineInRange("flyingTime", 300, 1, 1200);
        Config.actionsConfig(builder);
        Config.bonusesConfig(builder);
        builder.pop();
    }

    private static void actionsConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("If true, given action will yield tool experience.").push("actions");
        enableMiningXp = builder.translation("config.tinkerslevellingaddon.levelling.mining").define("mining", true);
        enableHarvestingXp = builder.translation("config.tinkerslevellingaddon.levelling.harvesting").define("harvesting", true);
        enableShearingXp = builder.translation("config.tinkerslevellingaddon.levelling.shearing").define("shearing", true);
        enableStrippingXp = builder.translation("config.tinkerslevellingaddon.levelling.stripping").define("stripping", true);
        enableScrappingXp = builder.translation("config.tinkerslevellingaddon.levelling.scrapping").define("scrapping", true);
        enableWaxingOffXp = builder.translation("config.tinkerslevellingaddon.levelling.waxing_off").define("waxingOff", true);
        enableTillingXp = builder.translation("config.tinkerslevellingaddon.levelling.tilling").define("tilling", true);
        enablePathMakingXp = builder.translation("config.tinkerslevellingaddon.levelling.path_making").define("pathMaking", true);
        enableAttackingXp = builder.translation("config.tinkerslevellingaddon.levelling.attacking").define("attacking", true);
        enableShootingXp = builder.comment("Applies to ranged weapons like longbows and crossbows.").translation("config.tinkerslevellingaddon.levelling.shooting").define("shooting", true);
        enableTakingDamageXp = builder.comment("Applies to armor only.").translation("config.tinkerslevellingaddon.levelling.taking_damage").define("takingDamage", true);
        enableBlockingDamageXp = builder.translation("config.tinkerslevellingaddon.levelling.blocking_damage").define("blockingDamage", true);
        enableThornsXp = builder.comment("Applies to armor only. Thorns modifier gives 15% chance per level to gain experience.").translation("config.tinkerslevellingaddon.levelling.thorns").define("thorns", true);
        enableFlyingXp = builder.translation("config.tinkerslevellingaddon.levelling.flying").define("flying", true);
        enablePlowingXp = builder.translation("config.tinkerslevellingaddon.levelling.plowing").define("plowing", true);
        enablePathMakerXp = builder.translation("config.tinkerslevellingaddon.levelling.path_maker").define("path_maker", true);
        enableSnowdriftXp = builder.translation("config.tinkerslevellingaddon.levelling.snowdrift").define("snowdrift", true);
        enableFlamewakeXp = builder.translation("config.tinkerslevellingaddon.levelling.flamewake").define("flamewake", true);
        enableFrostWalkerXp = builder.translation("config.tinkerslevellingaddon.levelling.frost_walker").define("frost_walker", true);
        enableWarpingXp = builder.translation("config.tinkerslevellingaddon.levelling.warping").define("warping", true);
        enableFlingingXp = builder.translation("config.tinkerslevellingaddon.levelling.flinging").define("flinging", true);
        enableSpringingXp = builder.translation("config.tinkerslevellingaddon.levelling.springing").define("springing", true);
        enableBonkingXp = builder.translation("config.tinkerslevellingaddon.levelling.bonking").define("bonking", true);
        enableGlowingXp = builder.translation("config.tinkerslevellingaddon.levelling.glowing").define("glowing", true);
        enableFirestarterXp = builder.translation("config.tinkerslevellingaddon.levelling.firestarter").define("firestarter", true);
        builder.pop();
    }

    private static void bonusesConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Amount of bonus experience for performing actions. If set to 0 there is no bonus experience.").push("bonuses");
        bonusMiningXp = builder.translation("config.tinkerslevellingaddon.levelling.mining").defineInRange("mining", 0, 0, Integer.MAX_VALUE);
        bonusHarvestingXp = builder.translation("config.tinkerslevellingaddon.levelling.harvesting").defineInRange("harvesting", 0, 0, Integer.MAX_VALUE);
        bonusShearingXp = builder.translation("config.tinkerslevellingaddon.levelling.shearing").defineInRange("shearing", 0, 0, Integer.MAX_VALUE);
        bonusStrippingXp = builder.translation("config.tinkerslevellingaddon.levelling.stripping").defineInRange("stripping", 0, 0, Integer.MAX_VALUE);
        bonusScrappingXp = builder.translation("config.tinkerslevellingaddon.levelling.scrapping").defineInRange("scrapping", 0, 0, Integer.MAX_VALUE);
        bonusWaxingOffXp = builder.translation("config.tinkerslevellingaddon.levelling.waxing_off").defineInRange("waxingOff", 0, 0, Integer.MAX_VALUE);
        bonusTillingXp = builder.translation("config.tinkerslevellingaddon.levelling.tilling").defineInRange("tilling", 0, 0, Integer.MAX_VALUE);
        bonusPathMakingXp = builder.translation("config.tinkerslevellingaddon.levelling.path_making").defineInRange("pathMaking", 0, 0, Integer.MAX_VALUE);
        bonusAttackingXp = builder.translation("config.tinkerslevellingaddon.levelling.attacking").defineInRange("attacking", 0, 0, Integer.MAX_VALUE);
        bonusShootingXp = builder.translation("config.tinkerslevellingaddon.levelling.shooting").defineInRange("shooting", 0, 0, Integer.MAX_VALUE);
        bonusTakingDamageXp = builder.translation("config.tinkerslevellingaddon.levelling.taking_damage").defineInRange("takingDamage", 0, 0, Integer.MAX_VALUE);
        bonusBlockingDamageXp = builder.translation("config.tinkerslevellingaddon.levelling.blocking_damage").defineInRange("blockingDamage", 0, 0, Integer.MAX_VALUE);
        bonusThornsXp = builder.comment(new String[]{"As with Thorns damage calculations, this is the upper bound of the bonus experience that could be granted.", "For example, for the value of 3 (default), we get: 1 (base xp) + 0 to 3 (bonus xp) = 1 to 4 (result xp)"}).translation("config.tinkerslevellingaddon.levelling.thorns").defineInRange("thorns", 3, 0, Integer.MAX_VALUE);
        bonusFlyingXp = builder.translation("config.tinkerslevellingaddon.levelling.flying").defineInRange("flying", 0, 0, Integer.MAX_VALUE);
        bonusPlowingXp = builder.translation("config.tinkerslevellingaddon.levelling.plowing").defineInRange("plowing", 0, 0, Integer.MAX_VALUE);
        bonusPathMakerXp = builder.translation("config.tinkerslevellingaddon.levelling.path_maker").defineInRange("path_maker", 0, 0, Integer.MAX_VALUE);
        bonusSnowdriftXp = builder.translation("config.tinkerslevellingaddon.levelling.snowdrift").defineInRange("snowdrift", 0, 0, Integer.MAX_VALUE);
        bonusFlamewakeXp = builder.translation("config.tinkerslevellingaddon.levelling.flamewake").defineInRange("flamewake", 0, 0, Integer.MAX_VALUE);
        bonusFrostWalkerXp = builder.translation("config.tinkerslevellingaddon.levelling.frost_walker").defineInRange("frost_walker", 0, 0, Integer.MAX_VALUE);
        bonusWarpingXp = builder.translation("config.tinkerslevellingaddon.levelling.warping").defineInRange("warping", 0, 0, Integer.MAX_VALUE);
        bonusFlingingXp = builder.translation("config.tinkerslevellingaddon.levelling.flinging").defineInRange("flinging", 0, 0, Integer.MAX_VALUE);
        bonusSpringingXp = builder.translation("config.tinkerslevellingaddon.levelling.springing").defineInRange("springing", 0, 0, Integer.MAX_VALUE);
        bonusBonkingXp = builder.translation("config.tinkerslevellingaddon.levelling.bonking").defineInRange("bonking", 0, 0, Integer.MAX_VALUE);
        bonusGlowingXp = builder.translation("config.tinkerslevellingaddon.levelling.glowing").defineInRange("glowing", 0, 0, Integer.MAX_VALUE);
        bonusFirestarterXp = builder.translation("config.tinkerslevellingaddon.levelling.firestarter").defineInRange("firestarter", 0, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    private static void clientConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Client only settings").push("client");
        enableLevelUpMessage = builder.comment("If true, shows chat message on tool level ups.").translation("config.tinkerslevellingaddon.client.messages").define("message", true);
        squashLevelPluses = builder.comment(new String[]{"If true, uses alternative level name suffix for high level tools.", "Instead of appending '+' signs for each consecutive level appearance, +1, +2, +3, etc. notation will be used."}).translation("config.tinkerslevellingaddon.client.squash_pluses").define("squashPluses", false);
        levelUpSound = builder.comment("").translation("config.tinkerslevellingaddon.client.sound").defineEnum("sound", (Enum)LevelUpSound.SNARE_DRUM, EnumGetMethod.NAME_IGNORECASE, (Enum[])LevelUpSound.values());
    }

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_CONFIG);
    }

    public static List<String> getToolsSlotsOrder() {
        List<String> slotsOrder = (List<String>)toolsSlotTypeOrder.get();
        if (slotsOrder.isEmpty()) {
            slotsOrder = DEFAULT_TOOLS_SLOTS_ORDER;
        }
        return slotsOrder;
    }

    public static List<String> getToolsSlotsRandomPool() {
        List<String> slotsRandomPool = (List<String>)toolsSlotTypeRandomPool.get();
        if (slotsRandomPool.isEmpty()) {
            slotsRandomPool = DEFAULT_TOOLS_SLOTS_RANDOM_POOL;
        }
        return slotsRandomPool;
    }

    public static List<String> getToolsStatsOrder() {
        List<String> statsOrder = (List<String>)toolsStatTypeOrder.get();
        if (statsOrder.isEmpty()) {
            statsOrder = DEFAULT_TOOLS_STATS_ORDER;
        }
        return statsOrder;
    }

    public static List<String> getToolsStatsRandomPool() {
        List<String> statsRandomPool = (List<String>)toolsStatTypeRandomPool.get();
        if (statsRandomPool.isEmpty()) {
            statsRandomPool = DEFAULT_TOOLS_STATS_RANDOM_POOL;
        }
        return statsRandomPool;
    }

    public static List<String> getArmorSlotsOrder() {
        List<String> slotsOrder = (List<String>)armorSlotTypeOrder.get();
        if (slotsOrder.isEmpty()) {
            slotsOrder = DEFAULT_ARMOR_SLOTS_ORDER;
        }
        return slotsOrder;
    }

    public static List<String> getArmorSlotsRandomPool() {
        List<String> slotsRandomPool = (List<String>)armorSlotTypeRandomPool.get();
        if (slotsRandomPool.isEmpty()) {
            slotsRandomPool = DEFAULT_ARMOR_SLOTS_RANDOM_POOL;
        }
        return slotsRandomPool;
    }

    public static List<String> getArmorStatsOrder() {
        List<String> statsOrder = (List<String>)armorStatTypeOrder.get();
        if (statsOrder.isEmpty()) {
            statsOrder = DEFAULT_ARMOR_STATS_ORDER;
        }
        return statsOrder;
    }

    public static List<String> getArmorStatsRandomPool() {
        List<String> statsRandomPool = (List<String>)armorStatTypeRandomPool.get();
        if (statsRandomPool.isEmpty()) {
            statsRandomPool = DEFAULT_ARMOR_STATS_RANDOM_POOL;
        }
        return statsRandomPool;
    }

    public static List<String> getRangedSlotsOrder() {
        List<String> slotsOrder = (List<String>)rangedSlotTypeOrder.get();
        if (slotsOrder.isEmpty()) {
            slotsOrder = DEFAULT_RANGED_SLOTS_ORDER;
        }
        return slotsOrder;
    }

    public static List<String> getRangedSlotsRandomPool() {
        List<String> slotsRandomPool = (List<String>)rangedSlotTypeRandomPool.get();
        if (slotsRandomPool.isEmpty()) {
            slotsRandomPool = DEFAULT_RANGED_SLOTS_RANDOM_POOL;
        }
        return slotsRandomPool;
    }

    public static List<String> getRangedStatsOrder() {
        List<String> statsOrder = (List<String>)rangedStatTypeOrder.get();
        if (statsOrder.isEmpty()) {
            statsOrder = DEFAULT_RANGED_STATS_ORDER;
        }
        return statsOrder;
    }

    public static List<String> getRangedStatsRandomPool() {
        List<String> statsRandomPool = (List<String>)rangedStatTypeRandomPool.get();
        if (statsRandomPool.isEmpty()) {
            statsRandomPool = DEFAULT_RANGED_STATS_RANDOM_POOL;
        }
        return statsRandomPool;
    }

    public static List<String> getStaffSlotsOrder() {
        List<String> slotsOrder = (List<String>)staffSlotTypeOrder.get();
        if (slotsOrder.isEmpty()) {
            slotsOrder = DEFAULT_STAFF_SLOTS_ORDER;
        }
        return slotsOrder;
    }

    public static List<String> getStaffSlotsRandomPool() {
        List<String> slotsRandomPool = (List<String>)staffSlotTypeRandomPool.get();
        if (slotsRandomPool.isEmpty()) {
            slotsRandomPool = DEFAULT_STAFF_SLOTS_RANDOM_POOL;
        }
        return slotsRandomPool;
    }

    public static List<String> getStaffStatsOrder() {
        List<String> statsOrder = (List<String>)staffStatTypeOrder.get();
        if (statsOrder.isEmpty()) {
            statsOrder = DEFAULT_STAFF_STATS_ORDER;
        }
        return statsOrder;
    }

    public static List<String> getStaffStatsRandomPool() {
        List<String> statsRandomPool = (List<String>)staffStatTypeRandomPool.get();
        if (statsRandomPool.isEmpty()) {
            statsRandomPool = DEFAULT_STAFF_STATS_RANDOM_POOL;
        }
        return statsRandomPool;
    }

    public static double getToolStatValue(FloatToolStat stat) {
        if (stat.equals(ToolStats.DURABILITY)) {
            return ((Integer)toolDurabilityValue.get()).intValue();
        }
        if (stat.equals(ToolStats.ATTACK_DAMAGE)) {
            return (Double)toolAttackDamageValue.get();
        }
        if (stat.equals(ToolStats.ATTACK_SPEED)) {
            return (Double)toolAttackSpeedValue.get();
        }
        if (stat.equals(ToolStats.MINING_SPEED)) {
            return (Double)toolMiningSpeedValue.get();
        }
        return 0.0;
    }

    public static double getRangedStatValue(FloatToolStat stat) {
        if (stat.equals(ToolStats.DRAW_SPEED)) {
            return (Double)rangedDrawSpeedValue.get();
        }
        if (stat.equals(ToolStats.VELOCITY)) {
            return (Double)rangedVelocityValue.get();
        }
        if (stat.equals(ToolStats.ACCURACY)) {
            return (Double)rangedAccuracyValue.get();
        }
        if (stat.equals(ToolStats.PROJECTILE_DAMAGE)) {
            return (Double)rangedProjectileDamageValue.get();
        }
        if (stat.equals(ToolStats.DURABILITY)) {
            return ((Integer)rangedDurabilityValue.get()).intValue();
        }
        if (stat.equals(ToolStats.ATTACK_DAMAGE)) {
            return (Double)rangedAttackDamageValue.get();
        }
        if (stat.equals(ToolStats.ATTACK_SPEED)) {
            return (Double)rangedAttackSpeedValue.get();
        }
        return 0.0;
    }

    public static double getArmorStatValue(FloatToolStat stat) {
        if (stat.equals(ToolStats.DURABILITY)) {
            return ((Integer)armorDurabilityValue.get()).intValue();
        }
        if (stat.equals(ToolStats.ARMOR)) {
            return (Double)armorArmorValue.get();
        }
        if (stat.equals(ToolStats.ARMOR_TOUGHNESS)) {
            return (Double)armorArmorToughnessValue.get();
        }
        if (stat.equals(ToolStats.KNOCKBACK_RESISTANCE)) {
            return (Double)armorKnockbackResistanceValue.get();
        }
        return 0.0;
    }

    public static double getStaffStatValue(FloatToolStat stat) {
        if (stat.equals(ToolStats.DRAW_SPEED)) {
            return (Double)staffDrawSpeedValue.get();
        }
        if (stat.equals(ToolStats.VELOCITY)) {
            return (Double)staffVelocityValue.get();
        }
        if (stat.equals(ToolStats.ACCURACY)) {
            return (Double)staffAccuracyValue.get();
        }
        if (stat.equals(ToolStats.PROJECTILE_DAMAGE)) {
            return (Double)staffProjectileDamageValue.get();
        }
        if (stat.equals(ToolStats.DURABILITY)) {
            return ((Integer)staffDurabilityValue.get()).intValue();
        }
        if (stat.equals(ToolStats.ARMOR)) {
            return (Double)staffArmorValue.get();
        }
        return 0.0;
    }

    static {
        ForgeConfigSpec.Builder serverConfigBuilder = new ForgeConfigSpec.Builder();
        Config.generalConfig(serverConfigBuilder);
        Config.toolLevellingConfig(serverConfigBuilder);
        SERVER_CONFIG = serverConfigBuilder.build();
        ForgeConfigSpec.Builder clientConfigBuilder = new ForgeConfigSpec.Builder();
        Config.clientConfig(clientConfigBuilder);
        CLIENT_CONFIG = clientConfigBuilder.build();
    }

    public static enum GainingMethod {
        NONE,
        PREDEFINED_ORDER,
        RANDOM;

    }

    public static enum LevelUpSound {
        NONE(null),
        CHIME(pyre.tinkerslevellingaddon.setup.Sounds.CHIME.getSound()),
        SNARE_DRUM(pyre.tinkerslevellingaddon.setup.Sounds.SNARE_DRUM.getSound()),
        YAY(pyre.tinkerslevellingaddon.setup.Sounds.YAY.getSound()),
        BONK(Sounds.BONK.getSound());

        private final SoundEvent soundEvent;

        private LevelUpSound(SoundEvent soundEvent) {
            this.soundEvent = soundEvent;
        }

        public SoundEvent getSoundEvent() {
            return this.soundEvent;
        }
    }
}

