/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client;

import com.blackgear.platform.client.forge.GameRenderingImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GameRendering {
    public static final Map<Item, ModelResourceLocation> HAND_HELD_MODELS = new ConcurrentHashMap<Item, ModelResourceLocation>();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockColors(Consumer<BlockColorEvent> listener) {
        GameRenderingImpl.registerBlockColors(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockRenderers(Consumer<BlockRendererEvent> listener) {
        GameRenderingImpl.registerBlockRenderers(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerEntityRenderers(Consumer<EntityRendererEvent> listener) {
        GameRenderingImpl.registerEntityRenderers(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockEntityRenderers(Consumer<BlockEntityRendererEvent> listener) {
        GameRenderingImpl.registerBlockEntityRenderers(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerModelLayers(Consumer<ModelLayerEvent> listener) {
        GameRenderingImpl.registerModelLayers(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerSpecialModels(Consumer<SpecialModelEvent> listener) {
        GameRenderingImpl.registerSpecialModels(listener);
    }

    public static void registerHandHeldModels(Consumer<HandHeldModelEvent> listener) {
        HandHeldModelEvent event = (item, model) -> {
            HAND_HELD_MODELS.put(item, model);
            GameRendering.registerSpecialModels(models -> models.register((ResourceLocation)model));
        };
        listener.accept(event);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerSkullRenderers(Consumer<SkullRendererEvent> listener) {
        GameRenderingImpl.registerSkullRenderers(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerParticleFactories(Consumer<ParticleFactoryEvent> listener) {
        GameRenderingImpl.registerParticleFactories(listener);
    }

    public static interface HandHeldModelEvent {
        public void register(Item var1, ModelResourceLocation var2);
    }

    public static interface SpecialModelEvent {
        public void register(ResourceLocation var1);

        public void register(ResourceLocation ... var1);
    }

    public static interface ParticleFactoryEvent {
        public <T extends ParticleOptions, P extends ParticleType<T>> void register(Supplier<P> var1, ParticleProvider<T> var2);

        public <T extends ParticleOptions, P extends ParticleType<T>> void register(Supplier<P> var1, Factory<T> var2);

        @FunctionalInterface
        public static interface Factory<T extends ParticleOptions> {
            @NotNull
            public ParticleProvider<T> create(SpriteSet var1);
        }
    }

    public static interface SkullRendererEvent {
        public void registerSkullModel(SkullBlock.Type var1, Function<ModelPart, SkullModelBase> var2, ModelLayerLocation var3);

        public void registerSkullTexture(SkullBlock.Type var1, ResourceLocation var2);
    }

    public static interface ModelLayerEvent {
        public void register(ModelLayerLocation var1, Supplier<LayerDefinition> var2);
    }

    public static interface BlockEntityRendererEvent {
        public <E extends BlockEntity> void register(BlockEntityType<? extends E> var1, BlockEntityRendererProvider<E> var2);
    }

    public static interface EntityRendererEvent {
        public <E extends Entity> void register(EntityType<? extends E> var1, EntityRendererProvider<E> var2);
    }

    public static interface BlockRendererEvent {
        public void register(RenderType var1, Block ... var2);

        public void register(RenderType var1, Fluid ... var2);
    }

    public static interface BlockColorEvent {
        public void register(ItemColor var1, ItemLike ... var2);

        public void register(BlockColor var1, Block ... var2);
    }
}

