/*
 * Decompiled with CFR 0.152.
 */
package com.landscapesreimagined.ddtocreate6.util;

import com.simibubi.create.api.stress.BlockStressValues;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.createmod.catnip.data.Couple;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class RegistrateUtil {
    public static final Map<ResourceLocation, Double> capacities = new HashMap<ResourceLocation, Double>();
    public static final Map<ResourceLocation, Double> impacts = new HashMap<ResourceLocation, Double>();
    public static final Map<ResourceLocation, BlockStressValues.GeneratedRpm> GENERATOR_SPEEDS = new HashMap<ResourceLocation, BlockStressValues.GeneratedRpm>();

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setImpact(double impact) {
        return builder -> {
            ResourceLocation loc = ResourceLocation.m_135820_((String)(builder.getOwner().getModid() + ":" + builder.getName()));
            impacts.put(loc, impact);
            return builder;
        };
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setNoImpact() {
        return builder -> {
            ResourceLocation loc = ResourceLocation.m_135820_((String)(builder.getOwner().getModid() + ":" + builder.getName()));
            impacts.put(loc, 0.0);
            return builder;
        };
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setCapacity(double capacity) {
        return builder -> {
            ResourceLocation loc = ResourceLocation.m_135820_((String)(builder.getOwner().getModid() + ":" + builder.getName()));
            capacities.put(loc, capacity);
            return builder;
        };
    }

    public static NonNullConsumer<Block> setGeneratorSpeed(Supplier<Couple<Integer>> generatorRPM, boolean mayGenerateLess) {
        return block -> BlockStressValues.RPM.register(block, (Object)new BlockStressValues.GeneratedRpm(((Integer)((Couple)generatorRPM.get()).getSecond()).intValue(), mayGenerateLess));
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setGeneratorSpeed(Supplier<Couple<Integer>> generatorRPM) {
        return builder -> {
            ResourceLocation loc = ResourceLocation.m_135820_((String)(builder.getOwner().getModid() + ":" + builder.getName()));
            BlockStressValues.GeneratedRpm stress = new BlockStressValues.GeneratedRpm(((Integer)((Couple)generatorRPM.get()).getSecond()).intValue(), true);
            GENERATOR_SPEEDS.put(loc, stress);
            return builder;
        };
    }

    public static <T, B> Supplier<T> getIfIs(B instance, T toGet, Predicate<B> is) {
        return () -> is.test(instance) ? toGet : null;
    }
}

