/*
 * Decompiled with CFR 0.152.
 */
package com.landscapesreimagined.ddtocreate6.replaced.actorInstances;

import com.google.common.collect.Lists;
import com.landscapesreimagined.ddtocreate6.replaced.BlockEntities.FlywheelBlockEntity;
import com.landscapesreimagined.ddtocreate6.replaced.ReplacedDDBlockPartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.AbstractInstance;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import uwu.lopyluna.create_dd.block.BlockProperties.flywheel.FlywheelBlock;

public class FlywheelVisual
extends KineticBlockEntityVisual<FlywheelBlockEntity>
implements SimpleDynamicVisual {
    protected final Direction facing;
    protected final Direction connection;
    protected boolean connectedLeft;
    protected float connectorAngleMult;
    protected final RotatingInstance shaft;
    protected final TransformedInstance wheel;
    protected TransformedInstance upperRotating;
    protected TransformedInstance lowerRotating;
    protected TransformedInstance upperSliding;
    protected TransformedInstance lowerSliding;
    protected List<TransformedInstance> connectors;
    protected float lastAngle = Float.NaN;
    protected final Matrix4f baseTransform = new Matrix4f();

    public FlywheelVisual(VisualizationContext context, FlywheelBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        this.facing = (Direction)this.blockState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        Direction from = this.facing.m_122434_() == Direction.Axis.X ? Direction.SOUTH : Direction.NORTH;
        this.shaft = ((RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF)).createInstance()).setup((KineticBlockEntity)blockEntity).rotateToFace(Direction.SOUTH, this.facing.m_122424_()).setPosition((Vec3i)this.getVisualPosition());
        BlockState referenceState = this.blockState.m_60717_(Rotation.CLOCKWISE_90);
        Direction facing1 = (Direction)referenceState.m_61143_((Property)BlockStateProperties.f_61374_);
        this.wheel = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)ReplacedDDBlockPartialModel.FLYWHEEL)).createInstance();
        Direction align = this.facing;
        ((TransformedInstance)((TransformedInstance)this.wheel.translate((Vec3i)this.getVisualPosition())).center()).rotate((Quaternionfc)new Quaternionf().rotateTo(1.0f, 0.0f, 0.0f, (float)align.m_122429_(), (float)align.m_122430_(), (float)align.m_122431_()));
        this.baseTransform.set((Matrix4fc)this.wheel.pose);
        this.connection = FlywheelBlock.getConnection((BlockState)this.blockState);
        if (this.connection == null) {
            this.connectors = Collections.emptyList();
            this.animate(blockEntity.angle);
            return;
        }
        this.connectedLeft = this.blockState.m_61143_((Property)FlywheelBlock.CONNECTION) == FlywheelBlock.ConnectionState.LEFT;
        boolean flipAngle = this.connection.m_122434_() == Direction.Axis.X ^ this.connection.m_122421_() == Direction.AxisDirection.NEGATIVE;
        this.connectorAngleMult = flipAngle ? -1.0f : 1.0f;
        this.upperRotating = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)ReplacedDDBlockPartialModel.FLYWHEEL_UPPER_ROTATING)).createInstance();
        this.lowerRotating = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)ReplacedDDBlockPartialModel.FLYWHEEL_LOWER_ROTATING)).createInstance();
        this.upperSliding = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)ReplacedDDBlockPartialModel.FLYWHEEL_UPPER_SLIDING)).createInstance();
        this.lowerSliding = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)ReplacedDDBlockPartialModel.FLYWHEEL_LOWER_SLIDING)).createInstance();
        this.connectors = Lists.newArrayList((Object[])new TransformedInstance[]{this.upperRotating, this.lowerRotating, this.upperSliding, this.lowerSliding});
        this.animate(blockEntity.angle);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        float partialTicks = ctx.partialTick();
        float speed = ((FlywheelBlockEntity)this.blockEntity).visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = ((FlywheelBlockEntity)this.blockEntity).angle + speed * partialTicks;
        if ((double)Math.abs(angle - this.lastAngle) < 0.001) {
            return;
        }
        this.animate(angle);
        this.lastAngle = angle;
    }

    private void animate(float angle) {
        ((TransformedInstance)this.wheel.setTransform((Matrix4fc)this.baseTransform).rotateX(AngleHelper.rad((double)angle)).uncenter()).setChanged();
        PoseStack ms = new PoseStack();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        msr.translate((Vec3i)this.getVisualPosition());
        if (this.connection != null) {
            float rotation = angle * this.connectorAngleMult;
            ms.m_85836_();
            this.rotateToFacing((TransformStack<?>)msr, this.connection);
            ms.m_85836_();
            this.transformConnector((TransformStack<?>)msr, true, true, rotation, this.connectedLeft);
            this.upperRotating.setTransform(ms);
            ms.m_85849_();
            ms.m_85836_();
            this.transformConnector((TransformStack<?>)msr, false, true, rotation, this.connectedLeft);
            this.lowerRotating.setTransform(ms);
            ms.m_85849_();
            ms.m_85836_();
            this.transformConnector((TransformStack<?>)msr, true, false, rotation, this.connectedLeft);
            this.upperSliding.setTransform(ms);
            ms.m_85849_();
            ms.m_85836_();
            this.transformConnector((TransformStack<?>)msr, false, false, rotation, this.connectedLeft);
            this.lowerSliding.setTransform(ms);
            ms.m_85849_();
            ms.m_85849_();
            this.connectors.forEach(AbstractInstance::setChanged);
        }
        this.lastAngle = angle;
    }

    protected void transformConnector(TransformStack<?> ms, boolean upper, boolean rotating, float angle, boolean flip) {
        float shift = upper ? 0.25f : -0.125f;
        float offset = upper ? 0.25f : 0.25f;
        float radians = (float)((double)(angle / 180.0f) * Math.PI);
        float shifting = Mth.m_14031_((float)radians) * shift + offset;
        float maxAngle = upper ? -5.0f : -15.0f;
        float minAngle = upper ? -45.0f : 5.0f;
        float barAngle = 0.0f;
        if (rotating) {
            barAngle = Mth.m_14179_((float)((Mth.m_14031_((float)((float)((double)radians + 1.5707963267948966))) + 1.0f) / 2.0f), (float)minAngle, (float)maxAngle);
        }
        float pivotX = (upper ? 8.0f : 3.0f) / 16.0f;
        float pivotY = (upper ? 8.0f : 2.0f) / 16.0f;
        float pivotZ = (upper ? 23.0f : 21.5f) / 16.0f;
        ms.translate(pivotX, pivotY, pivotZ + shifting);
        if (rotating) {
            ms.rotate(AngleHelper.rad((double)barAngle), Direction.EAST);
        }
        ms.translate(-pivotX, -pivotY, -pivotZ);
        if (flip && !upper) {
            ms.translate(0.5625f, 0.0f, 0.0f);
        }
    }

    protected void rotateToFacing(TransformStack<?> buffer, Direction facing) {
        ((TransformStack)((TransformStack)buffer.center()).rotate(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing)), Direction.UP)).uncenter();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.shaft);
        consumer.accept((Instance)this.wheel);
        if (this.connection != null) {
            consumer.accept((Instance)this.upperRotating);
            consumer.accept((Instance)this.upperSliding);
            consumer.accept((Instance)this.lowerRotating);
            consumer.accept((Instance)this.lowerSliding);
        }
    }

    public void update(float partialTick) {
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.shaft, this.wheel});
        if (this.connection != null) {
            this.relight(new FlatLit[]{this.lowerRotating, this.upperRotating, this.lowerSliding, this.upperSliding});
        }
    }

    protected void _delete() {
        this.wheel.delete();
        this.shaft.delete();
        this.connectors.forEach(AbstractInstance::delete);
        this.connectors.clear();
    }
}

