/*
 * Decompiled with CFR 0.152.
 */
package com.landscapesreimagined.ddtocreate6.replaced;

import com.landscapesreimagined.ddtocreate6.util.RegistrateUtil;
import com.simibubi.create.api.stress.BlockStressValues;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import net.createmod.catnip.platform.ForgeRegisteredObjectsHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import uwu.lopyluna.create_dd.configs.DDConfigBase;

public class DDStress
extends DDConfigBase {
    private final ForgeRegisteredObjectsHelper objectsHelper = new ForgeRegisteredObjectsHelper();
    private final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> capacities = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();
    private final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> impacts = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();

    public void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(new String[]{".", Comments.su, Comments.impact}).push("impact");
        RegistrateUtil.impacts.forEach((r, i) -> {
            if (r.m_135827_().equals("create_dd")) {
                this.getImpacts().put((ResourceLocation)r, (ForgeConfigSpec.ConfigValue<Double>)builder.define(r.m_135815_(), i));
            }
        });
        builder.pop();
        builder.comment(new String[]{".", Comments.su, Comments.capacity}).push("capacity");
        RegistrateUtil.capacities.forEach((r, i) -> {
            if (r.m_135827_().equals("create_dd")) {
                this.getCapacities().put((ResourceLocation)r, (ForgeConfigSpec.ConfigValue<Double>)builder.define(r.m_135815_(), i));
            }
        });
        builder.pop();
    }

    public double getImpact(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = this.objectsHelper.getKeyOrThrow(block);
        ForgeConfigSpec.ConfigValue<Double> value = this.getImpacts().get(key);
        return value != null ? (Double)value.get() : 0.0;
    }

    public DoubleSupplier getImpactSupplier(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = this.objectsHelper.getKeyOrThrow(block);
        ForgeConfigSpec.ConfigValue<Double> value = this.getImpacts().get(key);
        return value != null ? () -> value.get() : null;
    }

    public double getCapacity(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = this.objectsHelper.getKeyOrThrow(block);
        ForgeConfigSpec.ConfigValue<Double> value = this.getCapacities().get(key);
        return value != null ? (Double)value.get() : 0.0;
    }

    public DoubleSupplier getCapacitySupplier(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = this.objectsHelper.getKeyOrThrow(block);
        ForgeConfigSpec.ConfigValue<Double> value = this.getCapacities().get(key);
        return value != null ? () -> value.get() : null;
    }

    public BlockStressValues.GeneratedRpm getGeneratedRPM(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = this.objectsHelper.getKeyOrThrow(block);
        return RegistrateUtil.GENERATOR_SPEEDS.get(key);
    }

    public boolean hasImpact(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = this.objectsHelper.getKeyOrThrow(block);
        return this.getImpacts().containsKey(key);
    }

    public boolean hasCapacity(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = this.objectsHelper.getKeyOrThrow(block);
        return this.getCapacities().containsKey(key);
    }

    protected Block redirectValues(Block block) {
        return block;
    }

    public String getName() {
        return "stressValues.v2";
    }

    public Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> getImpacts() {
        return this.impacts;
    }

    public Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> getCapacities() {
        return this.capacities;
    }

    private static class Comments {
        static String su = "[in Stress Units]";
        static String impact = "Configure the individual stress impact of mechanical blocks. Note that this cost is doubled for every speed increase it receives.";
        static String capacity = "Configure how much stress a source can accommodate for.";

        private Comments() {
        }
    }
}

