/*
 * Decompiled with CFR 0.152.
 */
package com.landscapesreimagined.ddtocreate6.replaced.BlockEntities;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.potatoCannon.PotatoProjectileEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import uwu.lopyluna.create_dd.DDCreate;

public class PotatoTurretBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    public Vec3 targetVec;
    public double targetAngleY;
    public double targetAngleX;
    public LerpedFloat angleY = LerpedFloat.angular();
    public LerpedFloat angleX = LerpedFloat.angular();
    public LivingEntity targetedEntity;
    public int timer = 0;
    public int fireRate = 5;
    public double distance = 0.0;
    public ServerPlayer owner;
    public SmartInventory inventory = new SmartInventory(1, (SyncedBlockEntity)this).withMaxStackSize(1).forbidExtraction().forbidInsertion();
    public float amogus = 50.0f;
    public float visualAngleY = 0.0f;
    public float visualAngleX = 0.0f;
    public static final int RANGE = 4;

    public PotatoTurretBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void tick() {
        super.tick();
        this.targetAngleY %= 360.0;
        this.amogus %= 360.0f;
        this.angleX.chase((double)this.visualAngleX, (double)0.3f, LerpedFloat.Chaser.EXP);
        this.angleX.tickChaser();
        this.angleY.chase((double)(this.visualAngleY + 180.0f), (double)0.3f, LerpedFloat.Chaser.EXP);
        this.angleY.tickChaser();
        this.visualAngleY = (float)this.targetAngleY;
        this.visualAngleX = (float)this.targetAngleX;
        for (LivingEntity livingEntity : this.f_58857_.m_45976_(LivingEntity.class, this.rangeZone())) {
            if (livingEntity.m_21224_() || livingEntity instanceof ServerPlayer && (((ServerPlayer)livingEntity).m_7500_() || ((ServerPlayer)livingEntity).m_5833_())) continue;
            double checkedDistance = this.getDistance(livingEntity);
            if (this.distance >= 4.0 || this.distance != 0.0 && !(this.distance >= checkedDistance)) continue;
            this.distance = checkedDistance;
            this.targetedEntity = livingEntity;
        }
        ++this.timer;
        if (this.targetedEntity != null) {
            this.setTargetAngles();
            if (this.timer >= this.fireRate) {
                this.shoot();
            }
            if (this.targetedEntity.m_213877_()) {
                this.targetedEntity = null;
            }
        }
    }

    public void setTargetAngles() {
        double distanceX = this.targetedEntity.m_146903_() - this.m_58899_().m_123341_();
        double distanceY = this.targetedEntity.m_146904_() - this.m_58899_().m_123342_();
        double distanceZ = this.targetedEntity.m_146907_() - this.m_58899_().m_123343_();
        double distanceHorizontal = Math.sqrt(distanceZ * distanceZ + distanceX * distanceX);
        DDCreate.LOGGER.debug("distance X  " + distanceX);
        DDCreate.LOGGER.debug("distance Z  " + distanceZ);
        this.targetAngleX = Math.toDegrees(Math.atan(distanceY / distanceHorizontal));
        this.targetAngleY = Math.toDegrees(Math.atan(distanceX / distanceZ));
        if (distanceZ < 0.0) {
            this.targetAngleY += 180.0;
        }
    }

    public void shoot() {
        this.timer = 0;
        this.targetVec = Vec3.m_82498_((float)(-((float)this.targetAngleX)), (float)((float)(-this.targetAngleY)));
        this.amogus = (float)this.targetAngleY;
        DDCreate.LOGGER.debug("ANGLE:  " + this.targetAngleY);
        this.targetVec = this.targetVec.m_82490_(4.0);
        if (this.distance >= 4.0) {
            this.targetVec = this.targetVec.m_82542_(1.0, -1.6, 1.0);
        }
        if (!this.f_58857_.m_5776_()) {
            PotatoProjectileEntity projectile = (PotatoProjectileEntity)AllEntityTypes.POTATO_PROJECTILE.create(this.f_58857_);
            projectile.setItem(Items.f_42620_.m_7968_());
            projectile.m_6034_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.5, (double)this.m_58899_().m_123343_() + 0.5);
            projectile.m_20256_(this.targetVec);
            this.f_58857_.m_7967_((Entity)projectile);
        }
    }

    public double getDistance(LivingEntity livingEntity) {
        double x = Math.abs(livingEntity.m_146903_() - this.m_58899_().m_123341_());
        double y = Math.abs(livingEntity.m_146904_() - this.m_58899_().m_123342_());
        double z = Math.abs(livingEntity.m_146907_() - this.m_58899_().m_123343_());
        return Math.sqrt(x * x + y * y + z * z);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        MutableComponent goggleComp = Component.m_237110_((String)"create.recipe.assembly.step", (Object[])new Object[]{this.targetAngleY}).m_130940_(ChatFormatting.LIGHT_PURPLE);
        tooltip.add((Component)goggleComp);
        return true;
    }

    public AABB rangeZone() {
        return new AABB((double)(this.m_58899_().m_123341_() - 4), (double)(this.m_58899_().m_123342_() - 4), (double)(this.m_58899_().m_123343_() - 4), (double)(this.m_58899_().m_123341_() + 4), (double)(this.m_58899_().m_123342_() + 4), (double)(this.m_58899_().m_123343_() + 4));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.m_128469_("InputItems"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("InputItems", (Tag)this.inventory.serializeNBT());
    }
}

