/*
 * Decompiled with CFR 0.152.
 */
package com.landscapesreimagined.ddtocreate6.replaced.BlockEntities;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import uwu.lopyluna.create_dd.block.BlockProperties.flywheel.FlywheelBlock;

public class FlywheelBlockEntity
extends GeneratingKineticBlockEntity {
    private float generatedCapacity;
    private float generatedSpeed;
    private int stoppingCooldown;
    public LerpedFloat visualSpeed = LerpedFloat.linear();
    public float angle;

    public FlywheelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setRotation(float speed, float capacity) {
        if (this.generatedSpeed != speed || this.generatedCapacity != capacity) {
            if (speed == 0.0f) {
                if (this.stoppingCooldown == 0) {
                    this.stoppingCooldown = 40;
                }
                return;
            }
            this.stoppingCooldown = 0;
            this.generatedSpeed = speed;
            this.generatedCapacity = capacity;
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        return FlywheelBlockEntity.convertToDirection((float)this.generatedSpeed, (Direction)((Direction)this.m_58900_().m_61143_(FlywheelBlock.HORIZONTAL_FACING)));
    }

    public float calculateAddedStressCapacity() {
        this.lastCapacityProvided = this.generatedCapacity;
        return this.lastCapacityProvided;
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(2.0);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128350_("GeneratedSpeed", this.generatedSpeed);
        compound.m_128350_("GeneratedCapacity", this.generatedCapacity);
        compound.m_128405_("Cooldown", this.stoppingCooldown);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.generatedSpeed = compound.m_128457_("GeneratedSpeed");
        this.generatedCapacity = compound.m_128457_("GeneratedCapacity");
        this.stoppingCooldown = compound.m_128451_("Cooldown");
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.visualSpeed.chase((double)this.getGeneratedSpeed(), 0.03125, LerpedFloat.Chaser.EXP);
        }
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            float targetSpeed = this.isVirtual() ? this.speed : this.getGeneratedSpeed();
            this.visualSpeed.updateChaseTarget(targetSpeed);
            this.visualSpeed.tickChaser();
            this.angle += this.visualSpeed.getValue() * 3.0f / 10.0f;
            this.angle %= 360.0f;
        } else {
            if (this.getGeneratedSpeed() != 0.0f && this.getSpeed() == 0.0f) {
                this.updateGeneratedRotation();
            }
            if (this.stoppingCooldown != 0) {
                --this.stoppingCooldown;
                if (this.stoppingCooldown == 0) {
                    this.generatedCapacity = 0.0f;
                    this.generatedSpeed = 0.0f;
                    this.updateGeneratedRotation();
                }
            }
        }
    }
}

