/*
 * Decompiled with CFR 0.152.
 */
package com.landscapesreimagined.ddtocreate6.replaced.BlockEntities;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.content.kinetics.saw.SawFilterSlot;
import com.simibubi.create.content.kinetics.saw.TreeCutter;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import uwu.lopyluna.create_dd.DDTags;
import uwu.lopyluna.create_dd.block.BlockProperties.drill.bronze.BronzeDrillBlock;
import uwu.lopyluna.create_dd.configs.DDConfigs;

public class BronzeSawBlockEntity
extends SawBlockEntity {
    private static final Object cuttingRecipesKey = new Object();
    private int recipeIndex;
    private final LazyOptional<IItemHandler> invProvider;
    private FilteringBehaviour filtering;
    private ItemStack playEvent;

    public BronzeSawBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ProcessingInventory(this::start).withSlotLimit((Boolean)DDConfigs.server().recipes.bulkCutting.get() == false);
        this.inventory.remainingTime = -1.0f;
        this.recipeIndex = 0;
        this.invProvider = LazyOptional.of(() -> this.inventory);
        this.playEvent = ItemStack.f_41583_;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("RecipeIndex", this.recipeIndex);
        super.write(compound, clientPacket);
        if (clientPacket && !this.playEvent.m_41619_()) {
            compound.m_128365_("PlayEvent", (Tag)this.playEvent.serializeNBT());
            this.playEvent = ItemStack.f_41583_;
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.recipeIndex = compound.m_128451_("RecipeIndex");
        if (compound.m_128441_("PlayEvent")) {
            this.playEvent = ItemStack.m_41712_((CompoundTag)compound.m_128469_("PlayEvent"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() != 0.0f && !this.playEvent.m_41619_()) {
            boolean isWood = false;
            Item item = this.playEvent.m_41720_();
            if (item instanceof BlockItem) {
                Block block = ((BlockItem)item).m_40614_();
                isWood = block.getSoundType(block.m_49966_(), (LevelReader)this.f_58857_, this.f_58858_, null) == SoundType.f_56736_;
            }
            this.spawnEventParticles(this.playEvent);
            this.playEvent = ItemStack.f_41583_;
            if (!isWood) {
                AllSoundEvents.SAW_ACTIVATE_STONE.playAt(this.f_58857_, (Vec3i)this.f_58858_, 3.0f, 1.0f, true);
            } else {
                AllSoundEvents.SAW_ACTIVATE_WOOD.playAt(this.f_58857_, (Vec3i)this.f_58858_, 3.0f, 1.0f, true);
            }
        }
    }

    protected BlockPos getBreakingPos() {
        return this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)BronzeDrillBlock.FACING));
    }

    protected float getBreakSpeed() {
        return Math.abs(this.getSpeed() / 35.0f);
    }

    public boolean canBreak(BlockState stateToBreak, float blockHardness) {
        boolean sawable = BronzeSawBlockEntity.isSawable(stateToBreak);
        return super.canBreak(stateToBreak, blockHardness) && sawable;
    }

    public static boolean isSawable(BlockState stateToBreak) {
        if (stateToBreak.m_204336_(BlockTags.f_13104_)) {
            return false;
        }
        if (TreeCutter.isLog((BlockState)stateToBreak) || stateToBreak.m_204336_(BlockTags.f_13035_)) {
            return true;
        }
        if (TreeCutter.isRoot((BlockState)stateToBreak)) {
            return true;
        }
        Block block = stateToBreak.m_60734_();
        if (block instanceof BambooStalkBlock) {
            return true;
        }
        if (block instanceof StemGrownBlock) {
            return true;
        }
        if (block instanceof CactusBlock) {
            return true;
        }
        if (block instanceof SugarCaneBlock) {
            return true;
        }
        if (block instanceof KelpPlantBlock) {
            return true;
        }
        if (block instanceof KelpBlock) {
            return true;
        }
        if (block instanceof ChorusPlantBlock) {
            return true;
        }
        if (TreeCutter.canDynamicTreeCutFrom((Block)block)) {
            return true;
        }
        return !stateToBreak.m_204336_(DDTags.AllBlockTags.bronze_saw_immune.tag) && stateToBreak.m_204336_(DDTags.AllBlockTags.bronze_saw_valid.tag);
    }

    public void tick() {
        if (this.shouldRun() && this.ticksUntilNextProgress < 0) {
            this.destroyNextTick();
        }
        super.tick();
        if (this.canProcess() && this.getSpeed() != 0.0f) {
            if (this.inventory.remainingTime == -1.0f) {
                if (!this.inventory.isEmpty() && !this.inventory.appliedRecipe) {
                    this.start(this.inventory.getStackInSlot(0));
                }
            } else {
                float processingSpeed = Mth.m_14036_((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
                this.inventory.remainingTime -= processingSpeed;
                if (this.inventory.remainingTime > 0.0f) {
                    this.spawnParticles(this.inventory.getStackInSlot(0));
                }
                if (!(this.inventory.remainingTime < 5.0f) || this.inventory.appliedRecipe) {
                    Vec3 itemMovement = this.getItemMovementVec();
                    Direction itemMovementFacing = Direction.m_122366_((double)itemMovement.f_82479_, (double)itemMovement.f_82480_, (double)itemMovement.f_82481_);
                    if (!(this.inventory.remainingTime > 0.0f)) {
                        this.inventory.remainingTime = 0.0f;
                        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                            ItemStack tryExportingToBeltFunnel;
                            ItemStack stack = this.inventory.getStackInSlot(slot);
                            if (stack.m_41619_() || (tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(stack, itemMovementFacing.m_122424_(), false)) == null) continue;
                            if (tryExportingToBeltFunnel.m_41613_() != stack.m_41613_()) {
                                this.inventory.setStackInSlot(slot, tryExportingToBeltFunnel);
                                this.notifyUpdate();
                                return;
                            }
                            if (tryExportingToBeltFunnel.m_41619_()) continue;
                            return;
                        }
                        BlockPos nextPos = this.f_58858_.m_121955_((Vec3i)BlockPos.m_274446_((Position)itemMovement));
                        DirectBeltInputBehaviour behaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)nextPos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
                        if (behaviour != null) {
                            boolean changed = false;
                            if (behaviour.canInsertFromSide(itemMovementFacing) && (!this.f_58857_.f_46443_ || this.isVirtual())) {
                                for (int slotx = 0; slotx < this.inventory.getSlots(); ++slotx) {
                                    ItemStack remainder;
                                    ItemStack stack = this.inventory.getStackInSlot(slotx);
                                    if (stack.m_41619_() || (remainder = behaviour.handleInsertion(stack, itemMovementFacing, false)).equals(stack, false)) continue;
                                    this.inventory.setStackInSlot(slotx, remainder);
                                    changed = true;
                                }
                                if (changed) {
                                    this.m_6596_();
                                    this.sendData();
                                }
                            }
                        } else {
                            Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(itemMovement.m_82490_(0.5).m_82520_(0.0, 0.5, 0.0));
                            Vec3 outMotion = itemMovement.m_82490_(0.0625).m_82520_(0.0, 0.125, 0.0);
                            for (int slotxx = 0; slotxx < this.inventory.getSlots(); ++slotxx) {
                                ItemStack stack = this.inventory.getStackInSlot(slotxx);
                                if (stack.m_41619_()) continue;
                                ItemEntity entityIn = new ItemEntity(this.f_58857_, outPos.f_82479_, outPos.f_82480_, outPos.f_82481_, stack);
                                entityIn.m_20256_(outMotion);
                                this.f_58857_.m_7967_((Entity)entityIn);
                            }
                            this.inventory.clear();
                            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
                            this.inventory.remainingTime = -1.0f;
                            this.sendData();
                        }
                    }
                } else if (!this.f_58857_.f_46443_ || this.isVirtual()) {
                    this.playEvent = this.inventory.getStackInSlot(0);
                    this.applyRecipe();
                    this.inventory.appliedRecipe = true;
                    this.inventory.recipeDuration = 20.0f;
                    this.inventory.remainingTime = 20.0f;
                    this.sendData();
                }
            }
        }
    }

    public void invalidate() {
        super.invalidate();
        this.invProvider.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER && side != Direction.DOWN ? this.invProvider.cast() : super.getCapability(cap, side);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new SawFilterSlot()).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).allowingBeltFunnelsWhen(() -> this.canProcess()));
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.SAW_PROCESSING});
    }

    private void applyRecipe() {
        List<Recipe<?>> recipes = this.getRecipes();
        if (!recipes.isEmpty()) {
            if (this.recipeIndex >= recipes.size()) {
                this.recipeIndex = 0;
            }
            Recipe<?> recipe = recipes.get(this.recipeIndex);
            int rolls = this.inventory.getStackInSlot(0).m_41613_();
            this.inventory.clear();
            ArrayList list = new ArrayList();
            for (int roll = 0; roll < rolls; ++roll) {
                List<ItemStack> results = new LinkedList();
                if (recipe instanceof CuttingRecipe) {
                    results = ((CuttingRecipe)recipe).rollResults();
                } else if (recipe instanceof StonecutterRecipe || recipe.m_6671_() == woodcuttingRecipeType.get()) {
                    results.add(recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_());
                }
                for (int i = 0; i < results.size(); ++i) {
                    ItemStack stack = (ItemStack)results.get(i);
                    ItemHelper.addToList((ItemStack)stack, list);
                }
            }
            for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlots(); ++slot) {
                this.inventory.setStackInSlot(slot + 1, (ItemStack)list.get(slot));
            }
            this.award(AllAdvancements.SAW_PROCESSING);
        }
    }

    private List<? extends Recipe<?>> getRecipes() {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)this.inventory.getStackInSlot(0), (RecipeType)AllRecipeTypes.CUTTING.getType(), CuttingRecipe.class);
        if (assemblyRecipe.isPresent() && this.filtering.test(((CuttingRecipe)assemblyRecipe.get()).m_8043_(this.f_58857_.m_9598_()))) {
            return ImmutableList.of((Object)((CuttingRecipe)assemblyRecipe.get()));
        }
        Predicate types = RecipeConditions.isOfType((RecipeType[])new RecipeType[]{AllRecipeTypes.CUTTING.getType(), (Boolean)DDConfigs.server().recipes.allowStonecuttingOnSaw.get() != false ? RecipeType.f_44112_ : null, (Boolean)DDConfigs.server().recipes.allowWoodcuttingOnSaw.get() != false ? (RecipeType)woodcuttingRecipeType.get() : null});
        List startedSearch = RecipeFinder.get((Object)cuttingRecipesKey, (Level)this.f_58857_, (Predicate)types);
        return startedSearch.stream().filter(RecipeConditions.outputMatchesFilter((FilteringBehaviour)this.filtering)).filter(RecipeConditions.firstIngredientMatches((ItemStack)this.inventory.getStackInSlot(0))).filter(r -> !AllRecipeTypes.shouldIgnoreInAutomation((Recipe)r)).collect(Collectors.toList());
    }

    public void start(ItemStack inserted) {
        if (this.canProcess() && !this.inventory.isEmpty() && (!this.f_58857_.f_46443_ || this.isVirtual())) {
            List<Recipe<?>> recipes = this.getRecipes();
            boolean valid = !recipes.isEmpty();
            int time = 50;
            if (recipes.isEmpty()) {
                this.inventory.recipeDuration = 10.0f;
                this.inventory.remainingTime = 10.0f;
                this.inventory.appliedRecipe = false;
                this.sendData();
            } else {
                Recipe<?> recipe;
                if (valid) {
                    ++this.recipeIndex;
                    if (this.recipeIndex >= recipes.size()) {
                        this.recipeIndex = 0;
                    }
                }
                if ((recipe = recipes.get(this.recipeIndex)) instanceof CuttingRecipe) {
                    time = ((CuttingRecipe)recipe).getProcessingDuration();
                }
                this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, inserted.m_41613_() / 5));
                this.inventory.appliedRecipe = false;
                this.sendData();
            }
        }
    }
}

