/*
 * Decompiled with CFR 0.152.
 */
package com.landscapesreimagined.ddtocreate6.preinitutils;

import java.util.Locale;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;

public class InstructionToString {
    public static String toString(Object[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(String.valueOf(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String instructionToString(AbstractInsnNode instruction, MethodNode methodNode, ClassNode classNode) {
        StringBuilder insns = new StringBuilder();
        insns.append("instruction: ").append(instruction.getOpcode());
        insns.append(" | type: ").append(instruction.getType());
        if (instruction.getOpcode() != -1) {
            insns.append(" | name: ").append(Printer.OPCODES[instruction.getOpcode()].toLowerCase(Locale.ROOT));
        }
        switch (instruction.getType()) {
            case 0: 
            case 1: {
                if (!(instruction instanceof IntInsnNode)) break;
                IntInsnNode intInsnNode = (IntInsnNode)instruction;
                insns.append(" | Operand: ").append(instruction.getOpcode() == 188 ? Printer.TYPES[intInsnNode.operand] : Integer.toString(intInsnNode.operand));
            }
            case 2: {
                if (!(instruction instanceof VarInsnNode)) break;
                VarInsnNode varInsn = (VarInsnNode)instruction;
                if (varInsn.var >= methodNode.localVariables.size()) {
                    insns.append(" | METHOD BROKE");
                    break;
                }
                LocalVariableNode localVariableNode = (LocalVariableNode)methodNode.localVariables.get(varInsn.var);
                if (localVariableNode != null) {
                    insns.append(" | Var: ").append(localVariableNode.name).append(" | Desc: ").append(localVariableNode.desc).append(" | Signature: ").append(localVariableNode.signature);
                }
            }
            case 3: {
                if (!(instruction instanceof TypeInsnNode)) break;
                TypeInsnNode typeInsnNode = (TypeInsnNode)instruction;
                insns.append(" |");
                if (instruction.getOpcode() == 187) {
                    insns.append(" New");
                }
                insns.append(" Type: ").append(typeInsnNode.desc);
            }
            case 4: {
                if (!(instruction instanceof FieldInsnNode)) break;
                FieldInsnNode fieldInsnNode = (FieldInsnNode)instruction;
                insns.append(" | Name: ").append(fieldInsnNode.name);
                insns.append(" | Desc: ").append(fieldInsnNode.desc);
                insns.append(" | Owner: ").append(fieldInsnNode.owner);
            }
            case 5: {
                if (!(instruction instanceof MethodInsnNode)) break;
                MethodInsnNode methodInsnNode = (MethodInsnNode)instruction;
                insns.append(" | Name: ").append(methodInsnNode.name).append(" | Method: ").append(methodInsnNode.name).append(" | Desc: ").append(methodInsnNode.desc).append(" | Owner: ").append(methodInsnNode.owner);
            }
            case 6: {
                if (!(instruction instanceof InvokeDynamicInsnNode)) break;
                InvokeDynamicInsnNode idin = (InvokeDynamicInsnNode)instruction;
                insns.append(" | Name: ").append(idin.name).append(" | Desc: ").append(idin.desc);
                insns.append(" | BSM Name: ").append(idin.bsm.getName()).append(" | BSM Desc: ").append(idin.bsm.getDesc()).append(" | BSM Owner: ").append(idin.bsm.getOwner());
                insns.append(" | BSM Args: ").append(InstructionToString.toString(idin.bsmArgs));
            }
            case 7: {
                if (!(instruction instanceof JumpInsnNode)) break;
                JumpInsnNode jumpInsnNode = (JumpInsnNode)instruction;
                insns.append(" | Jump To Label: ").append(jumpInsnNode.label.getLabel());
            }
            case 8: {
                if (!(instruction instanceof LabelNode)) break;
                LabelNode labelNode = (LabelNode)instruction;
                insns.append(" | Label: ").append(labelNode.getLabel());
            }
            case 9: {
                if (!(instruction instanceof LdcInsnNode)) break;
                LdcInsnNode ldcInsnNode = (LdcInsnNode)instruction;
                insns.append(" | LDC Constant: ").append(ldcInsnNode.cst);
            }
            case 10: {
                if (!(instruction instanceof IincInsnNode)) break;
                IincInsnNode iincInsnNode = (IincInsnNode)instruction;
                insns.append(" | Inc ").append(((LocalVariableNode)methodNode.localVariables.get((int)iincInsnNode.var)).name).append(" By: ").append(iincInsnNode.incr);
            }
            case 11: {
                if (!(instruction instanceof TableSwitchInsnNode)) break;
                TableSwitchInsnNode tableSwitchInsnNode = (TableSwitchInsnNode)instruction;
                insns.append(" | TableSwitch Default: ").append(tableSwitchInsnNode.dflt).append(" | Max: ").append(tableSwitchInsnNode.max).append(" | Min: ").append(tableSwitchInsnNode.min);
                insns.append(" | Cases: ").append('[');
                for (LabelNode label : tableSwitchInsnNode.labels) {
                    insns.append(label);
                    if (label == tableSwitchInsnNode.labels.get(tableSwitchInsnNode.labels.size() - 1)) continue;
                    insns.append(", ");
                }
                insns.append(']');
            }
            case 12: {
                if (!(instruction instanceof LookupSwitchInsnNode)) break;
                LookupSwitchInsnNode lookupSwitchInsnNode = (LookupSwitchInsnNode)instruction;
                insns.append(" | Default: ").append(lookupSwitchInsnNode.dflt);
                insns.append(" | Keys: [");
                for (Integer i : lookupSwitchInsnNode.keys) {
                    insns.append(i);
                    if (i.equals(lookupSwitchInsnNode.keys.get(lookupSwitchInsnNode.keys.size() - 1))) continue;
                    insns.append(", ");
                }
                insns.append("] | Cases: [");
                for (LabelNode label : lookupSwitchInsnNode.labels) {
                    insns.append(label);
                    if (label == lookupSwitchInsnNode.labels.get(lookupSwitchInsnNode.labels.size() - 1)) continue;
                    insns.append(", ");
                }
                insns.append(']');
            }
            case 13: {
                if (!(instruction instanceof MultiANewArrayInsnNode)) break;
                MultiANewArrayInsnNode multiANewArrayInsnNode = (MultiANewArrayInsnNode)instruction;
                insns.append(" | Desc: ").append(multiANewArrayInsnNode.desc).append(" | Dims: ").append(multiANewArrayInsnNode.dims);
            }
            case 14: {
                if (!(instruction instanceof FrameNode)) break;
                FrameNode frameNode = (FrameNode)instruction;
                insns.append(" | Frame Type: ");
                switch (frameNode.type) {
                    case -1: 
                    case 0: {
                        insns.append("Full [");
                        insns.append("] | [");
                        insns.append(']');
                        break;
                    }
                    case 1: {
                        insns.append("append [");
                        InstructionToString.appendFrameLocals(insns, frameNode);
                        insns.append(']');
                        break;
                    }
                    case 2: {
                        insns.append("chop ").append(frameNode.local.size());
                        break;
                    }
                    case 3: {
                        insns.append("same");
                        break;
                    }
                    case 4: {
                        insns.append("same1 ");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            case 15: {
                if (!(instruction instanceof LineNumberNode)) break;
                LineNumberNode lnn = (LineNumberNode)instruction;
                insns.append(" Line: ").append(lnn.line);
            }
        }
        return insns.toString();
    }

    private static void appendFrameLocals(StringBuilder insns, FrameNode frameNode) {
        boolean first = true;
        for (Object o : frameNode.local) {
            if (first) {
                insns.append("{");
                first = false;
            } else {
                insns.append(", {");
            }
            insns.append(o).append("}");
        }
    }
}

