/*
 * Decompiled with CFR 0.152.
 */
package com.landscapesreimagined.ddtocreate6.preinitutils;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InstructionFixers {
    public static final HashMap<String, String> ONE_TO_ONE_CLASS_MOVES = new HashMap();

    public static void applyStaticInsnClassMoves(AbstractInsnNode insn, MethodNode method) {
        if (insn.getType() == 2) {
            if (!(insn instanceof VarInsnNode)) {
                return;
            }
            VarInsnNode vinsn = (VarInsnNode)insn;
            if (vinsn.var >= method.localVariables.size()) {
                return;
            }
            LocalVariableNode lvn = (LocalVariableNode)method.localVariables.get(vinsn.var);
            String desc = lvn.desc;
            String sig = lvn.signature;
            for (String oldClass : ONE_TO_ONE_CLASS_MOVES.keySet()) {
                String newClass = ONE_TO_ONE_CLASS_MOVES.get(oldClass);
                while (desc.contains(oldClass)) {
                    desc = desc.replace(oldClass, newClass);
                }
            }
            if (sig != null) {
                sig = InstructionFixers.replaceAllOldClasses(sig);
            }
            lvn.desc = desc;
            lvn.signature = sig;
            method.localVariables.set(vinsn.var, lvn);
        } else if (insn.getType() == 4) {
            if (!(insn instanceof FieldInsnNode)) {
                return;
            }
            FieldInsnNode fieldInsn = (FieldInsnNode)insn;
            String desc = fieldInsn.desc;
            String owner = fieldInsn.owner;
            desc = InstructionFixers.replaceAllOldClasses(desc);
            owner = InstructionFixers.replaceAllOldClasses(owner);
            fieldInsn.desc = desc;
            fieldInsn.owner = owner;
        } else if (insn.getType() == 5) {
            if (!(insn instanceof MethodInsnNode)) {
                return;
            }
            MethodInsnNode minsn = (MethodInsnNode)insn;
            String desc = minsn.desc;
            String owner = minsn.owner;
            for (String oldClass : ONE_TO_ONE_CLASS_MOVES.keySet()) {
                String newClass = ONE_TO_ONE_CLASS_MOVES.get(oldClass);
                desc = desc.replaceAll(oldClass, newClass);
                owner = owner.replaceAll(oldClass, newClass);
            }
            minsn.desc = desc;
            minsn.owner = owner;
        } else if (insn.getType() == 6) {
            if (!(insn instanceof InvokeDynamicInsnNode)) {
                return;
            }
            InvokeDynamicInsnNode idin = (InvokeDynamicInsnNode)insn;
            String desc = idin.desc;
            idin.desc = desc = InstructionFixers.replaceAllOldClasses(desc);
            Object[] BSMArgs = idin.bsmArgs;
            for (int i = 0; i < BSMArgs.length; ++i) {
                Object o = BSMArgs[i];
                if (o instanceof String) {
                    String s = (String)o;
                    o = InstructionFixers.replaceAllOldClasses(s);
                }
                if (o instanceof Type) {
                    Type t = (Type)o;
                    if (t.getSort() != 10 && t.getSort() != 11) continue;
                    String tdesc = t.getDescriptor();
                    tdesc = InstructionFixers.replaceAllOldClasses(tdesc);
                    o = Type.getType((String)tdesc);
                }
                if (o instanceof Handle) {
                    Handle h = (Handle)o;
                    String handleDesc = h.getDesc();
                    String owner = h.getOwner();
                    String[] replaced = InstructionFixers.replaceAllOldClasses(owner, handleDesc);
                    o = new Handle(h.getTag(), replaced[0], h.getName(), replaced[1], h.isInterface());
                }
                BSMArgs[i] = o;
            }
            idin.bsmArgs = BSMArgs;
        } else if (insn.getType() == 3) {
            if (!(insn instanceof TypeInsnNode)) {
                return;
            }
            TypeInsnNode typeInsnNode = (TypeInsnNode)insn;
            String desc = typeInsnNode.desc;
            typeInsnNode.desc = desc = InstructionFixers.replaceAllOldClasses(desc);
        }
    }

    public static void applyStaticInterfaceMoves(ClassNode node) {
        for (int i = 0; i < node.interfaces.size(); ++i) {
            String interfaceStr = (String)node.interfaces.get(i);
            interfaceStr = InstructionFixers.replaceAllOldClasses(interfaceStr);
            node.interfaces.set(i, interfaceStr);
        }
    }

    public static String replaceAllOldClasses(String desc) {
        for (String oldClass : ONE_TO_ONE_CLASS_MOVES.keySet()) {
            String newClass = ONE_TO_ONE_CLASS_MOVES.get(oldClass);
            desc = desc.replaceAll(oldClass, newClass);
        }
        return desc;
    }

    public static String[] replaceAllOldClasses(String ... descs) {
        for (String oldClass : ONE_TO_ONE_CLASS_MOVES.keySet()) {
            String newClass = ONE_TO_ONE_CLASS_MOVES.get(oldClass);
            for (int i = 0; i < descs.length; ++i) {
                descs[i] = descs[i].replaceAll(oldClass, newClass);
            }
        }
        return descs;
    }

    public static void applyStaticMethodClassMoves(MethodNode method, ClassNode targetClass) {
        int index = 0;
        for (int i = 0; i < targetClass.methods.size(); ++i) {
            if (!((MethodNode)targetClass.methods.get(i)).equals(method)) continue;
            index = i;
            break;
        }
        for (String oldClass : ONE_TO_ONE_CLASS_MOVES.keySet()) {
            method.desc = method.desc.replaceAll(oldClass, ONE_TO_ONE_CLASS_MOVES.get(oldClass));
            if (method.signature == null) continue;
            method.signature = method.signature.replaceAll(oldClass, ONE_TO_ONE_CLASS_MOVES.get(oldClass));
        }
        for (int i = 0; method.localVariables != null && i < method.localVariables.size(); ++i) {
            LocalVariableNode lvn = (LocalVariableNode)method.localVariables.get(i);
            String desc = lvn.desc;
            String sig = lvn.signature;
            if (sig != null) {
                String[] h = InstructionFixers.replaceAllOldClasses(desc, sig);
                lvn.signature = h[1];
                lvn.desc = h[0];
            } else {
                lvn.desc = InstructionFixers.replaceAllOldClasses(desc);
            }
            method.localVariables.set(i, lvn);
        }
        targetClass.methods.set(index, method);
    }

    public static synchronized void applyFieldClassMoves(FieldNode field, ClassNode targetClass) {
        String desc;
        if ((field.access & 8) != 0) {
            return;
        }
        int index = 0;
        for (int i = 0; i < targetClass.methods.size(); ++i) {
            if (!((FieldNode)targetClass.fields.get(i)).equals(field)) continue;
            index = i;
            break;
        }
        String finalDesc = desc = field.desc;
        if (ONE_TO_ONE_CLASS_MOVES.keySet().stream().noneMatch(finalDesc::contains)) {
            return;
        }
        field.desc = desc = InstructionFixers.replaceAllOldClasses(desc);
        targetClass.fields.set(index, field);
    }

    public static synchronized void applyStaticFieldClassMoves(FieldNode field, ClassNode targetClass) {
        String desc;
        if ((field.access & 8) == 0) {
            return;
        }
        int index = 0;
        for (int i = 0; i < targetClass.methods.size(); ++i) {
            if (!((FieldNode)targetClass.fields.get(i)).equals(field)) continue;
            index = i;
            break;
        }
        String finalDesc = desc = field.desc;
        if (ONE_TO_ONE_CLASS_MOVES.keySet().stream().noneMatch(finalDesc::contains)) {
            return;
        }
        field.desc = desc = InstructionFixers.replaceAllOldClasses(desc);
    }

    public static void removeAllInstructions(ClassNode targetClass, MethodNode method, ArrayDeque<AbstractInsnNode> toRemove) {
        while (!toRemove.isEmpty()) {
            AbstractInsnNode insn = toRemove.removeLast();
            method.instructions.remove(insn);
        }
    }

    public static synchronized void removeAllFields(ClassNode targetClass, ArrayDeque<FieldNode> toRemove) {
        while (!toRemove.isEmpty()) {
            FieldNode field = toRemove.removeLast();
            targetClass.fields.remove(field);
        }
    }

    public static void createInstanceToCreateVisual(MethodNode method, ClassNode targetClass) {
        int index = 0;
        for (int i = 0; i < targetClass.methods.size(); ++i) {
            if (!((MethodNode)targetClass.methods.get(i)).equals(method)) continue;
            index = i;
            break;
        }
        if (method.desc.equals("(Lcom/jozufozu/flywheel/api/MaterialManager;Lcom/jozufozu/flywheel/core/virtual/VirtualRenderWorld;Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;)Lcom/simibubi/create/content/contraptions/render/ActorInstance;")) {
            method.name = "createVisual";
            method.desc = "(Ldev/engine_room/flywheel/api/visualization/VisualizationContext;Lcom/simibubi/create/foundation/virtualWorld/VirtualRenderWorld;Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;)Lcom/simibubi/create/content/contraptions/render/ActorVisual;";
        }
        targetClass.methods.set(index, method);
    }

    public static void executeOnEachInsn(ClassNode cn, BiConsumer<AbstractInsnNode, MethodNode> insnConsumer) {
        InstructionFixers.executeOnEachInsn(cn, insnConsumer, null, null);
    }

    public static void executeOnEachInsn(ClassNode cn, BiConsumer<AbstractInsnNode, MethodNode> insnConsumer, @Nullable Consumer<MethodNode> methodConsumer) {
        InstructionFixers.executeOnEachInsn(cn, insnConsumer, methodConsumer, null);
    }

    public static void executeOnEachInsn(ClassNode cn, BiConsumer<AbstractInsnNode, MethodNode> insnConsumer, @Nullable Consumer<MethodNode> methodConsumer, @Nullable Consumer<ClassNode> classConsumer) {
        if (classConsumer != null) {
            classConsumer.accept(cn);
        }
        for (MethodNode m : cn.methods) {
            if (methodConsumer != null) {
                methodConsumer.accept(m);
            }
            for (AbstractInsnNode insn : m.instructions) {
                insnConsumer.accept(insn, m);
            }
        }
    }

    public static void fixIPlacementHelperInsn(AbstractInsnNode insn, MethodNode method) {
        if (insn.getType() == 2) {
            String desc;
            VarInsnNode varInsn = (VarInsnNode)insn;
            if (varInsn.var >= method.localVariables.size()) {
                return;
            }
            LocalVariableNode localVariableNode = (LocalVariableNode)method.localVariables.get(varInsn.var);
            if (localVariableNode != null && (desc = localVariableNode.desc).equals("Lcom/simibubi/create/foundation/placement/IPlacementHelper;")) {
                localVariableNode.desc = "Lnet/createmod/catnip/placement/IPlacementHelper;";
                method.localVariables.set(varInsn.var, localVariableNode);
            }
        } else if (insn.getType() == 5) {
            MethodInsnNode methodNode = (MethodInsnNode)insn;
            if (methodNode.desc.contains("com/simibubi/create/foundation/placement/IPlacementHelper")) {
                methodNode.desc = methodNode.desc.replace("com/simibubi/create/foundation/placement/IPlacementHelper", "net/createmod/catnip/placement/IPlacementHelper");
            }
            if (methodNode.desc.contains("Lcom/simibubi/create/foundation/placement/PlacementOffset")) {
                methodNode.desc = methodNode.desc.replace("Lcom/simibubi/create/foundation/placement/PlacementOffset", "Lnet/createmod/catnip/placement/PlacementOffset");
            }
            if (methodNode.owner.equals("com/simibubi/create/foundation/placement/PlacementHelpers")) {
                methodNode.owner = "net/createmod/catnip/placement/PlacementHelpers";
            } else if (methodNode.owner.equals("com/simibubi/create/foundation/placement/IPlacementHelper")) {
                methodNode.owner = "net/createmod/catnip/placement/IPlacementHelper";
            } else if (methodNode.owner.equals("com/simibubi/create/foundation/placement/PlacementOffset")) {
                methodNode.owner = "net/createmod/catnip/placement/PlacementOffset";
            }
        }
    }

    public static void fixActorInstanceInsn(AbstractInsnNode insn, MethodNode method) {
        if (insn.getType() == 5) {
            // empty if block
        }
    }

    static {
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/utility/VecHelper", "net/createmod/catnip/math/VecHelper");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/content/contraptions/render/ActorInstance", "com/simibubi/create/content/contraptions/actors/ActorInstance");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/utility/Couple", "net/createmod/catnip/data/Couple");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/content/kinetics/BlockStressDefaults", "com/landscapesreimagined/ddtocreate6/util/RegistrateUtil");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/content/contraptions/ITransformableBlock", "com/simibubi/create/api/contraption/transformable/TransformableBlock");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/content/equipment/goggles/IHaveGoggleInformation", "com/simibubi/create/api/equipment/goggles/IHaveGoggleInformation");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/utility/animation/LerpedFloat", "net/createmod/catnip/animation/LerpedFloat");
        ONE_TO_ONE_CLASS_MOVES.put("com/jozufozu/flywheel/core/PartialModel", "dev/engine_room/flywheel/lib/model/baked/PartialModel");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/render/SuperByteBuffer", "net/createmod/catnip/render/SuperByteBuffer");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/render/CachedBufferer", "net/createmod/catnip/render/CachedBuffers");
        ONE_TO_ONE_CLASS_MOVES.put("com/jozufozu/flywheel/core/virtual/VirtualRenderWorld", "com/simibubi/create/foundation/virtualWorld/VirtualRenderWorld");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/utility/AngleHelper", "net/createmod/catnip/math/AngleHelper");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/utility/AnimationTickHolder", "net/createmod/catnip/animation/AnimationTickHolder");
        ONE_TO_ONE_CLASS_MOVES.put("com/jozufozu/flywheel/util/transform/TransformStack", "dev/engine_room/flywheel/lib/transform/TransformStack");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/utility/worldWrappers/WrappedWorld", "com/simibubi/create/foundation/utility/worldWrappers/WrappedBlockAndTintGetter");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/placement/IPlacementHelper", "net/createmod/catnip/placement/IPlacementHelper");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/placement/PlacementOffset", "net/createmod/catnip/placement/PlacementOffset");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/item/TooltipHelper", "net/createmod/catnip/lang/FontHelper");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/utility/VoxelShaper", "net/createmod/catnip/math/VoxelShaper");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/utility/Color", "net/createmod/catnip/theme/Color");
        ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/utility/TreeCutter", "com/simibubi/create/content/kinetics/saw/TreeCutter");
        ONE_TO_ONE_CLASS_MOVES.put("uwu/lopyluna/create_dd.block/BlockProperties/flywheel/FlywheelRenderer", "com/landscapesreimagined/ddtocreate6/replaced/BlockEntityRenderers/FlywheelRenderer");
    }
}

