/*
 * Decompiled with CFR 0.152.
 */
package com.landscapesreimagined.ddtocreate6.mixin;

import com.landscapesreimagined.ddtocreate6.preinitutils.InstructionFixers;
import com.landscapesreimagined.ddtocreate6.preinitutils.InstructionToString;
import com.landscapesreimagined.ddtocreate6.preinitutils.LookAroundMatchers;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    public static final boolean debug = false;
    public static final Object2IntMap<String> aaa = new Object2IntArrayMap();
    private static final Logger log = LoggerFactory.getLogger(MixinConfigPlugin.class);
    public static String[] CStressValidMethods = new String[]{"setImpact", "setCapacity", "setNoImpact"};

    public void onLoad(String mixinPackage) {
        try {
            this.getClass().getClassLoader().loadClass("com.landscapesreimagined.ddtocreate6.preinitutils.InstructionToString");
            this.getClass().getClassLoader().loadClass("com.landscapesreimagined.ddtocreate6.preinitutils.ClassConstants");
            this.getClass().getClassLoader().loadClass("com.landscapesreimagined.ddtocreate6.preinitutils.InstructionFixers");
            this.getClass().getClassLoader().loadClass("com.landscapesreimagined.ddtocreate6.preinitutils.MethodReplacers");
            this.getClass().getClassLoader().loadClass("com.landscapesreimagined.ddtocreate6.preinitutils.LookAroundMatchers");
        }
        catch (ClassNotFoundException e) {
            log.error("Could not find preinit util class!!! This should be fine, but here be dragons! If this is in the log, I CAN NOT HELP YOU!");
            log.error(e.getMessage());
        }
    }

    public String getRefMapperConfig() {
        return "";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return List.of();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        String targetClassJavaName = targetClassName.substring(targetClassName.lastIndexOf(46) + 1);
        String mixinJavaName = mixinClassName.substring(mixinClassName.lastIndexOf(46) + 1);
        if (aaa.containsKey((Object)targetClassName)) {
            aaa.computeInt((Object)targetClassName, (s, i) -> i + 1);
        } else {
            aaa.put((Object)targetClassName, 0);
        }
        if (targetClassJavaName.equals("DDCreate")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (mixinJavaName.equals("RendererFixer")) {
            InstructionFixers.ONE_TO_ONE_CLASS_MOVES.put("uwu/lopyluna/create_dd/block/BlockResources/DDBlockPartialModel", "com/landscapesreimagined/ddtocreate6/replaced/ReplacedDDBlockPartialModel");
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
            InstructionFixers.ONE_TO_ONE_CLASS_MOVES.remove("uwu/lopyluna/create_dd/block/BlockResources/DDBlockPartialModel");
        }
        if (targetClassJavaName.equals("CogCrankBlockEntity")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassJavaName.equals("IndustrialAirCurrent")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (mixinJavaName.equals("DDBlockShapesFixerTester")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassJavaName.equals("DDBlockEntityTypes")) {
            StringBuilder insns = new StringBuilder();
            for (Object m2 : targetClass.methods) {
                insns.append("method: ").append(((MethodNode)m2).name).append('\n');
                for (AbstractInsnNode insn2 : ((MethodNode)m2).instructions) {
                    insns.append(InstructionToString.instructionToString(insn2, (MethodNode)m2, targetClass)).append('\n');
                }
            }
            int flywheelInitLength = 29;
            for (Object m3 : targetClass.methods) {
                int deleted = 0;
                boolean deleting = false;
                ArrayDeque<AbstractInsnNode> arrayDeque = new ArrayDeque<AbstractInsnNode>();
                for (Object insn3 : ((MethodNode)m3).instructions) {
                    if (!deleting) {
                        AbstractInsnNode next;
                        if (insn3.getOpcode() != 178 || (next = insn3.getNext()).getOpcode() != 18 || !((LdcInsnNode)next).cst.equals("flywheel")) continue;
                        deleting = true;
                        continue;
                    }
                    if (deleted >= 29) {
                        deleting = false;
                        continue;
                    }
                    arrayDeque.push((AbstractInsnNode)insn3);
                    ++deleted;
                }
                InstructionFixers.removeAllInstructions(targetClass, (MethodNode)m3, arrayDeque);
            }
            int bronzeSawInitLength = 27;
            for (MethodNode m4 : targetClass.methods) {
                int deleted = 0;
                boolean bl = false;
                ArrayDeque<AbstractInsnNode> toRemove = new ArrayDeque<AbstractInsnNode>();
                for (Object insn4 : m4.instructions) {
                    boolean bl2;
                    if (!bl2) {
                        AbstractInsnNode next;
                        if (insn4.getOpcode() != 178 || (next = insn4.getNext()).getOpcode() != 18 || !((LdcInsnNode)next).cst.equals("bronze_saw")) continue;
                        bl2 = true;
                        continue;
                    }
                    if (deleted >= 27) {
                        bl2 = false;
                        continue;
                    }
                    toRemove.push((AbstractInsnNode)insn4);
                    ++deleted;
                }
                InstructionFixers.removeAllInstructions(targetClass, m4, toRemove);
            }
            int potatoTurretInitLength = 28;
            for (MethodNode m5 : targetClass.methods) {
                int n = 0;
                boolean deleting = false;
                ArrayDeque<AbstractInsnNode> toRemove = new ArrayDeque<AbstractInsnNode>();
                for (AbstractInsnNode insn5 : m5.instructions) {
                    if (!deleting) {
                        AbstractInsnNode next;
                        if (insn5.getOpcode() != 178 || (next = insn5.getNext()).getOpcode() != 18 || !((LdcInsnNode)next).cst.equals("potato_turret")) continue;
                        deleting = true;
                        continue;
                    }
                    if (n >= 28) {
                        deleting = false;
                        continue;
                    }
                    toRemove.push(insn5);
                    ++n;
                }
                InstructionFixers.removeAllInstructions(targetClass, m5, toRemove);
            }
        }
        if (targetClassJavaName.equals("EightBladeFanBlockEntity")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassJavaName.contains("EngineBlock")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassJavaName.contains("DeforesterItem") || targetClassJavaName.equals("ForestRavagerItem") || targetClassJavaName.equals("TreeCutter") || targetClassJavaName.contains("DeforesterAxeItem")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassJavaName.contains("ForestRavagerRender") || targetClassJavaName.contains("DeforesterRender")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
            for (MethodNode method : targetClass.methods) {
                if (!method.name.equals("<clinit>")) continue;
                int deleteCounter = 0;
                ArrayDeque<AbstractInsnNode> toRemove = new ArrayDeque<AbstractInsnNode>();
                for (AbstractInsnNode insnNode : method.instructions) {
                    if (insnNode.getOpcode() == 187 && ((TypeInsnNode)insnNode).desc.contains("PartialModel")) {
                        deleteCounter = 2;
                    } else if (insnNode.getOpcode() == 183 && ((MethodInsnNode)insnNode).owner.contains("PartialModel")) {
                        deleteCounter = 1;
                        MethodInsnNode methodInsnNode = new MethodInsnNode(184, "dev/engine_room/flywheel/lib/model/baked/PartialModel", "of", "(Lnet/minecraft/resources/ResourceLocation;)Ldev/engine_room/flywheel/lib/model/baked/PartialModel;");
                        method.instructions.insertBefore(insnNode, (AbstractInsnNode)methodInsnNode);
                    }
                    if (deleteCounter <= 0) continue;
                    toRemove.push(insnNode);
                    --deleteCounter;
                }
                InstructionFixers.removeAllInstructions(targetClass, method, toRemove);
            }
        }
        if (mixinClassName.equals("com.landscapesreimagined.ddtocreate6.mixin.BlockFixers.PlacementFixerMultiTargetMixin")) {
            Iterator insnDump = new StringBuilder();
            InstructionFixers.applyStaticInterfaceMoves(targetClass);
            for (MethodNode method : targetClass.methods) {
                if (targetClassJavaName.contains("FanSailBlock")) {
                    ((StringBuilder)((Object)insnDump)).append("method: ").append(method.name).append("\n");
                }
                InstructionFixers.applyStaticMethodClassMoves(method, targetClass);
                for (AbstractInsnNode insn6 : method.instructions) {
                    InstructionFixers.fixIPlacementHelperInsn(insn6, method);
                    InstructionFixers.applyStaticInsnClassMoves(insn6, method);
                    if (!targetClassJavaName.contains("FanSailBlock")) continue;
                    ((StringBuilder)((Object)insnDump)).append(InstructionToString.instructionToString(insn6, method, targetClass)).append("\n");
                }
            }
            if (targetClassJavaName.contains("FanSailBlock")) {
                // empty if block
            }
        }
        if (targetClassJavaName.equals("DDBlockPartialModel")) {
            for (FieldNode field : targetClass.fields) {
                InstructionFixers.applyStaticFieldClassMoves(field, targetClass);
            }
            for (MethodNode method : targetClass.methods) {
                InstructionFixers.applyStaticMethodClassMoves(method, targetClass);
                for (AbstractInsnNode insn7 : method.instructions) {
                    InstructionFixers.fixIPlacementHelperInsn(insn7, method);
                    InstructionFixers.applyStaticInsnClassMoves(insn7, method);
                }
            }
        }
        if (targetClassName.substring(targetClassName.lastIndexOf(46) + 1).equals("ChainDriveBlock2")) {
            for (int i2 = 0; i2 < targetClass.interfaces.size(); ++i2) {
                String interfaceClassName = (String)targetClass.interfaces.get(i2);
                interfaceClassName = InstructionFixers.replaceAllOldClasses(interfaceClassName);
                targetClass.interfaces.set(i2, interfaceClassName);
            }
        }
        if (targetClassJavaName.equals("BuilderTransgender")) {
            StringBuilder insns = new StringBuilder();
            for (MethodNode method : targetClass.methods) {
                ArrayDeque<AbstractInsnNode> toRemove = new ArrayDeque<AbstractInsnNode>();
                insns.append("Method: ").append(method.name).append('\n');
                int deleting = 0;
                for (AbstractInsnNode abstractInsnNode : method.instructions) {
                    insns.append(InstructionToString.instructionToString(abstractInsnNode, method, targetClass)).append('\n');
                    if (abstractInsnNode.getOpcode() == 187 && ((TypeInsnNode)abstractInsnNode).desc.equals("com/simibubi/create/content/contraptions/behaviour/DoorMovingInteraction")) {
                        deleting += 3;
                    }
                    if (abstractInsnNode.getOpcode() == 184 && ((MethodInsnNode)abstractInsnNode).desc.equals("(Lcom/simibubi/create/content/contraptions/behaviour/MovingInteractionBehaviour;)Lcom/tterrag/registrate/util/nullness/NonNullConsumer;")) {
                        deleting += 3;
                    }
                    if (abstractInsnNode.getOpcode() == 187 && ((TypeInsnNode)abstractInsnNode).desc.equals("com/simibubi/create/content/decoration/slidingDoor/SlidingDoorMovementBehaviour")) {
                        deleting += 3;
                    }
                    if (abstractInsnNode.getOpcode() == 184 && ((MethodInsnNode)abstractInsnNode).desc.equals("(Lcom/simibubi/create/content/contraptions/behaviour/MovementBehaviour;)Lcom/tterrag/registrate/util/nullness/NonNullConsumer;")) {
                        deleting += 3;
                    }
                    if (deleting <= 0) continue;
                    toRemove.push(abstractInsnNode);
                    --deleting;
                }
                while (!toRemove.isEmpty()) {
                    AbstractInsnNode insn9 = (AbstractInsnNode)toRemove.removeLast();
                    method.instructions.remove(insn9);
                }
            }
        }
        if (targetClassJavaName.equals("PotatoTurretBlockEntity")) {
            InstructionFixers.applyStaticInterfaceMoves(targetClass);
            for (FieldNode field : targetClass.fields) {
                InstructionFixers.applyFieldClassMoves(field, targetClass);
            }
        }
        if (targetClassJavaName.equals("DDKinetics")) {
            ArrayDeque<FieldNode> toRemove = new ArrayDeque<FieldNode>();
            for (FieldNode f : targetClass.fields) {
                if (!f.name.equals("stressValues")) continue;
                toRemove.push(f);
            }
            InstructionFixers.removeAllFields(targetClass, toRemove);
            int[] opcodes = new int[]{25, 25, 4, 186};
            LookAroundMatchers.SimpleOpcodeMatcher m6 = new LookAroundMatchers.SimpleOpcodeMatcher(4, opcodes);
            for (MethodNode method : targetClass.methods) {
                if (!method.name.equals("<init>")) continue;
                ArrayDeque<AbstractInsnNode> toRemove2 = new ArrayDeque<AbstractInsnNode>();
                int deleting = 0;
                for (AbstractInsnNode insn10 : method.instructions) {
                    if (LookAroundMatchers.lookAhead(m6, insn10, method, targetClass)) {
                        deleting = 13;
                    }
                    if (deleting <= 0) continue;
                    toRemove2.push(insn10);
                    --deleting;
                }
                InstructionFixers.removeAllInstructions(targetClass, method, toRemove2);
            }
        }
        if (targetClassName.equals("uwu.lopyluna.create_dd.block.DDBlocks")) {
            StringBuilder methodInsn = new StringBuilder();
            for (MethodNode method : targetClass.methods) {
                boolean deletingLine = false;
                ArrayList<Object> instructionsToRemove = new ArrayList<Object>();
                for (AbstractInsnNode abstractInsnNode : method.instructions) {
                    if (method.name.equals("<clinit>")) {
                        methodInsn.append(InstructionToString.instructionToString(abstractInsnNode, method, targetClass)).append('\n');
                    }
                    if (deletingLine) {
                        if (abstractInsnNode.getOpcode() == 192) {
                            deletingLine = false;
                            continue;
                        }
                        if (abstractInsnNode.getType() != 15) {
                            instructionsToRemove.add(abstractInsnNode);
                        }
                    }
                    if (abstractInsnNode.getType() != 15) continue;
                    LineNumberNode lnn = (LineNumberNode)abstractInsnNode;
                    if (lnn.line == 520 || lnn.line == 532 || lnn.line == 598 || lnn.line == 609) {
                        deletingLine = true;
                        instructionsToRemove.add(lnn);
                        continue;
                    }
                    deletingLine = false;
                }
                for (AbstractInsnNode abstractInsnNode : instructionsToRemove) {
                    method.instructions.remove(abstractInsnNode);
                }
                instructionsToRemove.clear();
            }
            StringBuilder insns = new StringBuilder();
            for (MethodNode method : targetClass.methods) {
                InstructionFixers.applyStaticMethodClassMoves(method, targetClass);
                boolean rightMethod = method.name.equals("<clinit>");
                ArrayDeque<AbstractInsnNode> toRemove = new ArrayDeque<AbstractInsnNode>();
                int n = 0;
                for (AbstractInsnNode insn2 : method.instructions) {
                    InstructionFixers.applyStaticInsnClassMoves(insn2, method);
                    if (insn2 instanceof MethodInsnNode) {
                        MethodInsnNode methodNode2 = (MethodInsnNode)insn2;
                        if (methodNode2.owner.contains("BlockStressDefaults") && Arrays.stream(CStressValidMethods).anyMatch(s -> s.equals(methodNode.name))) {
                            methodNode2.owner = "com/landscapesreimagined/ddtocreate6/util/RegistrateUtil";
                        }
                    }
                    if (!rightMethod) continue;
                    if (insn2 instanceof TypeInsnNode) {
                        TypeInsnNode typeNode = (TypeInsnNode)insn2;
                        if (insn2.getOpcode() == 187 && typeNode.desc.contains("MovementBehaviour")) {
                            n = 3;
                        }
                    }
                    if (n <= 0) continue;
                    toRemove.push(insn2);
                    --n;
                }
                while (!toRemove.isEmpty()) {
                    AbstractInsnNode insn11 = (AbstractInsnNode)toRemove.removeLast();
                    method.instructions.remove(insn11);
                    targetClass.methods.replaceAll(methodNode -> {
                        if (methodNode == method) {
                            return method;
                        }
                        return methodNode;
                    });
                }
            }
            for (MethodNode method : targetClass.methods) {
                for (AbstractInsnNode insn12 : method.instructions) {
                    insns.append(InstructionToString.instructionToString(insn12, method, targetClass)).append("\n");
                }
            }
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassJavaName.equals("BronzeSawBlockEntity")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassJavaName.equals("BronzeSawRenderer")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassName.contains("BronzeSawBlock")) {
            StringBuilder classString = new StringBuilder();
            for (MethodNode method : targetClass.methods) {
                InstructionFixers.applyStaticMethodClassMoves(method, targetClass);
                for (AbstractInsnNode insn13 : method.instructions) {
                    InstructionFixers.fixIPlacementHelperInsn(insn13, method);
                    classString.append(InstructionToString.instructionToString(insn13, method, targetClass)).append("\n");
                }
            }
        }
        if (targetClassJavaName.equals("BronzeSawBlock$PlacementHelper")) {
            InstructionFixers.applyStaticInterfaceMoves(targetClass);
        }
        if (targetClassName.contains("BronzeDrillBlock") || targetClassName.contains("RadiantDrillBlock") || targetClassName.contains("ShadowDrillBlock")) {
            StringBuilder classString = new StringBuilder();
            InstructionFixers.applyStaticInterfaceMoves(targetClass);
            for (MethodNode method : targetClass.methods) {
                InstructionFixers.applyStaticMethodClassMoves(method, targetClass);
                for (AbstractInsnNode insn14 : method.instructions) {
                    InstructionFixers.fixIPlacementHelperInsn(insn14, method);
                    classString.append(InstructionToString.instructionToString(insn14, method, targetClass)).append("\n");
                }
            }
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassName.contains("BronzeDrillMovementBehaviour") || targetClassName.contains("ShadowDrillMovementBehaviour") || targetClassName.contains("RadiantDrillMovementBehaviour")) {
            for (MethodNode method : targetClass.methods) {
                if (!method.name.equals("createInstance")) continue;
                InstructionFixers.createInstanceToCreateVisual(method, targetClass);
            }
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassJavaName.contains("BronzeSawMovementBehaviour")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
            for (MethodNode m7 : targetClass.methods) {
                if (!m7.name.equals("onBlockBroken")) continue;
                for (AbstractInsnNode insn15 : m7.instructions) {
                    if (insn15.getOpcode() != 184 || !((MethodInsnNode)insn15).name.equals("findTree")) continue;
                    m7.instructions.insertBefore(insn15, (AbstractInsnNode)new VarInsnNode(25, 3));
                    ((MethodInsnNode)insn15).desc = "(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lcom/simibubi/create/content/kinetics/saw/TreeCutter$Tree;";
                }
            }
        }
        if (targetClassName.substring(targetClassName.lastIndexOf(46) + 1).equals("CogCrankBlock")) {
            for (MethodNode method : targetClass.methods) {
                InstructionFixers.applyStaticMethodClassMoves(method, targetClass);
                for (AbstractInsnNode insn16 : method.instructions) {
                    InstructionFixers.applyStaticInsnClassMoves(insn16, method);
                }
            }
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassJavaName.equals("YIPPEESlidingDoorRenderer")) {
            StringBuilder b = new StringBuilder();
            InstructionFixers.executeOnEachInsn(targetClass, (insn, m) -> b.append(InstructionToString.instructionToString(insn, m, targetClass)).append('\n'), m -> b.append(m.name).append('\n'));
            InstructionFixers.ONE_TO_ONE_CLASS_MOVES.put("uwu/lopyluna/create_dd/block/BlockResources/DDBlockPartialModel", "com/landscapesreimagined/ddtocreate6/replaced/ReplacedDDBlockPartialModel");
            InstructionFixers.ONE_TO_ONE_CLASS_MOVES.put("com/simibubi/create/foundation/utility/Iterate", "net/createmod/catnip/data/Iterate");
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass, thingy -> {
                AbstractInsnNode retval = thingy;
                if (thingy.getOpcode() == 178 && ((FieldInsnNode)thingy).owner.equals("net/minecraft/core/Direction") && ((FieldInsnNode)thingy).name.equals("UP") && ((FieldInsnNode)thingy).desc.equals("Lnet/minecraft/core/Direction;")) {
                    return null;
                }
                if (thingy.getType() == 5 && thingy.getOpcode() == 182) {
                    MethodInsnNode translateInstruction = (MethodInsnNode)thingy;
                    if (translateInstruction.owner.equals("net/createmod/catnip/render/SuperByteBuffer")) {
                        retval = translateInstruction.name.equals("translate") && translateInstruction.desc.contains("Lnet/createmod/catnip/render/SuperByteBuffer") ? new MethodInsnNode(185, "net/createmod/catnip/render/SuperByteBuffer", "translate", "(DDD)Ldev/engine_room/flywheel/lib/transform/Translate;") : (translateInstruction.name.equals("translate") && translateInstruction.desc.contains("Ljava/lang/Object") ? new MethodInsnNode(185, "net/createmod/catnip/render/SuperByteBuffer", "translate", "(Lnet/minecraft/world/phys/Vec3;)Ldev/engine_room/flywheel/lib/transform/Translate;") : (translateInstruction.name.equals("rotateCentered") && translateInstruction.desc.equals("(Lnet/minecraft/core/Direction;F)Lnet/createmod/catnip/render/SuperByteBuffer;") ? new MethodInsnNode(185, translateInstruction.owner, translateInstruction.name, "(FLnet/minecraft/core/Direction;)Ldev/engine_room/flywheel/lib/transform/Affine;") : new MethodInsnNode(185, translateInstruction.owner, translateInstruction.name, translateInstruction.desc)));
                    }
                }
                return retval;
            });
            for (MethodNode m8 : targetClass.methods) {
                ArrayDeque<AbstractInsnNode> toRemove = new ArrayDeque<AbstractInsnNode>();
                for (AbstractInsnNode insn17 : m8.instructions) {
                    if (insn17.getType() != 5 || insn17.getOpcode() != 185) continue;
                    MethodInsnNode methodInsnNode = (MethodInsnNode)insn17;
                    if (!methodInsnNode.name.equals("rotateCentered") || !methodInsnNode.desc.equals("(FLnet/minecraft/core/Direction;)Ldev/engine_room/flywheel/lib/transform/Affine;")) continue;
                    m8.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/core/Direction", "UP", "Lnet/minecraft/core/Direction;"));
                }
                InstructionFixers.removeAllInstructions(targetClass, m8, toRemove);
            }
            InstructionFixers.ONE_TO_ONE_CLASS_MOVES.remove("uwu/lopyluna/create_dd/block/BlockResources/DDBlockPartialModel");
            InstructionFixers.ONE_TO_ONE_CLASS_MOVES.remove("com/simibubi/create/foundation/utility/Iterate");
        }
        if (targetClassJavaName.equals("YIPPEESlidingDoorBlockEntity")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassJavaName.equals("KineticMotorBlockEntity")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassJavaName.equals("AcceleratorMotorBlockEntity")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (mixinJavaName.equals("KineticMotorInnerClassMixin")) {
            ArrayDeque<MethodNode> toRemove = new ArrayDeque<MethodNode>();
            for (MethodNode m9 : targetClass.methods) {
                if (m9.name.equals("rotate") && m9.desc.contains("(Lnet/minecraft/world/level/block/state/BlockState;Lcom/mojang/blaze3d/vertex/PoseStack;)V")) {
                    toRemove.push(m9);
                    continue;
                }
                if (!m9.name.equals("getLocalOffset") || !m9.desc.contains("(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/phys/Vec3;")) continue;
                toRemove.push(m9);
            }
            while (!toRemove.isEmpty()) {
                MethodNode m10 = (MethodNode)toRemove.pop();
                targetClass.methods.remove(m10);
            }
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (targetClassJavaName.contains("BladeFanBlockEntity")) {
            LookAroundMatchers.SimpleOpcodeMatcher matcher = new LookAroundMatchers.SimpleOpcodeMatcher(3, 25, 184, 181);
            for (MethodNode m11 : targetClass.methods) {
                ArrayDeque<AbstractInsnNode> toRemove = new ArrayDeque<AbstractInsnNode>();
                for (AbstractInsnNode insn18 : m11.instructions) {
                    if (!matcher.match(insn18, 0) || !matcher.match(insn18.getNext(), 1) || !matcher.match(insn18.getNext().getNext(), 2)) continue;
                    toRemove.push(insn18);
                    toRemove.push(insn18.getNext());
                    toRemove.push(insn18.getNext().getNext());
                }
                InstructionFixers.removeAllInstructions(targetClass, m11, toRemove);
            }
            ArrayDeque<FieldNode> fieldsToRemove = new ArrayDeque<FieldNode>();
            for (FieldNode field : targetClass.fields) {
                if (!field.name.contains("visualSpeed")) continue;
                fieldsToRemove.push(field);
            }
            while (!fieldsToRemove.isEmpty()) {
                FieldNode pop = (FieldNode)fieldsToRemove.pop();
                targetClass.fields.remove(pop);
            }
        }
        if (targetClassJavaName.equals("HydraulicPressRenderer") || targetClassJavaName.equals("CogCrankRenderer") || targetClassJavaName.equals("IndustrialFanRenderer")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass, thingy -> {
                AbstractInsnNode retval = thingy;
                if (thingy.getType() == 5 && thingy.getOpcode() == 182) {
                    MethodInsnNode translateInstruction = (MethodInsnNode)thingy;
                    if (translateInstruction.owner.equals("net/createmod/catnip/render/SuperByteBuffer")) {
                        retval = translateInstruction.name.equals("translate") && translateInstruction.desc.contains("Lnet/createmod/catnip/render/SuperByteBuffer") ? new MethodInsnNode(185, "net/createmod/catnip/render/SuperByteBuffer", "translate", "(DDD)Ldev/engine_room/flywheel/lib/transform/Translate;") : (translateInstruction.name.equals("translate") && translateInstruction.desc.contains("Ljava/lang/Object") ? new MethodInsnNode(185, "net/createmod/catnip/render/SuperByteBuffer", "translate", "(Lnet/minecraft/world/phys/Vec3;)Ldev/engine_room/flywheel/lib/transform/Translate;") : (translateInstruction.name.equals("rotateCentered") && translateInstruction.desc.equals("(Lnet/minecraft/core/Direction;F)Lnet/createmod/catnip/render/SuperByteBuffer;") ? new MethodInsnNode(185, translateInstruction.owner, translateInstruction.name, "(FLnet/minecraft/core/Direction;)Ldev/engine_room/flywheel/lib/transform/Affine;") : new MethodInsnNode(185, translateInstruction.owner, translateInstruction.name, translateInstruction.desc)));
                    }
                }
                return retval;
            });
        }
        if (targetClassJavaName.equals("EngineRenderer")) {
            MixinConfigPlugin.dumpClass(targetClassName, targetClass, true);
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass, thingy -> {
                AbstractInsnNode retval = thingy;
                if (thingy.getOpcode() == 178 && ((FieldInsnNode)thingy).owner.equals("net/minecraft/core/Direction") && ((FieldInsnNode)thingy).name.equals("UP") && ((FieldInsnNode)thingy).desc.equals("Lnet/minecraft/core/Direction;")) {
                    return null;
                }
                if (thingy.getType() == 5 && thingy.getOpcode() == 182) {
                    MethodInsnNode translateInstruction = (MethodInsnNode)thingy;
                    if (translateInstruction.owner.equals("net/createmod/catnip/render/SuperByteBuffer")) {
                        retval = translateInstruction.name.equals("translate") && translateInstruction.desc.contains("Lnet/createmod/catnip/render/SuperByteBuffer") ? new MethodInsnNode(185, "net/createmod/catnip/render/SuperByteBuffer", "translate", "(DDD)Ldev/engine_room/flywheel/lib/transform/Translate;") : (translateInstruction.name.equals("translate") && translateInstruction.desc.contains("Ljava/lang/Object") ? new MethodInsnNode(185, "net/createmod/catnip/render/SuperByteBuffer", "translate", "(Lnet/minecraft/world/phys/Vec3;)Ldev/engine_room/flywheel/lib/transform/Translate;") : (translateInstruction.name.equals("rotateCentered") && translateInstruction.desc.equals("(Lnet/minecraft/core/Direction;F)Lnet/createmod/catnip/render/SuperByteBuffer;") ? new MethodInsnNode(185, translateInstruction.owner, translateInstruction.name, "(FLnet/minecraft/core/Direction;)Ldev/engine_room/flywheel/lib/transform/Affine;") : new MethodInsnNode(185, translateInstruction.owner, translateInstruction.name, translateInstruction.desc)));
                    }
                }
                return retval;
            });
            for (MethodNode m12 : targetClass.methods) {
                ArrayDeque<AbstractInsnNode> toRemove = new ArrayDeque<AbstractInsnNode>();
                for (AbstractInsnNode insn19 : m12.instructions) {
                    if (insn19.getType() != 5 || insn19.getOpcode() != 185) continue;
                    MethodInsnNode translateInstruction = (MethodInsnNode)insn19;
                    if (!translateInstruction.name.equals("rotateCentered") || !translateInstruction.desc.equals("(FLnet/minecraft/core/Direction;)Ldev/engine_room/flywheel/lib/transform/Affine;")) continue;
                    m12.instructions.insertBefore((AbstractInsnNode)translateInstruction, (AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/core/Direction", "UP", "Lnet/minecraft/core/Direction;"));
                }
                InstructionFixers.removeAllInstructions(targetClass, m12, toRemove);
            }
        }
        if (mixinJavaName.equals("FlywheelBlock")) {
            targetClass.signature = targetClass.signature.replace("uwu/lopyluna/create_dd/block/BlockProperties/flywheel/FlywheelBlockEntity", "com/landscapesreimagined/ddtocreate6/replaced/BlockEntities/FlywheelBlockEntity");
            for (MethodNode m13 : targetClass.methods) {
                m13.signature = m13.signature.replace("uwu/lopyluna/create_dd/block/BlockProperties/flywheel/FlywheelBlockEntity", "com/landscapesreimagined/ddtocreate6/replaced/BlockEntities/FlywheelBlockEntity");
            }
        }
        if (mixinJavaName.equals("GeneralFixerMultiTargetMixin")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (mixinJavaName.equals("SequencedCraftingFixers")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (mixinJavaName.equals("IndustrialFanTypeProcessingInnerClassesFixer")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
        if (mixinJavaName.equals("LongNameMultiTarget")) {
            MixinConfigPlugin.executeAllNormalInstructionFixers(targetClass);
        }
    }

    private static void executeAllNormalInstructionFixers(ClassNode targetClass) {
        InstructionFixers.applyStaticInterfaceMoves(targetClass);
        for (FieldNode f : targetClass.fields) {
            InstructionFixers.applyFieldClassMoves(f, targetClass);
            InstructionFixers.applyStaticFieldClassMoves(f, targetClass);
        }
        for (MethodNode m : targetClass.methods) {
            InstructionFixers.applyStaticMethodClassMoves(m, targetClass);
            for (AbstractInsnNode insn : m.instructions) {
                InstructionFixers.applyStaticInsnClassMoves(insn, m);
            }
        }
    }

    private static void executeAllNormalInstructionFixers(ClassNode targetClass, Function<AbstractInsnNode, AbstractInsnNode> executeOnAllInsnsAfterTransformation) {
        InstructionFixers.applyStaticInterfaceMoves(targetClass);
        for (FieldNode f : targetClass.fields) {
            InstructionFixers.applyFieldClassMoves(f, targetClass);
            InstructionFixers.applyStaticFieldClassMoves(f, targetClass);
        }
        for (MethodNode m : targetClass.methods) {
            InstructionFixers.applyStaticMethodClassMoves(m, targetClass);
            ArrayDeque<AbstractInsnNode> toDelete = new ArrayDeque<AbstractInsnNode>();
            for (AbstractInsnNode insn : m.instructions) {
                InstructionFixers.applyStaticInsnClassMoves(insn, m);
                AbstractInsnNode beforeInsn = executeOnAllInsnsAfterTransformation.apply(insn);
                if (beforeInsn == null) {
                    toDelete.push(insn);
                    continue;
                }
                if (insn == beforeInsn) continue;
                m.instructions.insertBefore(insn, beforeInsn);
                toDelete.push(insn);
            }
            InstructionFixers.removeAllInstructions(targetClass, m, toDelete);
        }
    }

    private static void dumpClass(String targetClassName, ClassNode targetClass, boolean before) {
    }

    private static void writeDumpFile(String targetClassName, String classInstructions) {
    }

    public static String insnToString(AbstractInsnNode instruction, MethodNode method) {
        StringBuilder builder = new StringBuilder();
        builder.append("instruction: ").append(instruction.getOpcode());
        if (instruction.getOpcode() != -1) {
            builder.append(" hex: ").append(Integer.toHexString(instruction.getOpcode()));
        }
        builder.append(" type: ").append(instruction.getType());
        if (instruction.getType() == 3) {
            if (instruction.getOpcode() == 187) {
                builder.append(" New");
            }
            builder.append(" Type: ").append(((TypeInsnNode)instruction).desc);
        } else if (instruction.getType() == 2) {
            VarInsnNode varInsn = (VarInsnNode)instruction;
            LocalVariableNode localVariableNode = (LocalVariableNode)method.localVariables.get(varInsn.var);
            if (localVariableNode != null) {
                builder.append(" Var: ").append(localVariableNode.name).append(", Desc: ").append(localVariableNode.desc).append(", signature: ").append(localVariableNode.signature);
            }
        } else if (instruction.getType() == 8) {
            LabelNode label = (LabelNode)instruction;
            builder.append(" Label: ").append(label.getLabel());
        } else if (instruction.getType() == 9) {
            assert (instruction instanceof LdcInsnNode);
            LdcInsnNode ldcInsnNode = (LdcInsnNode)instruction;
            builder.append(" LDC: ").append(ldcInsnNode.cst);
        } else if (instruction.getType() == 15) {
            if (instruction instanceof LineNumberNode) {
                LineNumberNode lnn = (LineNumberNode)instruction;
                builder.append(" Line: ").append(lnn.line);
            }
        } else if (instruction.getType() == 5) {
            MethodInsnNode methodNode = (MethodInsnNode)instruction;
            builder.append(" Method: ").append(methodNode.name).append(", Desc: ").append(methodNode.desc).append(", Owner: ").append(methodNode.owner);
        } else if (instruction instanceof InvokeDynamicInsnNode) {
            InvokeDynamicInsnNode idin = (InvokeDynamicInsnNode)instruction;
            builder.append(" Invoke Dynamic: ").append(idin.name).append(", Desc: ").append(idin.desc);
        }
        return builder.toString();
    }

    public static void printInstruction(AbstractInsnNode instruction, MethodNode method) {
        String toPrint = MixinConfigPlugin.insnToString(instruction, method);
        System.out.println(toPrint);
    }

    public static void printInstruction(AbstractInsnNode instruction) {
        System.out.print("instruction: " + instruction.getOpcode() + " type: " + instruction.getType());
        if (instruction.getType() == 8) {
            LabelNode label = (LabelNode)instruction;
            System.out.println(" Label: " + label.getLabel());
        }
        if (instruction.getType() == 9) {
            assert (instruction instanceof LdcInsnNode);
            LdcInsnNode ldcInsnNode = (LdcInsnNode)instruction;
            System.out.println(" LDC: " + ldcInsnNode.cst);
        } else if (instruction.getType() == 5) {
            MethodInsnNode methodNode = (MethodInsnNode)instruction;
            System.out.println(" Method: " + methodNode.name + ", Desc: " + methodNode.desc + ", Owner: " + methodNode.owner);
        } else if (instruction instanceof InvokeDynamicInsnNode) {
            InvokeDynamicInsnNode idin = (InvokeDynamicInsnNode)instruction;
            System.out.println(" Invoke Dynamic: " + idin.name + ", Desc: " + idin.desc);
        } else {
            System.out.println();
        }
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

