/*
 * Decompiled with CFR 0.152.
 */
package com.landscapesreimagined.ddtocreate6.mixin;

import com.landscapesreimagined.ddtocreate6.replaced.DDStress;
import com.landscapesreimagined.ddtocreate6.util.mixin.StressValueProvider;
import com.simibubi.create.api.stress.BlockStressValues;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import uwu.lopyluna.create_dd.configs.DDConfigBase;
import uwu.lopyluna.create_dd.configs.DDConfigs;
import uwu.lopyluna.create_dd.configs.client.DDClient;
import uwu.lopyluna.create_dd.configs.common.DDCommon;
import uwu.lopyluna.create_dd.configs.server.DDServer;

@Mixin(value={DDConfigs.class}, remap=false)
public abstract class DDConfigsMixin {
    @Shadow
    private static DDClient client;
    @Shadow
    private static DDCommon common;
    @Shadow
    private static DDServer server;
    @Shadow
    @Final
    private static Map<ModConfig.Type, DDConfigBase> CONFIGS;

    @Shadow
    private static <T extends DDConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        return null;
    }

    @Overwrite
    public static void register(ModLoadingContext context) {
        client = DDConfigsMixin.register(DDClient::new, ModConfig.Type.CLIENT);
        common = DDConfigsMixin.register(DDCommon::new, ModConfig.Type.COMMON);
        server = DDConfigsMixin.register(DDServer::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, DDConfigBase> pair : CONFIGS.entrySet()) {
            context.registerConfig(pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
        DDStress stress = ((StressValueProvider)DDConfigs.server().kinetics).getDdtocreate6$stressValues();
        BlockStressValues.IMPACTS.registerProvider(stress::getImpactSupplier);
        BlockStressValues.CAPACITIES.registerProvider(stress::getCapacitySupplier);
        BlockStressValues.RPM.registerProvider(stress::getGeneratedRPM);
    }
}

