/*
 * Decompiled with CFR 0.152.
 */
package com.landscapesreimagined.ddtocreate6.mixin.BlockFixers.blockEntities;

import com.landscapesreimagined.ddtocreate6.util.mixin.FlywheelAccessor;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import uwu.lopyluna.create_dd.block.BlockProperties.flywheel.FlywheelBlockEntity;

@Mixin(value={FlywheelBlockEntity.class}, remap=false)
public abstract class FlywheelBlockEntityMixin
extends GeneratingKineticBlockEntity
implements FlywheelAccessor {
    @Shadow
    private float generatedCapacity;
    @Shadow
    private float generatedSpeed;
    @Shadow
    private int stoppingCooldown;
    @Shadow
    private float angle;
    @Unique
    LerpedFloat visualSpeed = LerpedFloat.linear();

    public FlywheelBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public float generatedCapacity() {
        return this.generatedCapacity;
    }

    @Override
    public float generatedSpeed() {
        return this.generatedSpeed;
    }

    @Override
    public int stoppingCooldown() {
        return this.stoppingCooldown;
    }

    @Override
    public LerpedFloat visualSpeed() {
        return this.visualSpeed;
    }

    @Override
    public float angle() {
        return this.angle;
    }

    @Overwrite
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.generatedSpeed = compound.m_128457_("GeneratedSpeed");
        this.generatedCapacity = compound.m_128457_("GeneratedCapacity");
        this.stoppingCooldown = compound.m_128451_("Cooldown");
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.visualSpeed.chase((double)this.getGeneratedSpeed(), 0.03125, LerpedFloat.Chaser.EXP);
        }
    }

    @Overwrite
    public void tick() {
        super.tick();
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            float targetSpeed = this.isVirtual() ? this.speed : this.getGeneratedSpeed();
            this.visualSpeed.updateChaseTarget(targetSpeed);
            this.visualSpeed.tickChaser();
            this.angle += this.visualSpeed.getValue() * 3.0f / 10.0f;
            this.angle %= 360.0f;
        } else {
            if (this.getGeneratedSpeed() != 0.0f && this.getSpeed() == 0.0f) {
                this.updateGeneratedRotation();
            }
            if (this.stoppingCooldown != 0) {
                --this.stoppingCooldown;
                if (this.stoppingCooldown == 0) {
                    this.generatedCapacity = 0.0f;
                    this.generatedSpeed = 0.0f;
                    this.updateGeneratedRotation();
                }
            }
        }
    }
}

