/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import appeng.client.gui.widgets.ITooltip;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import widgets.SEIcon;
import widgets.SEIconButton;

public class SEToggleButton
extends SEIconButton
implements ITooltip {
    private final Listener listener;
    private final SEIcon iconOn;
    private final SEIcon iconOff;
    private List<Component> tooltipOn = Collections.emptyList();
    private List<Component> tooltipOff = Collections.emptyList();
    private boolean state;

    public SEToggleButton(SEIcon on, SEIcon off, Component displayName, Component displayHint, Listener listener, boolean state) {
        this(on, off, listener);
        this.setTooltipOn(List.of(displayName, displayHint));
        this.setTooltipOff(List.of(displayName, displayHint));
        this.state = state;
    }

    public SEToggleButton(SEIcon on, SEIcon off, Component onName, Component onHint, Component offName, Component offHint, Listener listener, boolean state) {
        this(on, off, listener);
        this.setTooltipOn(List.of(onName, onHint));
        this.setTooltipOff(List.of(offName, offHint));
        this.state = state;
    }

    public SEToggleButton(SEIcon on, SEIcon off, Listener listener) {
        super(null);
        this.iconOn = on;
        this.iconOff = off;
        this.listener = listener;
    }

    public void setTooltipOn(List<Component> lines) {
        this.tooltipOn = lines;
    }

    public void setTooltipOff(List<Component> lines) {
        this.tooltipOff = lines;
    }

    public void m_5691_() {
        this.listener.onChange(!this.state);
    }

    public void setState(boolean isOn) {
        this.state = isOn;
    }

    @Override
    protected SEIcon getIcon() {
        return this.state ? this.iconOn : this.iconOff;
    }

    public boolean getState() {
        return this.state;
    }

    @Override
    public List<Component> getTooltipMessage() {
        return this.state ? this.tooltipOn : this.tooltipOff;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return super.isTooltipAreaVisible() && !this.getTooltipMessage().isEmpty();
    }

    @FunctionalInterface
    public static interface Listener {
        public void onChange(boolean var1);
    }
}

