/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import appeng.client.gui.style.Blitter;
import block.CannonInterface;
import core.Registration;
import java.util.function.Consumer;
import lib.SEUtils;
import lib.TerminalListData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SETerminalButton
extends AbstractWidget {
    private final Blitter buttonBg;
    private final Blitter buttonBgSelected;
    private final Consumer<Integer> onClickCallback;
    private TerminalListData data = null;
    private int itemIndex = -1;
    private boolean isSelected = false;
    private static final int TEXT_COLOR_NORMAL = 4210259;

    public SETerminalButton(int x, int y, int width, int height, Blitter buttonBg, Blitter buttonBgSelected, Consumer<Integer> onClickCallback) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.buttonBg = buttonBg;
        this.buttonBgSelected = buttonBgSelected;
        this.onClickCallback = onClickCallback;
    }

    public void setButtonData(TerminalListData data, int index) {
        this.data = data;
        this.itemIndex = index;
        if (data != null) {
            this.f_93624_ = true;
            this.f_93623_ = true;
            this.m_257936_();
        } else {
            this.m_93666_((Component)Component.m_237119_());
            this.f_93624_ = false;
            this.f_93623_ = false;
        }
    }

    public void clearData() {
        this.data = null;
        this.itemIndex = -1;
        this.isSelected = false;
        this.m_93666_((Component)Component.m_237119_());
        this.f_93624_ = false;
        this.f_93623_ = false;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean hasData() {
        return this.data != null && this.itemIndex >= 0;
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (this.hasData() && this.onClickCallback != null) {
            this.onClickCallback.accept(this.itemIndex);
        }
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.hasData()) {
            return;
        }
        boolean shouldHighlight = this.f_93622_ || this.isSelected;
        Blitter blitter = shouldHighlight ? this.buttonBgSelected : this.buttonBg;
        blitter.dest(this.m_252754_(), this.m_252907_()).blit(guiGraphics);
        this.renderItemIcon(guiGraphics);
        int squareEnd = this.m_252754_() + 2 + 8;
        int iconStart = this.m_252754_() + this.m_5711_() - 12;
        int titleMaxWidth = iconStart - squareEnd - 2;
        this.renderStatusIcon(this.m_252754_() + 4, this.m_252907_() + 3, this.parseStateColor(this.data.state()), guiGraphics);
        this.renderText(this.handleSchematicName(this.data.schematicName()), squareEnd, this.m_252907_() + 2, false, 0.8f, null, titleMaxWidth, guiGraphics);
        String pos = SEUtils.capitalizeFirstLetter(this.data.dimension()) + " @ " + this.data.cannonPos().m_123344_();
        this.renderText(pos, this.m_252754_() + 2, this.m_252907_() + 12, false, 0.8f, null, 0, guiGraphics);
    }

    private void renderStatusIcon(int x, int y, int color, GuiGraphics guiGraphics) {
        int size = 3;
        guiGraphics.m_280509_(x, y, x + size, y + size, color);
    }

    private void renderText(String text, int x, int y, boolean dropShadow, float scale, Integer color, int maxWidth, GuiGraphics guiGraphics) {
        Font font = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        int textColor = color != null ? color : 4210259;
        int scaledX = (int)((float)x / scale);
        int scaledY = (int)((float)y / scale);
        int realMaxWidth = maxWidth > 0 ? maxWidth : this.m_5711_() - 8;
        int scaledMaxWidth = (int)((float)realMaxWidth / scale);
        this.renderText(guiGraphics, font, text, scaledX, scaledY, scaledMaxWidth, textColor, dropShadow);
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderText(GuiGraphics guiGraphics, Font font, String text, int x, int y, int maxWidth, int color, boolean dropShadow) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Object displayText = text;
        if (font.m_92895_(text) > maxWidth) {
            displayText = font.m_92834_(text, maxWidth - font.m_92895_("...")) + "...";
        }
        guiGraphics.m_280056_(font, (String)displayText, x, y, color, dropShadow);
    }

    private void renderItemIcon(GuiGraphics guiGraphics) {
        ItemStack item;
        if (this.data == null) {
            return;
        }
        ItemStack itemStack = item = this.data.type() == SEUtils.InterfaceType.PART ? ((Item)Registration.CANNON_INTERFACE_PART_ITEM.get()).m_7968_() : ((CannonInterface)((Object)Registration.CANNON_INTERFACE.get())).m_5456_().m_7968_();
        if (item.m_41619_()) {
            return;
        }
        int iconX = 0;
        int iconY = 0;
        float scale = 0.75f;
        if (this.data.type() == SEUtils.InterfaceType.BLOCK) {
            iconX = this.m_252754_() + this.m_5711_() - 14;
            iconY = this.m_252907_() + 1;
        } else {
            iconX = this.m_252754_() + this.m_5711_() - 14;
            iconY = this.m_252907_();
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)iconX, (float)iconY, 0.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280480_(item, 0, 0);
        guiGraphics.m_280168_().m_85849_();
    }

    private void m_257936_() {
        String tooltipText = this.data.status() == null || this.data.status().isEmpty() ? "Status: " + Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.missing_cannon").getString() : (this.data.schematicName() == null || this.data.schematicName().isEmpty() ? "Status: " + Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.schematic_name").getString() : "Status: " + SEUtils.formatCannonStatus(this.data.status()).getString());
        this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)tooltipText)));
    }

    public boolean m_142518_() {
        return this.hasData();
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    private String handleSchematicName(String name) {
        if (name == null || name.isEmpty()) {
            return Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.schematic_name").getString();
        }
        return name;
    }

    private int parseStateColor(String state) {
        return switch (state) {
            case "PAUSED" -> -10240;
            case "RUNNING" -> -15073536;
            case "STOPPED" -> -2621433;
            default -> -2621433;
        };
    }
}

