/*
 * Decompiled with CFR 0.152.
 */
package screen;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.menu.AEBaseMenu;
import java.util.ArrayList;
import java.util.List;
import lib.TerminalListData;
import menu.CannonInterfaceTerminalMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import network.PacketHandler;
import network.payloads.OpenCannonInterfacePacket;
import widgets.SETerminalButton;

public class CannonInterfaceTerminalScreen
extends AEBaseScreen<CannonInterfaceTerminalMenu> {
    private final Blitter buttonBg;
    private final Blitter buttonBgSelected;
    private Scrollbar scrollbar;
    private Rect2i bounds = new Rect2i(0, 0, 0, 0);
    private static final int VISIBLE_ITEMS = 6;
    private static final int ITEM_HEIGHT = 22;
    private static final int ITEM_WIDTH = 104;
    private static final int ITEM_SPACING = 1;
    private static final int START_X = 8;
    private static final int START_Y = 19;
    private final List<SETerminalButton> cannonButtons = new ArrayList<SETerminalButton>();
    private List<TerminalListData> data = new ArrayList<TerminalListData>();
    private int selectedIndex = -1;
    private BlockPos terminalPos = BlockPos.f_121853_;

    public CannonInterfaceTerminalScreen(CannonInterfaceTerminalMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.f_97726_ = 128;
        this.f_97727_ = 164;
        this.scrollbar = this.widgets.addScrollBar("scrollbar", Scrollbar.DEFAULT);
        this.buttonBg = style.getImage("cannonListButton");
        this.buttonBgSelected = style.getImage("cannonListButtonSelected");
    }

    protected void m_7856_() {
        super.m_7856_();
        this.cannonButtons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.cannonButtons.clear();
        this.createCannonButtons();
        this.updateScrollbar();
        this.updateButtonsContent();
    }

    private void createCannonButtons() {
        for (int i = 0; i < 6; ++i) {
            int buttonX = this.f_97735_ + 8;
            int buttonY = this.f_97736_ + 19 + i * 23;
            SETerminalButton button = new SETerminalButton(buttonX, buttonY, 104, 22, this.buttonBg, this.buttonBgSelected, this::onCannonButtonClicked);
            this.cannonButtons.add(button);
            this.m_142416_((GuiEventListener)button);
        }
    }

    private void updateScrollbar() {
        if (this.data == null || this.data.isEmpty()) {
            this.scrollbar.setRange(0, 0, 1);
            return;
        }
        int maxScrollValue = Math.max(0, this.data.size() - 6);
        this.scrollbar.setRange(0, maxScrollValue, 2);
    }

    private void updateButtonsContent() {
        if (this.data == null) {
            for (SETerminalButton button : this.cannonButtons) {
                button.clearData();
                button.setSelected(false);
            }
            return;
        }
        int maxScroll = Math.max(0, this.data.size() - 6);
        int scrollOffset = Math.min(this.scrollbar.getCurrentScroll(), maxScroll);
        for (int i = 0; i < 6; ++i) {
            SETerminalButton button = this.cannonButtons.get(i);
            int itemIndex = i + scrollOffset;
            if (itemIndex < this.data.size()) {
                TerminalListData terminalData = this.data.get(itemIndex);
                button.setButtonData(terminalData, itemIndex);
                button.setSelected(itemIndex == this.selectedIndex);
                continue;
            }
            button.clearData();
        }
    }

    private void onCannonButtonClicked(int itemIndex) {
        if (this.data == null || itemIndex < 0 || itemIndex >= this.data.size()) {
            return;
        }
        this.selectedIndex = itemIndex;
        TerminalListData selectedCannon = this.data.get(itemIndex);
        this.updateButtonsContent();
        PacketHandler.sendToServer(new OpenCannonInterfacePacket(selectedCannon.cannonPos(), this.terminalPos));
    }

    protected Component getGuiDisplayName(Component in) {
        return super.getGuiDisplayName(in);
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawFG(guiGraphics, offsetX, offsetY, mouseX, mouseY);
        this.updateButtonsContent();
    }

    public void receiveData(List<TerminalListData> newData, BlockPos terminalPos) {
        List<TerminalListData> list = this.data = newData != null ? new ArrayList<TerminalListData>(newData) : new ArrayList();
        if (this.selectedIndex >= this.data.size()) {
            this.selectedIndex = -1;
        }
        this.terminalPos = terminalPos;
        this.updateScrollbar();
        this.updateButtonsContent();
    }
}

