/*
 * Decompiled with CFR 0.152.
 */
package screen;

import appeng.api.stacks.AEItemKey;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.menu.AEBaseMenu;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import lib.CannonInterfaceClientState;
import lib.SEUtils;
import menu.CannonInterfaceMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import network.PacketHandler;
import network.payloads.CannonInterfaceConfigPacket;
import network.payloads.CannonStatePacket;
import network.payloads.ReturnToTerminalPacket;
import widgets.SEIcon;
import widgets.SESimpleIconButton;
import widgets.SEToggleButton;

public class CannonInterfaceScreen
extends AEBaseScreen<CannonInterfaceMenu> {
    private AEItemKey item;
    private final SEToggleButton toggleGunpowderCrafting;
    private final SEToggleButton toggleCrafting;
    private final SEToggleButton toggleGunpowder;
    private SESimpleIconButton stop;
    private SEToggleButton playPause;
    private boolean craftingState;
    private boolean gunpowderState;
    private boolean gunpowderCraftingState;
    private BlockPos terminal = null;
    private SESimpleIconButton backButton = null;
    private static final int MAX_TEXT_WIDTH = 164;

    public CannonInterfaceScreen(CannonInterfaceMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.f_97726_ = 176;
        this.f_97727_ = 182;
        if (CannonInterfaceClientState.hasState()) {
            this.gunpowderState = CannonInterfaceClientState.getGunpowderState();
            this.craftingState = CannonInterfaceClientState.getCraftingState();
            this.gunpowderCraftingState = CannonInterfaceClientState.getGunpowderCraftingState();
            CannonInterfaceClientState.reset();
        }
        this.toggleCrafting = new SEToggleButton(SEIcon.CRAFTING_ALLOW, SEIcon.CRAFTING_DENY, (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.disable_gunpowder_crafting"), (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.disable_gunpowder_crafting_hint"), (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.enable_gunpowder_crafting"), (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.enable_gunpowder_crafting_hint"), state -> this.sendState("craftingState", state), this.craftingState);
        this.toggleGunpowder = new SEToggleButton(SEIcon.GUNPOWDER_ALLOW, SEIcon.GUNPOWDER_DENY, (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.disable_gunpowder"), (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.disable_gunpowder_hint"), (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.enable_gunpowder"), (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.enable_gunpowder_hint"), state -> this.sendState("gunpowderState", state), this.gunpowderState);
        this.toggleGunpowderCrafting = new SEToggleButton(SEIcon.GUNPOWDER_CRAFTING_ALLOW, SEIcon.GUNPOWDER_CRAFTING_DENY, (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.disable_gunpowder_crafting"), (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.disable_gunpowder_crafting_hint"), (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.enable_gunpowder_crafting"), (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.enable_gunpowder_crafting_hint"), state -> this.sendState("gunpowderCraftingState", state), this.gunpowderCraftingState);
        this.addToLeftToolbar(this.toggleCrafting);
        this.addToLeftToolbar(this.toggleGunpowder);
        this.addToLeftToolbar(this.toggleGunpowderCrafting);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.updateSchematicName(null);
        int centerX = this.f_97735_ + this.f_97726_ / 2 - 8;
        this.playPause = new SEToggleButton(SEIcon.PAUSE, SEIcon.PLAY, (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.pause"), (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.pause_hint"), (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.play"), (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.play_hint"), state -> this.sendCannonState(state, false), false);
        this.playPause.m_264152_(centerX - 16, this.f_97736_ + 56);
        this.m_142416_((GuiEventListener)this.playPause);
        this.stop = new SESimpleIconButton(SEIcon.STOP, (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.stop"), (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.stop_hint"), btn -> this.sendCannonState(false, true));
        this.stop.m_264152_(centerX + 16, this.f_97736_ + 56);
        this.m_142416_((GuiEventListener)this.stop);
        this.backButton = new SESimpleIconButton(SEIcon.BACK, (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_terminal.return_terminal"), (Component)Component.m_237119_(), btn -> PacketHandler.sendToServer(new ReturnToTerminalPacket(this.terminal)));
        this.backButton.m_264152_(this.f_97735_ + this.f_97726_ - 28, this.f_97736_ - 10);
        this.backButton.f_93624_ = this.terminal != null;
        this.m_142416_((GuiEventListener)this.backButton);
    }

    public void sendState(String config, boolean state) {
        PacketHandler.sendToServer(new CannonInterfaceConfigPacket(state, config));
    }

    public void sendCannonState(boolean state, boolean isStop) {
        if (isStop) {
            SchematicannonBlockEntity.State stoppedState = SchematicannonBlockEntity.State.STOPPED;
            PacketHandler.sendToServer(new CannonStatePacket(stoppedState.toString()));
            return;
        }
        this.playPause.setState(state);
        SchematicannonBlockEntity.State cannonState = state ? SchematicannonBlockEntity.State.RUNNING : SchematicannonBlockEntity.State.PAUSED;
        PacketHandler.sendToServer(new CannonStatePacket(cannonState.toString()));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int centerX = this.f_97735_ + 147;
        int centerY = this.f_97736_ + 22;
        if (this.item != null && !this.item.toStack().m_41619_()) {
            guiGraphics.m_280480_(this.item.toStack(), centerX, centerY);
        }
        if (mouseX >= centerX && mouseX < centerX + 16 && mouseY >= centerY && mouseY < centerY + 16) {
            if (this.item == null || this.item.toStack().m_41619_()) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.no_item"), mouseX, mouseY);
            } else {
                guiGraphics.m_280557_(this.f_96547_, this.item.getDisplayName(), mouseX, mouseY);
            }
        }
    }

    public void updateStates(boolean gunpowderState, boolean craftingState, boolean gunpowderCraftingState) {
        this.gunpowderState = gunpowderState;
        this.craftingState = craftingState;
        if (this.toggleGunpowder != null) {
            this.toggleGunpowder.setState(gunpowderState);
        }
        if (this.toggleCrafting != null) {
            this.toggleCrafting.setState(craftingState);
        }
        if (this.toggleGunpowderCrafting != null) {
            this.toggleGunpowderCrafting.setState(gunpowderCraftingState);
        }
    }

    public void updateSchematicName(String schematicName) {
        MutableComponent text = schematicName == null || schematicName.isEmpty() ? Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.schematic_name") : Component.m_237113_((String)schematicName);
        Component limitedText = this.limitTextWidth((Component)text, 164);
        this.setTextContent("schematic_text", limitedText);
    }

    private Component limitTextWidth(Component originalText, int maxWidth) {
        String textString = originalText.getString();
        if (this.f_96547_.m_92895_(textString) <= maxWidth) {
            return originalText;
        }
        String ellipsis = "...";
        int ellipsisWidth = this.f_96547_.m_92895_(ellipsis);
        int availableWidth = maxWidth - ellipsisWidth;
        String truncatedText = this.f_96547_.m_92834_(textString, availableWidth);
        return Component.m_237113_((String)(truncatedText + ellipsis));
    }

    public void updateStatusMsg(String statusMsg) {
        MutableComponent text = statusMsg == null || statusMsg.isEmpty() ? Component.m_237115_((String)"gui.schematicenergistics.cannon_interface.missing_cannon") : SEUtils.formatCannonStatus(statusMsg);
        Component limitedText = this.limitTextWidth((Component)text, 164);
        this.setTextContent("status_text", limitedText);
    }

    public void updateCannonState(String state) {
        boolean cState = !"PAUSED".equals(state);
        this.playPause.setState(cState);
    }

    public void updateScreenItem(CompoundTag data, String schematicName, String statusMsg, String state, BlockPos terminalPos) {
        AEItemKey item = AEItemKey.fromTag((CompoundTag)data);
        this.item = item != null ? item : AEItemKey.of((ItemStack)ItemStack.f_41583_);
        this.terminal = terminalPos;
        if (this.backButton != null) {
            this.backButton.f_93624_ = this.terminal != null;
        }
        this.updateSchematicName(schematicName);
        this.updateStatusMsg(statusMsg);
        this.updateCannonState(state);
    }
}

