/*
 * Decompiled with CFR 0.152.
 */
package part;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractDisplayPart;
import blockentity.CannonInterfaceEntity;
import com.schematicenergistics.SchematicEnergistics;
import core.Registration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lib.SEUtils;
import lib.TerminalListData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.phys.Vec3;
import part.CannonInterfacePart;

public class CannonInterfaceTerminal
extends AbstractDisplayPart {
    @PartModels
    public static ResourceLocation MODEL_BASE = SchematicEnergistics.makeId("part/display_base");
    @PartModels
    private static final ResourceLocation MODEL_TERMINAL_ON = SchematicEnergistics.makeId("part/cannon_terminal_on");
    @PartModels
    private static final ResourceLocation MODEL_TERMINAL_OFF = SchematicEnergistics.makeId("part/cannon_terminal_off");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_TERMINAL_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_TERMINAL_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_TERMINAL_ON, MODEL_STATUS_HAS_CHANNEL});

    public CannonInterfaceTerminal(IPartItem<?> partItem, boolean requireChannel) {
        super(partItem, requireChannel);
    }

    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (!player.m_20193_().m_5776_()) {
            MenuOpener.open((MenuType)((MenuType)Registration.CANNON_INTERFACE_TERMINAL_MENU.get()), (Player)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public List<TerminalListData> getCannonInterfaces() {
        TerminalListData data;
        String status;
        String schematicName;
        ArrayList<TerminalListData> result = new ArrayList<TerminalListData>();
        IGridNode node = this.getMainNode().getNode();
        if (node == null) {
            return result;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return result;
        }
        Set entities = grid.getMachines(CannonInterfaceEntity.class);
        Set parts = grid.getMachines(CannonInterfacePart.class);
        String dimension = this.getLevel().m_46472_().m_135782_().toString().split(":")[1];
        for (CannonInterfaceEntity entity : entities) {
            if (entity == null) continue;
            schematicName = entity.getLogic().getSchematicName();
            status = entity.getLogic().getStatusMsg();
            if (schematicName == null || schematicName.isEmpty()) {
                schematicName = "";
            }
            data = new TerminalListData(entity.m_58899_(), schematicName, SEUtils.InterfaceType.BLOCK, dimension, status, entity.getLogic().getState());
            result.add(data);
        }
        for (CannonInterfacePart part : parts) {
            if (part == null) continue;
            schematicName = part.getLogic().getSchematicName();
            status = part.getLogic().getStatusMsg();
            if (schematicName == null || schematicName.isEmpty()) {
                schematicName = "";
            }
            data = new TerminalListData(part.getBlockEntity().m_58899_(), schematicName, SEUtils.InterfaceType.PART, dimension, status, part.getLogic().getState());
            result.add(data);
        }
        return result;
    }
}

