/*
 * Decompiled with CFR 0.152.
 */
package network.payloads;

import java.util.List;
import java.util.function.Supplier;
import lib.TerminalListData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import screen.CannonInterfaceTerminalScreen;

public class TerminalListClientPacket {
    private final List<TerminalListData> data;
    private final BlockPos terminalPos;

    public TerminalListClientPacket(List<TerminalListData> data, BlockPos terminalPos) {
        this.data = data;
        this.terminalPos = terminalPos;
    }

    public static TerminalListClientPacket decode(FriendlyByteBuf buf) {
        List data = buf.m_236845_(TerminalListData::fromBuffer);
        BlockPos pos = buf.m_130135_();
        return new TerminalListClientPacket(data, pos);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_236828_(this.data, (b, e) -> e.toBuffer((FriendlyByteBuf)b));
        buf.m_130064_(this.terminalPos);
    }

    public static void handle(TerminalListClientPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> TerminalListClientPacket.handleClient(packet));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(TerminalListClientPacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof CannonInterfaceTerminalScreen) {
            CannonInterfaceTerminalScreen screen2 = (CannonInterfaceTerminalScreen)screen;
            screen2.receiveData(packet.data, packet.terminalPos);
        }
    }
}

