/*
 * Decompiled with CFR 0.152.
 */
package network.payloads;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import core.Registration;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import part.CannonInterfaceTerminal;

public class ReturnToTerminalPacket {
    private final BlockPos terminalPos;

    public ReturnToTerminalPacket(BlockPos terminalPos) {
        this.terminalPos = terminalPos;
    }

    public static ReturnToTerminalPacket decode(FriendlyByteBuf buf) {
        BlockPos terminalPos = buf.m_130135_();
        return new ReturnToTerminalPacket(terminalPos);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.terminalPos);
    }

    public static void handle(ReturnToTerminalPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (blockEntity = player.m_9236_().m_7702_(packet.terminalPos)) instanceof IPartHost) {
                IPartHost host = (IPartHost)blockEntity;
                for (Direction direction : Direction.values()) {
                    IPart part = host.getPart(direction);
                    if (!(part instanceof CannonInterfaceTerminal)) continue;
                    CannonInterfaceTerminal terminal = (CannonInterfaceTerminal)part;
                    MenuLocator menuLocators = MenuLocators.forPart((AEBasePart)terminal);
                    MenuOpener.open((MenuType)((MenuType)Registration.CANNON_INTERFACE_TERMINAL_MENU.get()), (Player)player, (MenuLocator)menuLocators);
                    return;
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

