/*
 * Decompiled with CFR 0.152.
 */
package network.payloads;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import java.util.function.Supplier;
import logic.ICannonInterfaceHost;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import part.CannonInterfacePart;

public class OpenCannonInterfacePacket {
    private final BlockPos cannonBlockPos;
    private final BlockPos terminalBlockPos;

    public OpenCannonInterfacePacket(BlockPos cannonBlockPos, BlockPos terminalBlockPos) {
        this.cannonBlockPos = cannonBlockPos;
        this.terminalBlockPos = terminalBlockPos;
    }

    public static OpenCannonInterfacePacket decode(FriendlyByteBuf buf) {
        BlockPos cannonPos = buf.m_130135_();
        BlockPos terminalPos = buf.m_130135_();
        return new OpenCannonInterfacePacket(cannonPos, terminalPos);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.cannonBlockPos);
        buf.m_130064_(this.terminalBlockPos);
    }

    public static void handle(OpenCannonInterfacePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player instanceof ServerPlayer) {
                BlockEntity blockEntity = player.m_9236_().m_7702_(packet.cannonBlockPos);
                if (blockEntity instanceof ICannonInterfaceHost) {
                    ICannonInterfaceHost host = (ICannonInterfaceHost)blockEntity;
                    host.getLogic().setTerminalPos(packet.terminalBlockPos);
                    MenuLocator locator = MenuLocators.forBlockEntity((BlockEntity)blockEntity);
                    host.openMenu((Player)player, locator);
                    return;
                }
                if (blockEntity instanceof IPartHost) {
                    IPartHost host = (IPartHost)blockEntity;
                    for (Direction direction : Direction.values()) {
                        IPart part = host.getPart(direction);
                        if (!(part instanceof CannonInterfacePart)) continue;
                        CannonInterfacePart cannonPart = (CannonInterfacePart)part;
                        cannonPart.getLogic().setTerminalPos(packet.terminalBlockPos);
                        MenuLocator locator = MenuLocators.forPart((AEBasePart)cannonPart);
                        cannonPart.openMenu((Player)player, locator);
                        return;
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

