/*
 * Decompiled with CFR 0.152.
 */
package network.payloads;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import screen.CannonInterfaceScreen;

public class CannonInterfaceSyncPacket {
    private final CompoundTag data;
    private final String schematicName;
    private final String statusMsg;
    private final String state;
    private final boolean hasTerminal;
    private final BlockPos terminalPos;

    public CannonInterfaceSyncPacket(CompoundTag data, String schematicName, String statusMsg, String state) {
        this(data, schematicName, statusMsg, state, false, BlockPos.f_121853_);
    }

    public CannonInterfaceSyncPacket(CompoundTag data, String schematicName, String statusMsg, String state, BlockPos terminalPos) {
        this(data, schematicName, statusMsg, state, true, terminalPos);
    }

    public CannonInterfaceSyncPacket(CompoundTag data, String schematicName, String statusMsg, String state, boolean hasTerminal, BlockPos terminalPos) {
        this.data = data;
        this.schematicName = schematicName;
        this.statusMsg = statusMsg;
        this.state = state;
        this.hasTerminal = hasTerminal;
        this.terminalPos = terminalPos;
    }

    public static CannonInterfaceSyncPacket fromBytes(FriendlyByteBuf buf) {
        CompoundTag data = buf.m_130260_();
        String schematicName = buf.m_130277_();
        String statusMsg = buf.m_130277_();
        String state = buf.m_130277_();
        boolean hasTerminal = buf.readBoolean();
        BlockPos terminalPos = hasTerminal ? buf.m_130135_() : BlockPos.f_121853_;
        return new CannonInterfaceSyncPacket(data, schematicName, statusMsg, state, hasTerminal, terminalPos);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.data);
        buf.m_130070_(this.schematicName);
        buf.m_130070_(this.statusMsg);
        buf.m_130070_(this.state);
        buf.writeBoolean(this.hasTerminal);
        if (this.hasTerminal) {
            buf.m_130064_(this.terminalPos);
        }
    }

    public BlockPos getTerminalPosOrNull() {
        return this.hasTerminal ? this.terminalPos : null;
    }

    public static void handle(CannonInterfaceSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> CannonInterfaceSyncPacket.handleClient(packet));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(CannonInterfaceSyncPacket packet) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof CannonInterfaceScreen) {
            CannonInterfaceScreen screen2 = (CannonInterfaceScreen)screen;
            screen2.updateScreenItem(packet.data, packet.schematicName, packet.statusMsg, packet.state, packet.getTerminalPosOrNull());
        }
    }
}

