/*
 * Decompiled with CFR 0.152.
 */
package network.payloads;

import java.util.function.Supplier;
import lib.CannonInterfaceClientState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import screen.CannonInterfaceScreen;

public class CannonInterfaceConfigClientPacket {
    private final boolean gunpowderState;
    private final boolean craftingState;
    private final boolean gunpowderCraftingState;

    public CannonInterfaceConfigClientPacket(boolean gunpowderState, boolean craftingState, boolean gunpowderCraftingState) {
        this.gunpowderState = gunpowderState;
        this.craftingState = craftingState;
        this.gunpowderCraftingState = gunpowderCraftingState;
    }

    public static CannonInterfaceConfigClientPacket fromBytes(FriendlyByteBuf buf) {
        return new CannonInterfaceConfigClientPacket(buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.gunpowderState);
        buf.writeBoolean(this.craftingState);
        buf.writeBoolean(this.gunpowderCraftingState);
    }

    public static void handle(CannonInterfaceConfigClientPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            CannonInterfaceClientState.setState(packet.gunpowderState, packet.craftingState, packet.gunpowderCraftingState);
            Minecraft mc = Minecraft.m_91087_();
            Screen patt1892$temp = mc.f_91080_;
            if (patt1892$temp instanceof CannonInterfaceScreen) {
                CannonInterfaceScreen screen = (CannonInterfaceScreen)patt1892$temp;
                screen.updateStates(packet.gunpowderState, packet.craftingState, packet.gunpowderCraftingState);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

