/*
 * Decompiled with CFR 0.152.
 */
package network;

import com.schematicenergistics.SchematicEnergistics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import network.payloads.CannonInterfaceConfigClientPacket;
import network.payloads.CannonInterfaceConfigPacket;
import network.payloads.CannonInterfaceSyncPacket;
import network.payloads.CannonStatePacket;
import network.payloads.OpenCannonInterfacePacket;
import network.payloads.ReturnToTerminalPacket;
import network.payloads.TerminalListClientPacket;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    private static final ResourceLocation CHANNEL_NAME = SchematicEnergistics.makeId("main");
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)CHANNEL_NAME, () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    private static int nextId() {
        return packetId++;
    }

    public static void init() {
        CHANNEL.registerMessage(PacketHandler.nextId(), CannonInterfaceSyncPacket.class, CannonInterfaceSyncPacket::toBytes, CannonInterfaceSyncPacket::fromBytes, CannonInterfaceSyncPacket::handle);
        CHANNEL.registerMessage(PacketHandler.nextId(), CannonInterfaceConfigPacket.class, CannonInterfaceConfigPacket::toBytes, CannonInterfaceConfigPacket::fromBytes, CannonInterfaceConfigPacket::handle);
        CHANNEL.registerMessage(PacketHandler.nextId(), CannonInterfaceConfigClientPacket.class, CannonInterfaceConfigClientPacket::toBytes, CannonInterfaceConfigClientPacket::fromBytes, CannonInterfaceConfigClientPacket::handle);
        CHANNEL.registerMessage(PacketHandler.nextId(), CannonStatePacket.class, CannonStatePacket::toBytes, CannonStatePacket::fromBytes, CannonStatePacket::handle);
        CHANNEL.registerMessage(PacketHandler.nextId(), TerminalListClientPacket.class, TerminalListClientPacket::encode, TerminalListClientPacket::decode, TerminalListClientPacket::handle);
        CHANNEL.registerMessage(PacketHandler.nextId(), OpenCannonInterfacePacket.class, OpenCannonInterfacePacket::encode, OpenCannonInterfacePacket::decode, OpenCannonInterfacePacket::handle);
        CHANNEL.registerMessage(PacketHandler.nextId(), ReturnToTerminalPacket.class, ReturnToTerminalPacket::encode, ReturnToTerminalPacket::decode, ReturnToTerminalPacket::handle);
    }

    public static <MSG> void sendToServer(MSG message) {
        CHANNEL.sendToServer(message);
    }

    public static <MSG> void sendToClient(MSG message, ServerPlayer player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), message);
    }
}

