/*
 * Decompiled with CFR 0.152.
 */
package com.schematicenergistics.mixin;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.stacks.AEItemKey;
import blockentity.CannonInterfaceEntity;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.simibubi.create.content.schematics.cannon.SchematicannonInventory;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import logic.CannonInterfaceLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import part.CannonInterfacePart;

@Mixin(value={SchematicannonBlockEntity.class})
public abstract class SchematicCannonMixin {
    @Shadow
    public SchematicannonInventory inventory;
    private CannonInterfaceLogic cannonInterface;
    @Shadow
    public ItemStack missingItem;
    @Shadow
    public SchematicannonBlockEntity.State state;
    @Shadow
    public String statusMsg;

    @Inject(method={"initializePrinter"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    protected void initializePrinter(CallbackInfo ci) {
        if (this.cannonInterface != null) {
            this.cannonInterface.setLinkedCannon((SchematicannonBlockEntity)this);
        }
    }

    @Inject(method={"findInventories"}, at={@At(value="TAIL")}, remap=false)
    public void findInventories(CallbackInfo ci) {
        Level level = ((SchematicannonBlockEntity)this).m_58904_();
        BlockPos pos = ((SchematicannonBlockEntity)this).m_58899_();
        CannonInterfaceLogic logicalHost = null;
        if (level == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            IPartHost partHost;
            IPart part;
            BlockPos neighborPos = pos.m_121945_(dir);
            BlockEntity be = level.m_7702_(neighborPos);
            if (be instanceof CannonInterfaceEntity) {
                CannonInterfaceEntity candidateInterface = (CannonInterfaceEntity)be;
                CannonInterfaceLogic logic = candidateInterface.getLogic();
                if (logic == null) continue;
                logicalHost = logic;
                break;
            }
            if (!(be instanceof IPartHost) || !((part = (partHost = (IPartHost)be).getPart(dir.m_122424_())) instanceof CannonInterfacePart)) continue;
            CannonInterfacePart cannonPart = (CannonInterfacePart)part;
            logicalHost = cannonPart.getLogic();
        }
        this.cannonInterface = logicalHost != null ? logicalHost : null;
    }

    @Inject(method={"grabItemsFromAttachedInventories"}, at={@At(value="TAIL")}, cancellable=true, remap=false)
    protected void grabItemsFromAttachedInventories(ItemRequirement.StackRequirement required, boolean simulate, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() && this.cannonInterface != null) {
            AEItemKey key = AEItemKey.of((ItemStack)required.stack);
            long neededCount = required.stack.m_41613_();
            boolean result = this.cannonInterface.request(key, neededCount, simulate);
            cir.setReturnValue((Object)result);
        }
    }

    @Inject(method={"tickPrinter"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    protected void tickPrinter(CallbackInfo ci) {
        AEItemKey key;
        if (this.cannonInterface == null) {
            return;
        }
        ItemStack blueprint = this.inventory.getStackInSlot(0);
        this.cannonInterface.setStatusMsg(this.statusMsg);
        this.cannonInterface.setState(this.state.toString());
        if (!blueprint.m_41619_() && blueprint.m_41783_() != null) {
            this.cannonInterface.setSchematicName(blueprint.m_41783_().m_128461_("File"));
        } else {
            this.cannonInterface.setSchematicName(null);
            this.cannonInterface.setItem(null);
        }
        if (this.missingItem != null && (key = AEItemKey.of((ItemStack)this.missingItem)) != this.cannonInterface.getItem()) {
            this.cannonInterface.setItem(key);
        }
        int maxStackSize = this.inventory.getStackInSlot(4).m_41741_();
        int currentAmountOnSlot = this.inventory.getStackInSlot(4).m_41613_();
        if (currentAmountOnSlot >= maxStackSize) {
            return;
        }
        int amountToRefill = maxStackSize - currentAmountOnSlot;
        if (amountToRefill <= 0) {
            return;
        }
        int insertedItems = this.cannonInterface.refill(amountToRefill);
        if (insertedItems <= 0) {
            return;
        }
        ItemStack gunpowderStack = new ItemStack((ItemLike)Items.f_42403_, insertedItems);
        this.inventory.insertItem(4, gunpowderStack, false);
    }
}

