/*
 * Decompiled with CFR 0.152.
 */
package blockentity;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEKey;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.me.helpers.MachineSource;
import com.google.common.collect.ImmutableSet;
import core.Registration;
import java.util.EnumSet;
import logic.CannonInterfaceLogic;
import logic.ICannonInterfaceHost;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import part.CannonInterfacePart;

public class CannonInterfaceEntity
extends AENetworkBlockEntity
implements IGridTickable,
ICraftingRequester,
ICannonInterfaceHost {
    @Nullable
    private CannonInterfaceLogic cannonLogic = null;
    private final IActionSource actionSource = new MachineSource((IActionHost)this);
    private boolean gunpowderCraftingState = true;
    private boolean craftingState = true;
    private boolean gunpowderState = true;

    public CannonInterfaceEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.CANNON_INTERFACE_ENTITY.get(), pos, state);
        this.getMainNode().setExposedOnSides(this.getExposedSides()).addService(IGridTickable.class, (IGridNodeService)this).addService(ICraftingRequester.class, (IGridNodeService)this).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128379_("gunpowderState", this.gunpowderState);
        data.m_128379_("craftingState", this.craftingState);
        data.m_128379_("gunpowderCraftingState", this.gunpowderCraftingState);
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.gunpowderState = data.m_128471_("gunpowderState");
        this.craftingState = data.m_128471_("craftingState");
        this.gunpowderCraftingState = data.m_128471_("gunpowderCraftingState");
    }

    public void onReady() {
        this.getMainNode().setExposedOnSides(this.getExposedSides());
        super.onReady();
    }

    public void m_142339_(Level p_155231_) {
        super.m_142339_(p_155231_);
        if (this.cannonLogic == null && this.m_58904_() != null) {
            this.cannonLogic = new CannonInterfaceLogic(this.m_58904_(), this.getMainNode(), this.actionSource, this);
            this.cannonLogic.setGunpowderState(this.gunpowderState);
            this.cannonLogic.setCraftingState(this.craftingState);
            this.cannonLogic.setGunpowderCraftingState(this.gunpowderCraftingState);
        }
    }

    private EnumSet<Direction> getExposedSides() {
        return EnumSet.allOf(Direction.class);
    }

    @Override
    public CannonInterfaceLogic getLogic() {
        return this.cannonLogic;
    }

    @Override
    @Nullable
    public CannonInterfaceEntity getEntity() {
        return this;
    }

    @Override
    @Nullable
    public CannonInterfacePart getPart() {
        return null;
    }

    @Nullable
    public IGridNode getGridNode() {
        return super.getGridNode();
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.getLogic().getRequestedJobs();
    }

    public long insertCraftedItems(ICraftingLink link, AEKey what, long amount, Actionable mode) {
        return this.getLogic().insertCraftedItems(link, what, amount, mode);
    }

    public void jobStateChange(ICraftingLink link) {
        this.getLogic().jobStateChange(link);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return this.getLogic().getTickingRequest(node);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.getLogic().tickingRequest(node, ticksSinceLastCall);
    }

    public void setConfigState(String type, boolean state) {
        switch (type) {
            case "gunpowderState": {
                this.gunpowderState = state;
                if (this.cannonLogic == null) break;
                this.cannonLogic.setGunpowderState(state);
                break;
            }
            case "craftingState": {
                this.craftingState = state;
                if (this.cannonLogic == null) break;
                this.cannonLogic.setCraftingState(state);
                break;
            }
            case "gunpowderCraftingState": {
                this.gunpowderCraftingState = state;
                if (this.cannonLogic == null) break;
                this.cannonLogic.setGunpowderCraftingState(state);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown config type: " + type);
            }
        }
        this.m_6596_();
    }

    public boolean getConfigState(String type) {
        return switch (type) {
            case "gunpowderState" -> this.gunpowderState;
            case "craftingState" -> this.craftingState;
            case "gunpowderCraftingState" -> this.gunpowderCraftingState;
            default -> throw new IllegalArgumentException("Unknown config type: " + type);
        };
    }
}

