/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.jdoc.property.AbstractProperty;
import com.probejs.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PropertyComment
extends AbstractProperty<PropertyComment> {
    private final List<String> lines = new ArrayList<String>();

    public PropertyComment() {
    }

    public PropertyComment(String ... lines) {
        this.lines.addAll(List.of(lines));
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = super.serialize();
        JsonArray linesJson = new JsonArray();
        this.lines.forEach(arg_0 -> ((JsonArray)linesJson).add(arg_0));
        object.add("lines", (JsonElement)linesJson);
        return object;
    }

    @Override
    public void deserialize(JsonObject object) {
        for (JsonElement element : object.get("lines").getAsJsonArray()) {
            this.lines.add(element.getAsString());
        }
    }

    public List<String> getLines() {
        return this.lines;
    }

    public List<String> formatLines(int indent) {
        ArrayList<String> formatted = new ArrayList<String>();
        formatted.add(Util.indent(indent) + "/**");
        this.lines.forEach(line -> formatted.add(" ".repeat(indent) + " * " + line));
        formatted.add(Util.indent(indent) + "*/");
        return formatted;
    }

    @Override
    public PropertyComment copy() {
        PropertyComment comment = new PropertyComment();
        comment.lines.addAll(this.lines);
        return comment;
    }

    @Override
    public PropertyComment merge(PropertyComment other) {
        PropertyComment comment = this.copy();
        if (!this.isEmpty()) {
            comment.lines.add("");
        }
        comment.lines.addAll(other.lines);
        return comment;
    }

    public PropertyComment add(String line) {
        this.lines.add(line);
        return this;
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyComment comment = (PropertyComment)o;
        return Objects.equals(this.lines, comment.lines);
    }

    public int hashCode() {
        return Objects.hash(this.lines);
    }
}

