/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.java.type;

import com.probejs.jdoc.java.MethodInfo;
import com.probejs.jdoc.java.type.ITypeInfo;
import com.probejs.jdoc.java.type.InfoTypeResolver;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TypeInfoClass
implements ITypeInfo {
    private final Class<?> type;

    public static boolean test(Type type) {
        return type instanceof Class;
    }

    public TypeInfoClass(Type type, Function<Type, Type> typeTransformer) {
        this.type = (Class)type;
    }

    public TypeInfoClass(Class<?> type) {
        this.type = type;
    }

    @Override
    public ITypeInfo getBaseType() {
        return this;
    }

    @Override
    public Class<?> getResolvedClass() {
        return this.type;
    }

    @Override
    public String getTypeName() {
        return MethodInfo.getRemappedOrOriginalClass(this.type);
    }

    @Override
    public ITypeInfo copy() {
        return new TypeInfoClass(this.type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean assignableFrom(ITypeInfo info) {
        if (!(info instanceof TypeInfoClass)) return false;
        TypeInfoClass clazz = (TypeInfoClass)info;
        if (!clazz.type.isAssignableFrom(this.type)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equalsTo(ITypeInfo info) {
        if (!(info instanceof TypeInfoClass)) return false;
        TypeInfoClass clazz = (TypeInfoClass)info;
        if (!clazz.type.equals(this.type)) return false;
        return true;
    }

    public List<ITypeInfo> getTypeVariables() {
        return Arrays.stream(this.type.getTypeParameters()).map(InfoTypeResolver::resolveType).collect(Collectors.toList());
    }
}

