/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api.set.mud;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.stone_zone.StoneZone;
import net.mehvahdjukaar.stone_zone.api.set.RockType;
import net.mehvahdjukaar.stone_zone.api.set.mud.MudTypeRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;

public class MudType
extends RockType {
    public final Block mud;

    protected MudType(ResourceLocation id, Block mud) {
        super(id, mud);
        this.mud = mud;
    }

    public String getTranslationKey() {
        return "mud_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeChildrenBlocks() {
        super.initializeChildrenBlocks();
        this.addChild("packed", this.findRelatedEntry("packed", (Registry)BuiltInRegistries.f_256975_));
    }

    @Override
    public ItemLike mainChild() {
        return this.mud;
    }

    public static Block findMud(ResourceLocation id) {
        ResourceLocation[] tests = MudType.makeKnownIDConventions(id, "", "mud");
        return (Block)Utils.findFirstInRegistry((Registry)BuiltInRegistries.f_256975_, (ResourceLocation[])tests);
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<MudType> {
        private Supplier<Block> mudFinder;

        public Finder(ResourceLocation id) {
            super(id, (BlockTypeRegistry)MudTypeRegistry.INSTANCE);
            this.mud(() -> MudType.findMud(id));
        }

        public Finder mud(Supplier<Block> mudFinder) {
            this.mudFinder = mudFinder;
            return this;
        }

        public Finder mud(ResourceLocation id) {
            return this.mud(() -> (Block)BuiltInRegistries.f_256975_.m_6612_(id).orElseThrow(() -> new IllegalStateException("Failed to find mud block: " + String.valueOf(id))));
        }

        public Finder mud(String nameMud) {
            return this.mud(Utils.idWithOptionalNamespace((String)nameMud, (String)this.id.m_135827_()));
        }

        public Finder mudAffix(String prefix, String suffix) {
            return this.mud(prefix + this.id.m_135815_() + suffix);
        }

        public Finder mudSuffix(String suffix) {
            return this.mud(this.id.m_135815_() + suffix);
        }

        @ApiStatus.Internal
        public Optional<MudType> get() {
            if (PlatHelper.isModLoaded((String)this.id.m_135827_())) {
                try {
                    Block mud = (Block)Preconditions.checkNotNull((Object)this.mudFinder.get(), (String)"Manual Finder - failed to find a mud block for {}", (Object)this.id);
                    MudType mudType = new MudType(this.id, mud);
                    this.childNames.forEach((key, value) -> {
                        try {
                            ItemLike obj = (ItemLike)Preconditions.checkNotNull((Object)((ItemLike)value.get()));
                            mudType.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            StoneZone.LOGGER.warn("Failed to get children for MudType: {} - {}. Ignored! ERROR: {}", (Object)this.id, key, (Object)e.getMessage());
                        }
                    });
                    return Optional.of(mudType);
                }
                catch (Exception e) {
                    StoneZone.LOGGER.warn("Failed to find custom MudType: {} - ", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }
    }
}

